/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import com.jfoenix.controls.JFXButton;
import electricpos.controller.MantProductoServicioViewController;
import electricpos.controller.ParametrosGeneController;
import electricpos.model.EmisorDto;
import electricpos.model.GlobalApp;
import electricpos.model.NotificacionType;
import electricpos.model.ProductoServicioDto;
import electricpos.model.ProductoServicioLte;
import electricpos.model.ProductoServicioTv;
import electricpos.model.SucursalEmisorDto;
import electricpos.service.EmisorService;
import electricpos.service.ProductoServicioService;
import electricpos.service.SucursalEmisorService;
import electricpos.util.AppContext;
import electricpos.util.ESTADO;
import electricpos.util.FuncionesGenerales;
import electricpos.util.NotificacionHelper;
import electricpos.util.Respuesta;
import java.io.IOException;
import java.net.URL;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;

public class ProductoServicioViewController
implements Initializable {
    @FXML
    JFXButton btnCrearPS;
    @FXML
    private Label lblTitulo;
    @FXML
    ComboBox<SucursalEmisorDto> cbxSucursal;
    @FXML
    ComboBox<EmisorDto> cbxEmisor;
    @FXML
    private TableView<ProductoServicioLte> tv_productoServicio;
    @FXML
    private TableColumn<ProductoServicioLte, String> tbcCodigo;
    @FXML
    private TableColumn<ProductoServicioLte, String> tbcTipo;
    @FXML
    private TableColumn<ProductoServicioLte, String> tbcUnidad;
    @FXML
    private TableColumn<ProductoServicioLte, String> tbcDetalle;
    @FXML
    private TableColumn<ProductoServicioLte, Number> tbcImpuesto;
    @FXML
    private TableColumn<ProductoServicioLte, Number> tbcPrecioUnidad;
    @FXML
    private TableColumn<ProductoServicioLte, Number> tbcPrecioImp;
    @FXML
    private TableColumn<ProductoServicioLte, Number> tbcStock;
    @FXML
    private TextField txtDescripcion;
    ObservableList<ProductoServicioTv> productosServiciosTv;
    ObservableList<ProductoServicioLte> productosServicios;
    ProductoServicioDto productosServicioSeleccionado;
    ObservableList<EmisorDto> emisoresLista;
    EmisorDto emisorSeleccionado = null;
    ObservableList<SucursalEmisorDto> sucursalLista;
    NumberFormat currencyFormat = NumberFormat.getInstance(Locale.ENGLISH);
    FuncionesGenerales funcionesGenerales = new FuncionesGenerales();
    String tipo;

    public void initialize(URL url, ResourceBundle rb) {
        this.cargarEmisores();
        if (GlobalApp.idEmisor != null) {
            EmisorDto emi = new EmisorDto();
            emi = this.cbxEmisor.getItems().stream().filter(c -> c.getId() == GlobalApp.idEmisor).findAny().orElse(null);
            this.cbxEmisor.getSelectionModel().select((Object)emi);
        }
        this.cargarSucursales(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId());
        if (GlobalApp.idSucursal != null) {
            SucursalEmisorDto suc = new SucursalEmisorDto();
            suc = this.cbxSucursal.getItems().stream().filter(c -> c.getId() == GlobalApp.idSucursal).findAny().orElse(null);
            this.cbxSucursal.getSelectionModel().select((Object)suc);
        }
        this.crearRelacionTv();
        if (!this.cbxEmisor.getSelectionModel().isEmpty() && !this.cbxSucursal.getSelectionModel().isEmpty()) {
            this.getProductosServicios(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId(), this.txtDescripcion.getText(), this.emisorSeleccionado.getInventarioCompartido(), ((SucursalEmisorDto)this.cbxSucursal.getSelectionModel().getSelectedItem()).getId());
        }
    }

    private void cargarSucursales(Integer IdEmisor) {
        SucursalEmisorService sucursalEmisorService = (SucursalEmisorService)AppContext.getInstance().get("SucursalEmisorService");
        Respuesta respuesta = sucursalEmisorService.getSucursalesEmi(IdEmisor);
        this.cbxSucursal.getItems().clear();
        if (respuesta.getEstado().booleanValue()) {
            this.sucursalLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("SucursalEmisor")));
            this.cbxSucursal.setItems(this.sucursalLista);
            this.cbxSucursal.getSelectionModel().selectFirst();
        }
    }

    @FXML
    private void OnBtnCrearPs(ActionEvent event) {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/MantProductoServicioView.fxml"));
        Parent root1 = null;
        try {
            root1 = (Parent)fxmlLoader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(ProductoServicioViewController.class.getName()).log(Level.SEVERE, null, ex);
        }
        MantProductoServicioViewController psViewController = (MantProductoServicioViewController)fxmlLoader.getController();
        psViewController.setCodigoDefecto(null);
        psViewController.setIdSucursalDefecto(((SucursalEmisorDto)this.cbxSucursal.getSelectionModel().getSelectedItem()).getId());
        psViewController.setNuevo(true);
        psViewController.setEmisor((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem());
        FuncionesGenerales.showView(root1);
    }

    @FXML
    private void onBtnBuscar(ActionEvent event) {
        this.getProductosServicios(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId(), this.txtDescripcion.getText(), this.emisorSeleccionado.getInventarioCompartido(), ((SucursalEmisorDto)this.cbxSucursal.getSelectionModel().getSelectedItem()).getId());
    }

    private void getProductosServicios(Integer idEmisor, String descripcion, String comparteInventario, Integer IdSucursal) {
        ProductoServicioService productoServicioService = (ProductoServicioService)AppContext.getInstance().get("ProductoServicioService");
        Respuesta respuesta = null;
        if (comparteInventario.equalsIgnoreCase("S")) {
            respuesta = productoServicioService.getProductoServicioNombre(idEmisor, descripcion, this.tipo, true);
        } else if (comparteInventario.equalsIgnoreCase("N")) {
            respuesta = productoServicioService.getProductoServicioSucursal(idEmisor, descripcion, IdSucursal, this.tipo, true);
        }
        if (respuesta.getEstado().booleanValue()) {
            this.productosServicios = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado(ESTADO.OK.VALUE())));
            this.tv_productoServicio.getItems().clear();
            this.tv_productoServicio.setItems(this.productosServicios);
        }
    }

    private void crearRelacionTv() {
        this.tbcCodigo.setCellValueFactory(cd -> ((ProductoServicioLte)cd.getValue()).codigo);
        this.tbcTipo.setCellValueFactory(cd -> ((ProductoServicioLte)cd.getValue()).tipo);
        this.tbcUnidad.setCellValueFactory(cd -> ((ProductoServicioLte)cd.getValue()).unidadMedida);
        this.tbcDetalle.setCellValueFactory(cd -> ((ProductoServicioLte)cd.getValue()).descripcion);
        this.tbcPrecioUnidad.setCellValueFactory(cd -> ((ProductoServicioLte)cd.getValue()).precioUnidad);
        this.tbcPrecioImp.setCellValueFactory(cd -> ((ProductoServicioLte)cd.getValue()).precioConImp);
        this.tbcStock.setCellValueFactory(cd -> ((ProductoServicioLte)cd.getValue()).existencia);
        this.tbcImpuesto.setCellValueFactory(cd -> ((ProductoServicioLte)cd.getValue()).montoImpuesto);
        this.tbcImpuesto.setCellFactory(tc -> new TableCell<ProductoServicioLte, Number>(){

            protected void updateItem(Number price, boolean empty) {
                super.updateItem((Object)price, empty);
                if (empty) {
                    this.setText(null);
                } else {
                    this.setText(ProductoServicioViewController.this.currencyFormat.format(price));
                }
            }
        });
    }

    private void cargarEmisores() {
        EmisorService emisorService = (EmisorService)AppContext.getInstance().get("EmisorService");
        Respuesta respuesta = emisorService.getEmisorIdEmpresa(GlobalApp.idEmpresa);
        if (respuesta.getEstado().booleanValue()) {
            this.emisoresLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("Emisores")));
            this.cbxEmisor.setItems(this.emisoresLista);
            this.cbxEmisor.getSelectionModel().selectFirst();
            this.emisorSeleccionado = (EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem();
        }
    }

    @FXML
    private void onCbxEmisorChanged(ActionEvent event) {
        if (!this.cbxEmisor.getSelectionModel().isEmpty()) {
            try {
                this.cargarSucursales(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.cbxSucursal.getSelectionModel().isEmpty()) {
                this.getProductosServicios(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId(), this.txtDescripcion.getText(), this.emisorSeleccionado.getInventarioCompartido(), ((SucursalEmisorDto)this.cbxSucursal.getSelectionModel().getSelectedItem()).getId());
            }
        }
    }

    @FXML
    private void onBtnVerEditar() {
        if (this.tv_productoServicio.getSelectionModel().getSelectedItem() != null) {
            this.productosServicioSeleccionado = this.getPsById(((ProductoServicioLte)this.tv_productoServicio.getSelectionModel().getSelectedItem()).getId());
            this.editarProductoServicio(this.productosServicioSeleccionado);
        }
    }

    @FXML
    private void onBtnVerEliminar() {
        if (this.tv_productoServicio.getSelectionModel().getSelectedItem() != null) {
            this.productosServicioSeleccionado = this.getPsById(((ProductoServicioLte)this.tv_productoServicio.getSelectionModel().getSelectedItem()).getId());
            if (this.funcionesGenerales.getConfirmacionEliminacion()) {
                ProductoServicioService service = (ProductoServicioService)AppContext.getInstance().get("ProductoServicioService");
                Respuesta respuesta = service.deleteProductoServicio(this.productosServicioSeleccionado.getId());
                if (respuesta.getEstado().booleanValue()) {
                    NotificacionHelper.dispararNotificacion(NotificacionType.SUCCESS, "Producto/Servicio eliminado correctamente.");
                } else {
                    NotificacionHelper.dispararNotificacion(NotificacionType.ERROR, "Ocurri\u00f3 un error al eliminar el Producto/Servicio, intente de nuevo.");
                }
                if (!this.cbxEmisor.getSelectionModel().isEmpty() && !this.cbxSucursal.getSelectionModel().isEmpty()) {
                    this.getProductosServicios(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId(), this.txtDescripcion.getText(), this.emisorSeleccionado.getInventarioCompartido(), ((SucursalEmisorDto)this.cbxSucursal.getSelectionModel().getSelectedItem()).getId());
                }
            }
        }
    }

    public void editarProductoServicio(ProductoServicioDto ps) {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/MantProductoServicioView.fxml"));
        Parent root1 = null;
        try {
            root1 = (Parent)fxmlLoader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(ParametrosGeneController.class.getName()).log(Level.SEVERE, null, ex);
        }
        MantProductoServicioViewController psViewController = (MantProductoServicioViewController)fxmlLoader.getController();
        psViewController.setNuevo(false);
        psViewController.setEmisor((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem());
        psViewController.setIdSucursalDefecto(((SucursalEmisorDto)this.cbxSucursal.getSelectionModel().getSelectedItem()).getId());
        psViewController.setCodigoDefecto(ps.getCodigo());
        psViewController.setPsSeleccionado(ps);
        FuncionesGenerales.showView(root1);
        if (!this.cbxEmisor.getSelectionModel().isEmpty() && !this.cbxSucursal.getSelectionModel().isEmpty()) {
            this.getProductosServicios(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId(), this.txtDescripcion.getText(), this.emisorSeleccionado.getInventarioCompartido(), ((SucursalEmisorDto)this.cbxSucursal.getSelectionModel().getSelectedItem()).getId());
        }
    }

    private ProductoServicioDto getPsById(int id) {
        ProductoServicioService service = (ProductoServicioService)AppContext.getInstance().get("ProductoServicioService");
        Respuesta respuesta = service.getProductoServicioId(id);
        ProductoServicioDto psDto = null;
        if (respuesta.getEstado().booleanValue()) {
            psDto = (ProductoServicioDto)respuesta.getResultado("ProductoServicio");
        } else {
            psDto = null;
            this.funcionesGenerales.MostrarModalInfo("No se pudo obtener los datos del producto/servicio.");
        }
        return psDto;
    }

    public String getTipo() {
        return this.tipo;
    }

    public void setTipo(String tipo) {
        this.tipo = tipo;
        if (tipo != null) {
            if (tipo.equalsIgnoreCase("P")) {
                this.lblTitulo.setText("Inventario de productos");
            } else {
                this.lblTitulo.setText("Inventario de servicios");
            }
            if (!this.cbxEmisor.getSelectionModel().isEmpty() && !this.cbxSucursal.getSelectionModel().isEmpty()) {
                this.getProductosServicios(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId(), this.txtDescripcion.getText(), this.emisorSeleccionado.getInventarioCompartido(), ((SucursalEmisorDto)this.cbxSucursal.getSelectionModel().getSelectedItem()).getId());
            }
        }
    }
}

