/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import electricpos.controller.FacturacionProformaViewController;
import electricpos.model.ComprobanteProformaDto;
import electricpos.model.DetalleComProformaDto;
import electricpos.model.DetalleComprobanteTv;
import electricpos.model.GlobalApp;
import electricpos.service.ProformaService;
import electricpos.util.AppContext;
import electricpos.util.ESTADO;
import electricpos.util.FuncionesGenerales;
import electricpos.util.Respuesta;
import java.io.IOException;
import java.net.URL;
import java.time.format.DateTimeFormatter;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;

public class ProformaResumenViewController
implements Initializable {
    @FXML
    private TableView<DetalleComprobanteTv> tv_detalleComprobante;
    @FXML
    private TableColumn<DetalleComprobanteTv, String> tbcDetalle;
    @FXML
    private TableColumn<DetalleComprobanteTv, Number> tbcCantidad;
    @FXML
    private TableColumn<DetalleComprobanteTv, Number> tbcPrecioUnidad;
    @FXML
    private TableColumn<DetalleComprobanteTv, Number> tbcDescuento;
    @FXML
    private TableColumn<DetalleComprobanteTv, Number> tbcTotalLinea;
    @FXML
    Label lblConsecutivo;
    @FXML
    Label lblIdentificacion;
    @FXML
    Label lblCorreo;
    @FXML
    Label lblCliente;
    @FXML
    Label lblFecha;
    @FXML
    Label lblSubTotal;
    @FXML
    Label lblTitulo;
    @FXML
    Label lblDescuentos;
    @FXML
    Label lblImpuestos;
    @FXML
    Label lblTotalcom;
    FuncionesGenerales funcionesGenerales = new FuncionesGenerales();
    Integer idProforma = null;
    ComprobanteProformaDto comprobanteSeleccionado = new ComprobanteProformaDto();

    public void initialize(URL url, ResourceBundle rb) {
        this.crearRelacionDetalle();
    }

    private void crearRelacionDetalle() {
        this.tv_detalleComprobante.setEditable(false);
        this.tbcDetalle.setCellValueFactory(cd -> ((DetalleComprobanteTv)cd.getValue()).detalle);
        this.tbcCantidad.setCellValueFactory(cd -> ((DetalleComprobanteTv)cd.getValue()).cantidad);
        this.tbcPrecioUnidad.setCellValueFactory(cd -> ((DetalleComprobanteTv)cd.getValue()).precioUnitario);
        this.tbcDescuento.setCellValueFactory(cd -> ((DetalleComprobanteTv)cd.getValue()).montoDescuento);
        this.tbcTotalLinea.setCellValueFactory(cd -> ((DetalleComprobanteTv)cd.getValue()).montoTotalLinea);
    }

    @FXML
    private void onBtnCerrar() {
        Stage stage = (Stage)this.lblConsecutivo.getScene().getWindow();
        stage.hide();
    }

    @FXML
    private void onBtnEditar() {
        try {
            ComprobanteProformaDto proformaDto = this.getProformId(this.idProforma);
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/FacturacionProformaView.fxml"));
            AnchorPane ancho = (AnchorPane)fxmlLoader.load();
            FacturacionProformaViewController controller = (FacturacionProformaViewController)fxmlLoader.getController();
            controller.cargarProforma(proformaDto);
            controller.setTipoComprobanteGlobal("01");
            GlobalApp.panelPrincipalGlobal.getChildren().setAll((Object[])new Node[]{ancho});
            Stage stage = (Stage)this.lblConsecutivo.getScene().getWindow();
            stage.hide();
        }
        catch (IOException ex) {
            Logger.getLogger(ProformaResumenViewController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private String stringOf(Integer var) {
        String string = null;
        try {
            string = String.valueOf(var);
        }
        catch (Exception ex) {
            string = "";
        }
        return string;
    }

    private String stringOf(String var) {
        String string = null;
        try {
            string = String.valueOf(var);
        }
        catch (Exception ex) {
            string = "-";
        }
        return string;
    }

    private Integer getIntergerOf(String value) {
        Integer response;
        try {
            response = Integer.valueOf(value);
        }
        catch (Exception ex) {
            response = null;
        }
        return response;
    }

    public Integer getIdProforma() {
        return this.idProforma;
    }

    public void setIdProforma(Integer idProforma) {
        this.idProforma = idProforma;
        if (idProforma != null) {
            this.comprobanteSeleccionado = this.getProformId(idProforma);
            if (this.comprobanteSeleccionado != null) {
                this.lblConsecutivo.setText(this.comprobanteSeleccionado.getId().toString());
                this.lblTitulo.setText("Proforma N\u00b0:");
                if (this.comprobanteSeleccionado.getReceptor() != null) {
                    this.lblIdentificacion.setText(this.stringOf(this.comprobanteSeleccionado.getReceptor().getNumeroIdentificacion()));
                    this.lblCorreo.setText(this.stringOf(this.comprobanteSeleccionado.getReceptor().getCorreo()));
                    this.lblCliente.setText(this.stringOf(this.comprobanteSeleccionado.getReceptor().getNombre()));
                }
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd hh:mm:ss a");
                this.lblFecha.setText(this.comprobanteSeleccionado.getFechaEmision().format(formatter));
                this.lblSubTotal.setText(this.comprobanteSeleccionado.getTotalVentaResumen().toString());
                this.lblDescuentos.setText(this.comprobanteSeleccionado.getTotalDescuentosResumen().toString());
                this.lblImpuestos.setText(this.comprobanteSeleccionado.getMontoImpuestoResumen().toString());
                this.lblTotalcom.setText(this.comprobanteSeleccionado.getTotalComprobanteResumen().toString());
                try {
                    for (DetalleComProformaDto det : this.comprobanteSeleccionado.getListaDetalleComprobantes()) {
                        DetalleComprobanteTv nuevo = new DetalleComprobanteTv();
                        nuevo.detalle.set(det.getDetalle());
                        nuevo.cantidad.set(det.getCantidad().doubleValue());
                        nuevo.precioUnitario.set(det.getPrecioUnitario().doubleValue());
                        try {
                            nuevo.montoDescuento.set(det.getMontoDescuento().doubleValue());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        nuevo.montoTotalLinea.set(det.getMontoTotalLinea().doubleValue());
                        this.tv_detalleComprobante.getItems().add((Object)nuevo);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private ComprobanteProformaDto getProformId(Integer id) {
        ProformaService service = (ProformaService)AppContext.getInstance().get("ProformaService");
        Respuesta respuesta = service.getProformaId(id);
        ComprobanteProformaDto comprobanteDto = null;
        if (respuesta.getEstado().booleanValue()) {
            comprobanteDto = (ComprobanteProformaDto)respuesta.getResultado(ESTADO.OK.VALUE());
        } else {
            comprobanteDto = null;
            this.funcionesGenerales.MostrarModalInfo("Error: no se pudo obtener los datos del comprobante.");
        }
        return comprobanteDto;
    }
}

