/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import electricpos.controller.FacturacionViewController;
import electricpos.controller.ParametrosGeneController;
import electricpos.controller.ProformaResumenViewController;
import electricpos.controller.ReenvioCorreoViewController;
import electricpos.controller.WaitingViewController;
import electricpos.model.ComprobanteElectronicoDto;
import electricpos.model.ComprobanteProformaDto;
import electricpos.model.ComprobanteResumenDto;
import electricpos.model.EmisorDto;
import electricpos.model.FacturasTv;
import electricpos.model.GlobalApp;
import electricpos.model.SucursalEmisorDto;
import electricpos.service.EmisorService;
import electricpos.service.ProformaService;
import electricpos.service.SucursalEmisorService;
import electricpos.util.AppContext;
import electricpos.util.ESTADO;
import electricpos.util.FuncionesGenerales;
import electricpos.util.Respuesta;
import java.io.IOException;
import java.net.URL;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.layout.AnchorPane;

public class ProformasViewController
implements Initializable {
    ObservableList<FacturasTv> facturasTv;
    ObservableList<ComprobanteResumenDto> facturas;
    public ComprobanteResumenDto facturaSeleccionada = new ComprobanteResumenDto();
    EmisorDto emisorSeleccionado = null;
    ObservableList<EmisorDto> emisoresLista;
    ObservableList<SucursalEmisorDto> sucursalLista;
    @FXML
    ComboBox<EmisorDto> cbxEmisor;
    @FXML
    TextField txtCliente;
    @FXML
    ComboBox<SucursalEmisorDto> cbxSucursal;
    @FXML
    DatePicker dpFechaIni;
    @FXML
    DatePicker dpFechaFin;
    public String tipoComprobante;
    @FXML
    private TableView<FacturasTv> tv_facturas;
    @FXML
    private TableColumn<FacturasTv, String> tbcCodigo;
    @FXML
    private TableColumn<FacturasTv, String> tbcFecha;
    @FXML
    private TableColumn<FacturasTv, String> tbcCliente;
    @FXML
    private TableColumn<FacturasTv, Number> tbcTotal;
    FuncionesGenerales funcionesGenerales = new FuncionesGenerales();

    public void initialize(URL url, ResourceBundle rb) {
        this.crearRelacionTv();
        this.cargarEmisores();
        if (GlobalApp.idEmisor != null) {
            EmisorDto emi = new EmisorDto();
            emi = this.cbxEmisor.getItems().stream().filter(c -> c.getId() == GlobalApp.idEmisor).findAny().orElse(null);
            this.cbxEmisor.getSelectionModel().select((Object)emi);
        }
        this.cargarSucursales(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId());
        if (GlobalApp.idSucursal != null) {
            SucursalEmisorDto suc = new SucursalEmisorDto();
            suc = this.cbxSucursal.getItems().stream().filter(c -> c.getId() == GlobalApp.idSucursal).findAny().orElse(null);
            this.cbxSucursal.getSelectionModel().select((Object)suc);
        }
        Date date = new Date();
        Instant instant = date.toInstant();
        LocalDate localDate = instant.atZone(ZoneId.systemDefault()).toLocalDate();
        this.dpFechaIni.setValue((Object)localDate);
        this.dpFechaFin.setValue((Object)localDate);
    }

    private void cargarEmisores() {
        EmisorService emisorService = (EmisorService)AppContext.getInstance().get("EmisorService");
        Respuesta respuesta = emisorService.getEmisorIdEmpresa(GlobalApp.idEmpresa);
        if (respuesta.getEstado().booleanValue()) {
            this.emisoresLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("Emisores")));
            this.cbxEmisor.setItems(this.emisoresLista);
            this.cbxEmisor.getSelectionModel().selectFirst();
        }
    }

    @FXML
    private void onBtnVerFactura(ActionEvent event) {
        if (this.tv_facturas.getSelectionModel().getSelectedItem() != null) {
            this.mostrarVerFactura(((FacturasTv)this.tv_facturas.getSelectionModel().getSelectedItem()).getFactura().getId());
        } else {
            this.funcionesGenerales.MostrarModalInfo("Debe de seleccionar un comprobante.");
        }
    }

    @FXML
    private void onBtnReenviarCorreo(ActionEvent event) {
        if (this.tv_facturas.getSelectionModel().getSelectedItem() != null) {
            this.mostrarReenvioCorreo(((FacturasTv)this.tv_facturas.getSelectionModel().getSelectedItem()).getFactura().getId());
        } else {
            this.funcionesGenerales.MostrarModalInfo("Debe de seleccionar un comprobante.");
        }
    }

    @FXML
    private void onBtnEliminarProforma(ActionEvent event) {
        if (this.tv_facturas.getSelectionModel().getSelectedItem() != null) {
            if (this.funcionesGenerales.getConfirmacionMensajeView("\u00bfEsta seguro de eliminar la proforma?")) {
                ProformaService proformaService = (ProformaService)AppContext.getInstance().get("ProformaService");
                Respuesta respuesta = proformaService.removeProformaId(((FacturasTv)this.tv_facturas.getSelectionModel().getSelectedItem()).getFactura().getId());
                if (respuesta.getEstado().booleanValue()) {
                    this.funcionesGenerales.MostrarModalInfo("Proforma eliminada correctamente.");
                } else {
                    this.funcionesGenerales.MostrarModalInfo("Error al intentar elimimar la proforma, intente m\u00e1s tarde.");
                }
                this.getProformas(((SucursalEmisorDto)this.cbxSucursal.getSelectionModel().getSelectedItem()).getId(), this.txtCliente.getText());
            }
        } else {
            this.funcionesGenerales.MostrarModalInfo("Debe de seleccionar un comprobante.");
        }
    }

    @FXML
    private void onBtnFacturar(ActionEvent event) throws IOException {
        if (this.tv_facturas.getSelectionModel().getSelectedItem() != null) {
            ComprobanteProformaDto proformaDto = this.getProformId(((FacturasTv)this.tv_facturas.getSelectionModel().getSelectedItem()).getFactura().getId());
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/FacturacionView.fxml"));
            AnchorPane ancho = (AnchorPane)fxmlLoader.load();
            FacturacionViewController controller = (FacturacionViewController)fxmlLoader.getController();
            controller.setTipoComprobanteGlobal("01");
            controller.cargarProforma(proformaDto);
            GlobalApp.panelPrincipalGlobal.getChildren().setAll((Object[])new Node[]{ancho});
        } else {
            this.funcionesGenerales.MostrarModalInfo("Debe de seleccionar un comprobante.");
        }
    }

    private ComprobanteProformaDto getProformId(Integer id) {
        ProformaService service = (ProformaService)AppContext.getInstance().get("ProformaService");
        Respuesta respuesta = service.getProformaId(id);
        ComprobanteProformaDto comprobanteDto = null;
        if (respuesta.getEstado().booleanValue()) {
            comprobanteDto = (ComprobanteProformaDto)respuesta.getResultado(ESTADO.OK.VALUE());
        } else {
            comprobanteDto = null;
            this.funcionesGenerales.MostrarModalInfo("Error: no se pudo obtener los datos del comprobante.");
        }
        return comprobanteDto;
    }

    public void mostrarReenvioCorreo(Integer idComp) {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/ReenvioCorreoView.fxml"));
        Parent root1 = null;
        try {
            root1 = (Parent)fxmlLoader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(ParametrosGeneController.class.getName()).log(Level.SEVERE, null, ex);
        }
        ReenvioCorreoViewController controller = (ReenvioCorreoViewController)fxmlLoader.getController();
        controller.setFuncion(ESTADO.PROFORMA.VALUE());
        controller.setIdComprobante(idComp);
        FuncionesGenerales.showView(root1);
    }

    public void mostrarVerFactura(Integer id) {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/ProformaResumenView.fxml"));
        Parent root1 = null;
        try {
            root1 = (Parent)fxmlLoader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(ParametrosGeneController.class.getName()).log(Level.SEVERE, null, ex);
        }
        ProformaResumenViewController controller = (ProformaResumenViewController)fxmlLoader.getController();
        controller.setIdProforma(id);
        FuncionesGenerales.showView(root1);
    }

    @FXML
    private void onBtnBuscar(ActionEvent event) {
        this.getProformas(((SucursalEmisorDto)this.cbxSucursal.getSelectionModel().getSelectedItem()).getId(), this.txtCliente.getText());
    }

    @FXML
    private void onCbxEmisorChanged(ActionEvent event) {
        this.cargarSucursales(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId());
    }

    private void crearRelacionTv() {
        this.tbcCodigo.setCellValueFactory(cd -> ((FacturasTv)cd.getValue()).codigo);
        this.tbcFecha.setCellValueFactory(cd -> ((FacturasTv)cd.getValue()).fecha);
        this.tbcCliente.setCellValueFactory(cd -> ((FacturasTv)cd.getValue()).cliente);
        this.tbcTotal.setCellValueFactory(cd -> ((FacturasTv)cd.getValue()).montoTotal);
    }

    private void getProformas(Integer idSucursal, String cliente) {
        ProformaService comprobanteService = (ProformaService)AppContext.getInstance().get("ProformaService");
        Respuesta respuesta = comprobanteService.getComprobanteFiltro(idSucursal, ((LocalDate)this.dpFechaIni.getValue()).toString(), ((LocalDate)this.dpFechaFin.getValue()).toString(), cliente);
        if (respuesta.getEstado().booleanValue()) {
            this.facturas = null;
            this.facturas = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado(ESTADO.OK.VALUE())));
            this.tv_facturas.getItems().clear();
            this.tv_facturas.setItems(this.converterTv(this.facturas));
        } else {
            this.facturas = null;
        }
    }

    private ObservableList<FacturasTv> converterTv(ObservableList<ComprobanteResumenDto> facturas) {
        ObservableList facturasTv = FXCollections.observableArrayList();
        for (ComprobanteResumenDto compDto : facturas) {
            FacturasTv compTv = new FacturasTv(compDto);
            facturasTv.add((Object)compTv);
        }
        return facturasTv;
    }

    private void cargarSucursales(Integer IdEmisor) {
        SucursalEmisorService sucursalEmisorService = (SucursalEmisorService)AppContext.getInstance().get("SucursalEmisorService");
        Respuesta respuesta = sucursalEmisorService.getSucursalesEmi(IdEmisor);
        this.cbxSucursal.getItems().clear();
        if (respuesta.getEstado().booleanValue()) {
            this.sucursalLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("SucursalEmisor")));
            this.cbxSucursal.setItems(this.sucursalLista);
            this.cbxSucursal.getSelectionModel().selectFirst();
        }
    }

    public void setTipoComprobante(String tipoComprobante) {
        this.tipoComprobante = tipoComprobante;
    }

    public boolean mostrarComprobanteHilo(ComprobanteElectronicoDto comp) {
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/WaitingView.fxml"));
            AnchorPane ancho = (AnchorPane)fxmlLoader.load();
            FuncionesGenerales.procesaVBoxNotificaciones();
            GlobalApp.vBoxNotificaciones.setVisible(true);
            GlobalApp.vBoxNotificaciones.getChildren().add((Object)ancho);
            WaitingViewController waitingViewController = (WaitingViewController)fxmlLoader.getController();
            waitingViewController.setAnchorPane(ancho);
            waitingViewController.setTipo(comp.getTipoCom());
            waitingViewController.setComprobanteElectronicoDto(comp);
            waitingViewController.enviarComprobanteElectronico();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

