/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import com.jfoenix.controls.JFXTabPane;
import com.jfoenix.controls.JFXTextArea;
import electricpos.controller.WaitingViewController;
import electricpos.model.CodigoConfirmacionDto;
import electricpos.model.ComprobanteRecepcionDto;
import electricpos.model.DetalleComprobanteTv;
import electricpos.model.EmisorDto;
import electricpos.model.GlobalApp;
import electricpos.service.EmisorService;
import electricpos.util.AppContext;
import electricpos.util.ComprobanteElectronico;
import electricpos.util.FuncionesGenerales;
import electricpos.util.Mensaje;
import electricpos.util.ReaderXmlHelper;
import electricpos.util.Respuesta;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RecepcionComprobanteViewController
implements Initializable {
    @FXML
    private TableView<DetalleComprobanteTv> tv_detalleComprobante;
    @FXML
    private TableColumn<DetalleComprobanteTv, String> tbcDetalle;
    @FXML
    private TableColumn<DetalleComprobanteTv, Number> tbcCantidad;
    @FXML
    private TableColumn<DetalleComprobanteTv, Number> tbcPrecioUnidad;
    @FXML
    private TableColumn<DetalleComprobanteTv, Number> tbcDescuento;
    @FXML
    private TableColumn<DetalleComprobanteTv, Number> tbcTotalLinea;
    ObservableList<EmisorDto> emisoresLista;
    ObservableList<CodigoConfirmacionDto> codigoConfirmacionLista;
    private ComprobanteElectronico comprobanteCargado = new ComprobanteElectronico();
    private static String tipo;
    private File comprobanteFile;
    @FXML
    private Label txtTipoComprobante;
    @FXML
    private Label lblTotalComp;
    @FXML
    private Label lblImpuestos;
    @FXML
    private Label lblNombreConf;
    @FXML
    private Label lblIdentificacionConf;
    @FXML
    private Label lblClaveConf;
    @FXML
    private Label lblImpuestoConf;
    @FXML
    private Label lblTotalConf;
    @FXML
    private JFXTabPane tabRecepcion;
    @FXML
    private JFXTextArea txaDetalleMensaje;
    @FXML
    private TextField txtNombreArchivo;
    @FXML
    private TextField txtClave;
    @FXML
    private TextField txtConsecutivo;
    @FXML
    private TextField txtFecha;
    @FXML
    private TextField txtPlazoCredito;
    @FXML
    private TextField txtNombreEmi;
    @FXML
    private TextField txtIdentificacionEmi;
    @FXML
    private TextField txtCorreoEmi;
    @FXML
    private TextField txtTelefonoEmi;
    @FXML
    private TextField txtNombreRec;
    @FXML
    private TextField txtIdentificacionRec;
    @FXML
    private TextField txtCorreoRec;
    @FXML
    private TextField txtTipoCambio;
    @FXML
    private TextField txtMoneda;
    @FXML
    private TextField txtGravado;
    @FXML
    private TextField txtExento;
    @FXML
    private TextField txtVenta;
    @FXML
    private TextField txtDescuento;
    @FXML
    private TextField txtVentaNeta;
    @FXML
    ComboBox<EmisorDto> cbxEmisor;
    @FXML
    Text txtRespuesta;
    @FXML
    ComboBox<CodigoConfirmacionDto> cbxAccion;
    @FXML
    private VBox vbxEstadoEnvio;
    @FXML
    private Tab tabDetalle;
    @FXML
    private Tab tabConfirmacion;
    @FXML
    private Tab tabEnvio;
    FuncionesGenerales funcionesGenerales = new FuncionesGenerales();

    public void initialize(URL url, ResourceBundle rb) {
        this.cargarEmisores();
        this.cargarCodigosConfirmacion();
        this.crearRelacionDetalle();
    }

    @FXML
    private void btnSeleccionarArchivo() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Elegir archivo de factura");
        fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("Archivo XML", new String[]{"*.xml"})});
        this.comprobanteFile = fileChooser.showOpenDialog((Window)((Stage)this.txtTipoComprobante.getScene().getWindow()));
        if (this.comprobanteFile != null) {
            this.txtNombreArchivo.setText(this.comprobanteFile.getName());
            this.leerTipo();
        } else {
            Mensaje.getInstance().showModal(Alert.AlertType.ERROR, "Seleccionar Archivo", (Window)((Stage)this.txtTipoComprobante.getScene().getWindow()), "No se seleccion\u00f3 ningun archivo.");
        }
    }

    private void cargarEmisores() {
        EmisorService emisorService = (EmisorService)AppContext.getInstance().get("EmisorService");
        Respuesta respuesta = emisorService.getEmisorIdEmpresa(GlobalApp.idEmpresa);
        if (respuesta.getEstado().booleanValue()) {
            this.emisoresLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("Emisores")));
            this.cbxEmisor.setItems(this.emisoresLista);
            this.cbxEmisor.getSelectionModel().selectFirst();
        }
    }

    private void cargarCodigosConfirmacion() {
        this.codigoConfirmacionLista = FXCollections.observableArrayList();
        CodigoConfirmacionDto codigoAceptado = new CodigoConfirmacionDto(1, "Aceptado");
        CodigoConfirmacionDto codigoAceptadoParcial = new CodigoConfirmacionDto(2, "Aceptado parcialmente");
        CodigoConfirmacionDto codigoRechazado = new CodigoConfirmacionDto(3, "Rechazado");
        this.codigoConfirmacionLista.add((Object)codigoAceptado);
        this.codigoConfirmacionLista.add((Object)codigoAceptadoParcial);
        this.codigoConfirmacionLista.add((Object)codigoRechazado);
        this.cbxAccion.setItems(this.codigoConfirmacionLista);
        this.cbxAccion.getSelectionModel().selectFirst();
    }

    @FXML
    private void onBtnValidar() {
        if (this.txtNombreArchivo.getText().isEmpty()) {
            this.txtNombreArchivo.setFocusTraversable(true);
            this.funcionesGenerales.MostrarModalInfo("Es necesario seleccionar el archivo a validar.");
        } else {
            this.leerXmlRespuesta();
        }
    }

    @FXML
    private void onBtnVerEncabezado() {
        this.tabRecepcion.getSelectionModel().select(0);
    }

    @FXML
    private void onBtnVerDetalle() {
        if (this.txtNombreArchivo.getText().isEmpty()) {
            this.txtNombreArchivo.setFocusTraversable(true);
            this.funcionesGenerales.MostrarModalInfo("Es necesario seleccionar el archivo a validar.");
        } else {
            this.tabDetalle.setDisable(false);
            this.tabRecepcion.getSelectionModel().select(1);
        }
    }

    @FXML
    private void onBtnConfirmacion() {
        this.tabConfirmacion.setDisable(false);
        this.tabRecepcion.getSelectionModel().select(2);
    }

    @FXML
    private void onBtnNuevaRecepcion() {
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/RecepcionComprobanteView.fxml"));
            AnchorPane ancho = (AnchorPane)fxmlLoader.load();
            GlobalApp.panelPrincipalGlobal.getChildren().setAll((Object[])new Node[]{ancho});
        }
        catch (IOException ex) {
            Logger.getLogger(RecepcionComprobanteViewController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void onBtnGuardarConfirmacion() {
        if (((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getNumeroIdentificacion().equalsIgnoreCase(this.comprobanteCargado.getReceptor().getIdentificacion().getNumero())) {
            this.tabEnvio.setDisable(false);
            ComprobanteRecepcionDto comp = new ComprobanteRecepcionDto();
            comp.setVersion(GlobalApp.parametrosSistema.getVersionDoc());
            comp.setTipo(this.getTipoComprobante(tipo));
            comp.setEmisor((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem());
            comp.setCodigoActividad(this.comprobanteCargado.getCodigoActividad());
            comp.setClave(this.comprobanteCargado.getClave());
            comp.setConsecutivo(this.comprobanteCargado.getNumeroConsecutivo());
            comp.setFechaComprobante(this.comprobanteCargado.getFechaEmision());
            comp.setCodigoMensje(((CodigoConfirmacionDto)this.cbxAccion.getSelectionModel().getSelectedItem()).getCodigo().toString());
            comp.setDetalleMensaje(this.txaDetalleMensaje.getText());
            try {
                if (this.comprobanteCargado.getResumenFactura().getTotalImpuesto() != null) {
                    comp.setTotalImpuesto(this.comprobanteCargado.getResumenFactura().getTotalImpuesto());
                } else {
                    comp.setTotalImpuesto(new BigDecimal(0).setScale(5, RoundingMode.HALF_UP));
                }
            }
            catch (Exception ex) {
                comp.setTotalImpuesto(new BigDecimal(0).setScale(5, RoundingMode.HALF_UP));
            }
            comp.setTotalComprobante(this.comprobanteCargado.getResumenFactura().getTotalComprobante());
            comp.setTipoIdEmisor(this.comprobanteCargado.getEmisor().getIdentificacion().getTipo());
            comp.setIdentificacionEmisor(this.comprobanteCargado.getEmisor().getIdentificacion().getNumero());
            comp.setNombreEmisor(this.comprobanteCargado.getEmisor().getNombre());
            comp.setCorreoEmisor(this.comprobanteCargado.getEmisor().getCorreoElectronico());
            try {
                comp.setCorreoEmisor(this.comprobanteCargado.getEmisor().getCorreoElectronico());
            }
            catch (Exception ex) {
                comp.setCorreoEmisor(null);
            }
            try {
                comp.setTelefonoEmisor(this.comprobanteCargado.getEmisor().getTelefono().getNumTelefono().toString());
            }
            catch (Exception ex) {
                comp.setTelefonoEmisor(null);
            }
            comp.setTipoIdReceptor(this.comprobanteCargado.getReceptor().getIdentificacion().getTipo());
            comp.setIdentificacionReceptor(this.comprobanteCargado.getReceptor().getIdentificacion().getNumero());
            comp.setEstado("A");
            this.mostrarComprobanteRecepcionHilo(comp);
            this.tabRecepcion.getSelectionModel().select(3);
        } else {
            this.funcionesGenerales.MostrarModalInfo("El receptor del comprobante a confirmar no coincide con el emisor de la confirmaci\u00f3n.");
        }
    }

    public boolean mostrarComprobanteRecepcionHilo(ComprobanteRecepcionDto comp) {
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/WaitingView.fxml"));
            AnchorPane ancho = (AnchorPane)fxmlLoader.load();
            this.vbxEstadoEnvio.getChildren().add((Object)ancho);
            WaitingViewController waitingViewController = (WaitingViewController)fxmlLoader.getController();
            waitingViewController.setAnchorPane(ancho);
            waitingViewController.setCodigoMensaje(comp.getCodigoMensje());
            waitingViewController.setComprobanteRecepcionDto(comp);
            waitingViewController.setTxtRespuesta(this.txtRespuesta);
            waitingViewController.enviarComprobanteRecepcion();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    private void leerTipo() {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = dbf.newDocumentBuilder();
            Document document = documentBuilder.parse(this.comprobanteFile);
            document.getDocumentElement().normalize();
            tipo = document.getDocumentElement().getNodeName();
            this.txtTipoComprobante.setText(tipo);
        }
        catch (ParserConfigurationException ex) {
            Mensaje.getInstance().showModal(Alert.AlertType.ERROR, "Cargar Archivo", (Window)((Stage)this.txtTipoComprobante.getScene().getWindow()), "Error al verificar el tipo de archivo cargado: " + ex.getMessage() + ".");
        }
        catch (IOException | SAXException ex) {
            Logger.getLogger(RecepcionComprobanteViewController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void leerXmlRespuesta() {
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(this.comprobanteFile));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line.trim());
            }
            String decodedString = sb.toString();
            DocumentBuilder dBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            decodedString = decodedString.trim().replaceFirst("^([\\W]+)<", "<");
            Document doc = dBuilder.parse(new InputSource(new ByteArrayInputStream(decodedString.getBytes("UTF-8"))));
            ReaderXmlHelper xmlHelper = new ReaderXmlHelper();
            this.comprobanteCargado = xmlHelper.readXmlToComprobante(doc);
            if (this.comprobanteValido(this.comprobanteCargado)) {
                this.llenarInfoComprobante(this.comprobanteCargado);
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            this.funcionesGenerales.MostrarModalInfo(e.getMessage());
        }
    }

    private boolean comprobanteValido(ComprobanteElectronico com) {
        boolean valido = true;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Documento no v\u00e1lido para recepci\u00f3n: \n \n");
        if (com.getClave() == null) {
            stringBuilder.append("* El documento no cuenta con clave num\u00e9rica. \n");
            valido = false;
        }
        if (com.getEmisor() == null) {
            stringBuilder.append("* El documento no cuenta con un emisor. \n");
            valido = false;
        } else if (com.getEmisor().getIdentificacion() == null) {
            stringBuilder.append("* El emisor no cuenta con el nodo de identificaci\u00f3n. \n");
            valido = false;
        } else {
            if (com.getEmisor().getIdentificacion().getTipo() == null) {
                stringBuilder.append("* No exite un tipo de identificaci\u00f3n para el emisor. \n");
                valido = false;
            }
            if (com.getEmisor().getIdentificacion().getNumero() == null) {
                stringBuilder.append("* No exite un n\u00famero de identificaci\u00f3n para el emisor. \n");
                valido = false;
            }
        }
        if (com.getReceptor() == null) {
            stringBuilder.append("* El documento no cuenta con un receptor. \n");
            valido = false;
        } else if (com.getReceptor().getIdentificacion() == null) {
            stringBuilder.append("* El receptor no cuenta con el nodo de identificaci\u00f3n. \n");
            valido = false;
        } else {
            if (com.getReceptor().getIdentificacion().getTipo() == null) {
                stringBuilder.append("* No exite un tipo de identificaci\u00f3n para el receptor. \n");
                valido = false;
            }
            if (com.getReceptor().getIdentificacion().getNumero() == null) {
                stringBuilder.append("* No exite un n\u00famero de identificaci\u00f3n para el receptor. \n");
                valido = false;
            }
        }
        if (com.getResumenFactura().getTotalComprobante() == null) {
            stringBuilder.append("* El documento no cuenta con el nodo Total del comprobante. \n");
            valido = false;
        }
        if (!valido) {
            this.funcionesGenerales.MostrarModalInfo(stringBuilder.toString());
        }
        return valido;
    }

    private void llenarInfoComprobante(ComprobanteElectronico com) {
        if (com != null) {
            this.txtClave.setText(this.stringOf(com.getClave()));
            this.txtConsecutivo.setText(this.stringOf(com.getNumeroConsecutivo()));
            this.txtFecha.setText(this.stringOf(com.getFechaEmision()));
            this.txtPlazoCredito.setText(this.stringOf(com.getPlazoCredito()));
            this.txtNombreEmi.setText(this.stringOf(com.getEmisor().getNombre()));
            this.txtIdentificacionEmi.setText(this.stringOf(com.getEmisor().getIdentificacion().getNumero()));
            this.txtCorreoEmi.setText(this.stringOf(com.getEmisor().getCorreoElectronico()));
            if (com.getEmisor().getTelefono() != null) {
                this.txtTelefonoEmi.setText(this.stringOf(com.getEmisor().getTelefono().getNumTelefono()));
            }
            this.txtNombreRec.setText(this.stringOf(com.getReceptor().getNombre()));
            this.txtIdentificacionRec.setText(this.stringOf(com.getReceptor().getIdentificacion().getNumero()));
            this.txtCorreoRec.setText(this.stringOf(com.getReceptor().getCorreoElectronico()));
            try {
                for (ComprobanteElectronico.DetalleServicio.LineaDetalle det : com.getDetalleServicio().getLineaDetalle()) {
                    DetalleComprobanteTv nuevo = new DetalleComprobanteTv();
                    nuevo.detalle.set(det.getDetalle());
                    nuevo.cantidad.set(det.getCantidad().doubleValue());
                    nuevo.precioUnitario.set(det.getPrecioUnitario().doubleValue());
                    try {
                        nuevo.montoDescuento.set(det.getMontoDescuento().doubleValue());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    nuevo.montoTotalLinea.set(det.getMontoTotalLinea().doubleValue());
                    this.tv_detalleComprobante.getItems().add((Object)nuevo);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.txtTipoCambio.setText(this.stringOf(com.getResumenFactura().getTipoCambio()));
            this.txtMoneda.setText(this.stringOf(com.getResumenFactura().getCodigoMoneda()));
            this.txtGravado.setText(this.stringOf(com.getResumenFactura().getTotalGravado()));
            this.txtExento.setText(this.stringOf(com.getResumenFactura().getTotalExento()));
            this.txtVenta.setText(this.stringOf(com.getResumenFactura().getTotalVenta()));
            this.txtDescuento.setText(this.stringOf(com.getResumenFactura().getTotalDescuentos()));
            this.txtVentaNeta.setText(this.stringOf(com.getResumenFactura().getTotalVentaNeta()));
            this.lblTotalComp.setText(this.stringOf(com.getResumenFactura().getTotalComprobante()));
            try {
                this.lblImpuestos.setText(this.stringOf(com.getResumenFactura().getTotalImpuesto()));
            }
            catch (Exception ex) {
                this.lblImpuestos.setText("0.00");
            }
            this.lblNombreConf.setText(this.stringOf(com.getEmisor().getNombre()));
            this.lblIdentificacionConf.setText(this.stringOf(com.getEmisor().getIdentificacion().getNumero()));
            this.lblClaveConf.setText(this.stringOf(com.getClave()));
            this.lblImpuestoConf.setText(this.stringOf(com.getResumenFactura().getTotalImpuesto()));
            this.lblTotalConf.setText(this.stringOf(com.getResumenFactura().getTotalComprobante()));
        }
    }

    private String stringOf(Integer var) {
        String string = null;
        try {
            string = String.valueOf(var);
        }
        catch (Exception ex) {
            string = "";
        }
        return string;
    }

    private String stringOf(BigDecimal var) {
        String string = null;
        try {
            string = String.valueOf(var);
        }
        catch (Exception ex) {
            string = "";
        }
        return string;
    }

    private String stringOf(BigInteger var) {
        String string = null;
        try {
            string = String.valueOf(var);
        }
        catch (Exception ex) {
            string = "";
        }
        return string;
    }

    private String stringOf(String var) {
        String string = null;
        try {
            string = String.valueOf(var);
        }
        catch (Exception ex) {
            string = "";
        }
        return string;
    }

    private String getTipoComprobante(String tipo) {
        if (tipo.equals("FacturaElectronica")) {
            return "01";
        }
        if (tipo.equals("NotaCreditoElectronica")) {
            return "03";
        }
        if (tipo.equals("NotaDebitoElectronica")) {
            return "02";
        }
        if (tipo.equals("TiqueteElectronico")) {
            return "04";
        }
        return null;
    }

    private void crearRelacionDetalle() {
        this.tv_detalleComprobante.setEditable(false);
        this.tbcDetalle.setCellValueFactory(cd -> ((DetalleComprobanteTv)cd.getValue()).detalle);
        this.tbcCantidad.setCellValueFactory(cd -> ((DetalleComprobanteTv)cd.getValue()).cantidad);
        this.tbcPrecioUnidad.setCellValueFactory(cd -> ((DetalleComprobanteTv)cd.getValue()).precioUnitario);
        this.tbcDescuento.setCellValueFactory(cd -> ((DetalleComprobanteTv)cd.getValue()).montoDescuento);
        this.tbcTotalLinea.setCellValueFactory(cd -> ((DetalleComprobanteTv)cd.getValue()).montoTotalLinea);
    }
}

