/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import electricpos.controller.MantReceptorViewController;
import electricpos.controller.ParametrosGeneController;
import electricpos.model.EmisorDto;
import electricpos.model.GlobalApp;
import electricpos.model.ReceptorDto;
import electricpos.model.ReceptorTv;
import electricpos.service.EmisorService;
import electricpos.service.ReceptorService;
import electricpos.util.AppContext;
import electricpos.util.ESTADO;
import electricpos.util.FuncionesGenerales;
import electricpos.util.Respuesta;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;

public class ReceptorViewController
implements Initializable {
    public ReceptorDto receptorSeleccionado = new ReceptorDto();
    @FXML
    private TextField txtNombre;
    @FXML
    ComboBox<EmisorDto> cbxEmisor;
    @FXML
    private TableView<ReceptorTv> tv_receptores;
    @FXML
    private TableColumn<ReceptorTv, String> tbcNombre;
    @FXML
    private TableColumn<ReceptorTv, String> tbcIdentificacion;
    @FXML
    private TableColumn<ReceptorTv, String> tbcTelefono;
    @FXML
    private TableColumn<ReceptorTv, String> tbcCorreo;
    @FXML
    private TableColumn<ReceptorTv, String> tbcEstado;
    ObservableList<EmisorDto> emisoresLista;
    EmisorDto emisorSeleccionado = null;
    ObservableList<ReceptorTv> receptoresTv;
    ObservableList<ReceptorDto> receptores;
    FuncionesGenerales funcionesGenerales = new FuncionesGenerales();

    public void initialize(URL url, ResourceBundle rb) {
        this.crearRelacionTv();
        this.cargarEmisores();
        if (!this.cbxEmisor.getItems().isEmpty()) {
            this.getReceptores(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId());
        }
    }

    private void cargarEmisores() {
        EmisorService emisorService = (EmisorService)AppContext.getInstance().get("EmisorService");
        Respuesta respuesta = emisorService.getEmisorIdEmpresa(GlobalApp.idEmpresa);
        if (respuesta.getEstado().booleanValue()) {
            this.emisoresLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("Emisores")));
            this.cbxEmisor.setItems(this.emisoresLista);
            this.cbxEmisor.getSelectionModel().selectFirst();
        }
    }

    @FXML
    private void OnBtnCrearReceptor(ActionEvent event) {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/MantReceptorView.fxml"));
        Parent root1 = null;
        try {
            root1 = (Parent)fxmlLoader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(ReceptorViewController.class.getName()).log(Level.SEVERE, null, ex);
        }
        MantReceptorViewController mantReceptorViewController = (MantReceptorViewController)fxmlLoader.getController();
        mantReceptorViewController.desdeFacturacion = false;
        mantReceptorViewController.idEmisor = ((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId();
        FuncionesGenerales.showView(root1);
        if (!this.cbxEmisor.getItems().isEmpty()) {
            this.getReceptores(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId());
        }
    }

    @FXML
    private void onBtnVerEditar() {
        if (this.tv_receptores.getSelectionModel().getSelectedItem() != null) {
            this.receptorSeleccionado = ((ReceptorTv)this.tv_receptores.getSelectionModel().getSelectedItem()).getReceptor();
            this.editarReceptor(this.receptorSeleccionado);
        }
    }

    @FXML
    private void onCbxEmisorChanged() {
        if (!this.cbxEmisor.getItems().isEmpty()) {
            this.getReceptores(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId());
        }
    }

    @FXML
    private void onBtnBuscar() {
        if (!this.cbxEmisor.getItems().isEmpty()) {
            this.getReceptores(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId());
        }
    }

    private void crearRelacionTv() {
        this.tbcCorreo.setCellValueFactory(cd -> ((ReceptorTv)cd.getValue()).correo);
        this.tbcIdentificacion.setCellValueFactory(cd -> ((ReceptorTv)cd.getValue()).identificacion);
        this.tbcTelefono.setCellValueFactory(cd -> ((ReceptorTv)cd.getValue()).telefono);
        this.tbcEstado.setCellValueFactory(cd -> ((ReceptorTv)cd.getValue()).estado);
        this.tbcNombre.setCellValueFactory(cd -> ((ReceptorTv)cd.getValue()).nombre);
    }

    private void getReceptores(Integer idEmisor) {
        ReceptorService receptorService = (ReceptorService)AppContext.getInstance().get("ReceptorService");
        Respuesta respuesta = receptorService.getReceptorEmisorYNombre(idEmisor, this.txtNombre.getText());
        if (respuesta.getEstado().booleanValue()) {
            this.receptores = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado(ESTADO.OK.VALUE())));
            this.tv_receptores.getItems().clear();
            this.tv_receptores.setItems(this.converterTv(this.receptores));
        }
    }

    private ObservableList<ReceptorTv> converterTv(ObservableList<ReceptorDto> receptores) {
        ObservableList receptoresTv = FXCollections.observableArrayList();
        for (ReceptorDto recDto : receptores) {
            ReceptorTv recTv = new ReceptorTv(recDto);
            receptoresTv.add((Object)recTv);
        }
        return receptoresTv;
    }

    public void editarReceptor(ReceptorDto receptor) {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/MantReceptorView.fxml"));
        Parent root1 = null;
        try {
            root1 = (Parent)fxmlLoader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(ParametrosGeneController.class.getName()).log(Level.SEVERE, null, ex);
        }
        MantReceptorViewController receptorViewController = (MantReceptorViewController)fxmlLoader.getController();
        receptorViewController.setIdEmisor(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId());
        receptorViewController.setReceptor(receptor);
        receptorViewController.desdeFacturacion = false;
        FuncionesGenerales.showView(root1);
        if (!this.cbxEmisor.getItems().isEmpty()) {
            this.getReceptores(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId());
        }
    }
}

