/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import com.jfoenix.controls.JFXButton;
import com.victorlaerte.asynctask.AsyncTask;
import electricpos.model.ResumenContableDto;
import electricpos.service.ComprobanteService;
import electricpos.service.ProformaService;
import electricpos.util.AppContext;
import electricpos.util.ESTADO;
import electricpos.util.FuncionesGenerales;
import electricpos.util.Respuesta;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.TextField;
import javafx.scene.image.ImageView;
import javafx.scene.text.Text;
import javafx.stage.Stage;

public class ReenvioCorreoViewController
implements Initializable {
    @FXML
    private TextField txtDestino;
    @FXML
    private JFXButton btnCancelar;
    @FXML
    private JFXButton btnEnviar;
    @FXML
    Text txtRespuesta;
    @FXML
    ImageView imgLoading;
    public boolean modifico = false;
    private String funcion = null;
    public Integer idComprobante;
    private ResumenContableDto resumenContableDto = null;
    Boolean correcto = false;
    FuncionesGenerales funcionesGenerales = new FuncionesGenerales();

    public void initialize(URL url, ResourceBundle rb) {
    }

    @FXML
    private void onBtnCancelar(ActionEvent event) {
        Stage stage = (Stage)this.btnCancelar.getScene().getWindow();
        stage.hide();
    }

    @FXML
    private void onBtnReenviar(ActionEvent event) {
        if (this.funcion.equalsIgnoreCase(ESTADO.COMPROBANTE.VALUE())) {
            this.mostrarReenvioCorreoHilo();
        } else if (this.funcion.equalsIgnoreCase(ESTADO.REPORTE.VALUE())) {
            this.resumenContableDto.setCorreoDestino(this.txtDestino.getText());
            this.mostrarCorreoReporteHilo(this.resumenContableDto);
        } else if (this.funcion.equalsIgnoreCase(ESTADO.REPORTE_GASTOS.VALUE())) {
            this.resumenContableDto.setCorreoDestino(this.txtDestino.getText());
            this.mostrarCorreoReporteGastosHilo(this.resumenContableDto);
        } else if (this.funcion.equalsIgnoreCase(ESTADO.PROFORMA.VALUE())) {
            this.mostrarReenvioCorreoProformaHilo();
        }
    }

    public void mostrarReenvioCorreoHilo() {
        SendCorreoCompTask myAsyncTask = new SendCorreoCompTask();
        myAsyncTask.setDaemon(false);
        myAsyncTask.execute(new String[0]);
    }

    public void mostrarCorreoReporteHilo(ResumenContableDto resumenContableDto) {
        SendCorreoResumenContableTask myAsyncTask = new SendCorreoResumenContableTask();
        myAsyncTask.setDaemon(false);
        myAsyncTask.execute(new String[0]);
    }

    public void mostrarCorreoReporteGastosHilo(ResumenContableDto resumenContableDto) {
        SendCorreoResumenGastosTask myAsyncTask = new SendCorreoResumenGastosTask();
        myAsyncTask.setDaemon(false);
        myAsyncTask.execute(new String[0]);
    }

    public void mostrarReenvioCorreoProformaHilo() {
        SendCorreoProformaTask myAsyncTask = new SendCorreoProformaTask();
        myAsyncTask.setDaemon(false);
        myAsyncTask.execute(new String[0]);
    }

    public Integer getIdComprobante() {
        return this.idComprobante;
    }

    public void setIdComprobante(Integer idComprobante) {
        this.idComprobante = idComprobante;
    }

    public String getFuncion() {
        return this.funcion;
    }

    public void setFuncion(String funcion) {
        this.funcion = funcion;
    }

    public ResumenContableDto getResumenContableDto() {
        return this.resumenContableDto;
    }

    public void setResumenContableDto(ResumenContableDto resumenContableDto) {
        this.resumenContableDto = resumenContableDto;
    }

    private void preExecute() {
        this.txtRespuesta.setText("");
        this.btnEnviar.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        this.btnEnviar.setDisable(true);
        this.imgLoading.setVisible(true);
    }

    private void postExecute() {
        if (this.correcto.booleanValue()) {
            this.txtRespuesta.setText("Correo enviado exitosamente.");
        } else {
            this.txtRespuesta.setText("Error al enviar el correo.");
        }
        this.btnEnviar.setContentDisplay(ContentDisplay.TEXT_ONLY);
        this.btnEnviar.setDisable(false);
    }

    private class SendCorreoResumenGastosTask
    extends AsyncTask<String, Integer, Boolean> {
        private SendCorreoResumenGastosTask() {
        }

        public void onPreExecute() {
            ReenvioCorreoViewController.this.preExecute();
        }

        public Boolean doInBackground(String ... params) {
            ComprobanteService service = (ComprobanteService)AppContext.getInstance().get("ComprobanteService");
            Respuesta respuesta = service.getEnviarCorreoResumenGastos(ReenvioCorreoViewController.this.resumenContableDto);
            ReenvioCorreoViewController.this.correcto = respuesta.getEstado();
            return true;
        }

        public void onPostExecute(Boolean success) {
            ReenvioCorreoViewController.this.postExecute();
        }

        public void progressCallback(Integer ... params) {
        }
    }

    public class SendCorreoProformaTask
    extends AsyncTask<String, Integer, Boolean> {
        public void onPreExecute() {
            ReenvioCorreoViewController.this.preExecute();
        }

        public Boolean doInBackground(String ... params) {
            ProformaService service = (ProformaService)AppContext.getInstance().get("ProformaService");
            Respuesta respuesta = service.getEnviarCorreoComp(ReenvioCorreoViewController.this.idComprobante, ReenvioCorreoViewController.this.txtDestino.getText());
            ReenvioCorreoViewController.this.correcto = respuesta.getEstado();
            return true;
        }

        public void onPostExecute(Boolean success) {
            ReenvioCorreoViewController.this.postExecute();
        }

        public void progressCallback(Integer ... params) {
        }
    }

    private class SendCorreoCompTask
    extends AsyncTask<String, Integer, Boolean> {
        private SendCorreoCompTask() {
        }

        public void onPreExecute() {
            ReenvioCorreoViewController.this.preExecute();
        }

        public Boolean doInBackground(String ... params) {
            ComprobanteService service = (ComprobanteService)AppContext.getInstance().get("ComprobanteService");
            Respuesta respuesta = service.getEnviarCorreoComp(ReenvioCorreoViewController.this.idComprobante, ReenvioCorreoViewController.this.txtDestino.getText());
            ReenvioCorreoViewController.this.correcto = respuesta.getEstado();
            return true;
        }

        public void onPostExecute(Boolean success) {
            ReenvioCorreoViewController.this.postExecute();
        }

        public void progressCallback(Integer ... params) {
        }
    }

    private class SendCorreoResumenContableTask
    extends AsyncTask<String, Integer, Boolean> {
        private SendCorreoResumenContableTask() {
        }

        public void onPreExecute() {
            ReenvioCorreoViewController.this.preExecute();
        }

        public Boolean doInBackground(String ... params) {
            ComprobanteService service = (ComprobanteService)AppContext.getInstance().get("ComprobanteService");
            ReenvioCorreoViewController.this.resumenContableDto.setCorreoDestino(ReenvioCorreoViewController.this.txtDestino.getText());
            Respuesta respuesta = service.getEnviarCorreoResumenContable(ReenvioCorreoViewController.this.resumenContableDto);
            ReenvioCorreoViewController.this.correcto = respuesta.getEstado();
            return true;
        }

        public void onPostExecute(Boolean success) {
            ReenvioCorreoViewController.this.postExecute();
        }

        public void progressCallback(Integer ... params) {
        }
    }
}

