/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import electricpos.controller.ComprobanteResumenViewController;
import electricpos.controller.ParametrosGeneController;
import electricpos.model.ColaboradorDto;
import electricpos.model.DetalleVentasColaboradorTv;
import electricpos.model.GlobalApp;
import electricpos.model.NotificacionType;
import electricpos.service.ColaboradoresService;
import electricpos.util.AppContext;
import electricpos.util.ESTADO;
import electricpos.util.FuncionesGenerales;
import electricpos.util.NotificacionHelper;
import electricpos.util.Respuesta;
import java.awt.Desktop;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperPrint;

public class ReporteColaboradoresViewController
implements Initializable {
    @FXML
    private ComboBox<ColaboradorDto> cbxColaborador;
    @FXML
    private DatePicker dpFechaIni;
    @FXML
    private DatePicker dpFechaFin;
    @FXML
    private Label lblTotal;
    @FXML
    private Label lblColaborador;
    @FXML
    private TableView<DetalleVentasColaboradorTv> tv_detalle;
    @FXML
    private TableColumn<DetalleVentasColaboradorTv, String> tbcDetalle;
    @FXML
    private TableColumn<DetalleVentasColaboradorTv, String> tbcFecha;
    @FXML
    private TableColumn<DetalleVentasColaboradorTv, String> tbcCliente;
    @FXML
    private TableColumn<DetalleVentasColaboradorTv, Number> tbcPorcentaje;
    @FXML
    private TableColumn<DetalleVentasColaboradorTv, Number> tbcMonto;
    private ObservableList<ColaboradorDto> colaboradores;
    private ObservableList<DetalleVentasColaboradorTv> detalleColaboradorTv;
    NumberFormat currencyFormat = NumberFormat.getInstance(Locale.ENGLISH);

    public void initialize(URL url, ResourceBundle rb) {
        this.cargarColaboradores();
        Date date = new Date();
        Instant instant = date.toInstant();
        LocalDate localDate = instant.atZone(ZoneId.systemDefault()).toLocalDate();
        this.dpFechaIni.setValue((Object)localDate.minusMonths(1L));
        this.dpFechaFin.setValue((Object)localDate);
        this.crearRelacionTv();
    }

    @FXML
    private void onBtnBuscar() {
        this.getDetalleColaborador(((ColaboradorDto)this.cbxColaborador.getSelectionModel().getSelectedItem()).getId(), ((LocalDate)this.dpFechaIni.getValue()).toString(), ((LocalDate)this.dpFechaFin.getValue()).toString());
    }

    @FXML
    private void onBtnVerFactura() {
        if (this.tv_detalle.getSelectionModel().getSelectedItem() != null) {
            this.mostrarVerFactura(((DetalleVentasColaboradorTv)this.tv_detalle.getSelectionModel().getSelectedItem()).getClaveFactura(), ((DetalleVentasColaboradorTv)this.tv_detalle.getSelectionModel().getSelectedItem()).getIdComprobante());
        } else {
            NotificacionHelper.dispararNotificacion(NotificacionType.WARNING, "Debe de seleccionar una factura para continuar.");
        }
    }

    private void cargarColaboradores() {
        ColaboradoresService service = (ColaboradoresService)AppContext.getInstance().get("ColaboradoresService");
        Respuesta respuesta = service.getColaboradores(GlobalApp.idEmpresa);
        if (respuesta.getEstado().booleanValue()) {
            this.colaboradores = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado(ESTADO.OK.VALUE())));
            this.cbxColaborador.setItems(this.colaboradores);
            this.cbxColaborador.getSelectionModel().selectFirst();
        }
    }

    private void getDetalleColaborador(Integer idColaborador, String inicio, String fin) {
        ColaboradoresService service = (ColaboradoresService)AppContext.getInstance().get("ColaboradoresService");
        Respuesta respuesta = service.getDetalleColaborador(idColaborador, inicio, fin);
        this.detalleColaboradorTv = null;
        if (respuesta.getEstado().booleanValue()) {
            this.detalleColaboradorTv = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado(ESTADO.OK.VALUE())));
            this.tv_detalle.getItems().clear();
            this.tv_detalle.setItems(this.detalleColaboradorTv);
        } else {
            this.tv_detalle.getItems().clear();
        }
        this.calculaTotalColaborador(this.detalleColaboradorTv);
    }

    private void crearRelacionTv() {
        this.tbcDetalle.setCellValueFactory(cd -> ((DetalleVentasColaboradorTv)cd.getValue()).detalle);
        this.tbcFecha.setCellValueFactory(cd -> ((DetalleVentasColaboradorTv)cd.getValue()).fecha);
        this.tbcCliente.setCellValueFactory(cd -> ((DetalleVentasColaboradorTv)cd.getValue()).cliente);
        this.tbcPorcentaje.setCellValueFactory(cd -> ((DetalleVentasColaboradorTv)cd.getValue()).porcentajeColaborador);
        this.tbcMonto.setCellValueFactory(cd -> ((DetalleVentasColaboradorTv)cd.getValue()).monto);
    }

    private void calculaTotalColaborador(ObservableList<DetalleVentasColaboradorTv> detalleColaborador) {
        Double total = 0.0;
        DecimalFormat formatter = new DecimalFormat("#,##0.00");
        if (detalleColaborador != null && !detalleColaborador.isEmpty()) {
            for (DetalleVentasColaboradorTv detalle : detalleColaborador) {
                total = total + detalle.getMonto();
            }
        }
        this.lblColaborador.setText(((ColaboradorDto)this.cbxColaborador.getSelectionModel().getSelectedItem()).getNombre());
        this.lblTotal.setText(formatter.format(total));
    }

    public void mostrarVerFactura(String clave, int id) {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/ComprobanteResumenView.fxml"));
        Parent root1 = null;
        try {
            root1 = (Parent)fxmlLoader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(ParametrosGeneController.class.getName()).log(Level.SEVERE, null, ex);
        }
        ComprobanteResumenViewController controller = (ComprobanteResumenViewController)fxmlLoader.getController();
        controller.setClaveComprobante(clave, id);
        FuncionesGenerales.showView(root1);
    }

    @FXML
    private void onBtnReporte() {
        ColaboradoresService service = (ColaboradoresService)AppContext.getInstance().get("ColaboradoresService");
        Respuesta respuesta = service.getReporte(((ColaboradorDto)this.cbxColaborador.getSelectionModel().getSelectedItem()).getId(), GlobalApp.idEmpresa, ((LocalDate)this.dpFechaIni.getValue()).toString(), ((LocalDate)this.dpFechaFin.getValue()).plusDays(1L).toString());
        if (respuesta.getEstado().booleanValue()) {
            JasperPrint reporte = (JasperPrint)respuesta.getResultado(ESTADO.OK.VALUE());
            try {
                File file = File.createTempFile("ReporteColabordor", ".pdf");
                FileOutputStream output = new FileOutputStream(file);
                JasperExportManager.exportReportToPdfStream((JasperPrint)reporte, (OutputStream)output);
                if (Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().open(file);
                        NotificacionHelper.dispararNotificacion(NotificacionType.SUCCESS, "Reporte del colaborador generado correctamente.");
                    }
                    catch (IOException ex) {
                        NotificacionHelper.dispararNotificacion(NotificacionType.ERROR, "Ocurri\u00f3 un error al intentar abrir el reporte generado.");
                    }
                }
            }
            catch (Exception ex) {
                NotificacionHelper.dispararNotificacion(NotificacionType.ERROR, "Error generando el reporte del colaborador.");
            }
        }
    }
}

