/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import com.jfoenix.controls.JFXButton;
import electricpos.controller.ParametrosGeneController;
import electricpos.controller.ReenvioCorreoViewController;
import electricpos.model.ActividadDto;
import electricpos.model.ActividadEmisorDto;
import electricpos.model.EmisorDto;
import electricpos.model.GlobalApp;
import electricpos.model.ResumenContableDto;
import electricpos.model.ResumenVentasDto;
import electricpos.model.SucursalEmisorDto;
import electricpos.service.ActividadService;
import electricpos.service.EmisorService;
import electricpos.service.ReporteVentasService;
import electricpos.service.SucursalEmisorService;
import electricpos.util.AppContext;
import electricpos.util.ESTADO;
import electricpos.util.FuncionesGenerales;
import electricpos.util.Respuesta;
import java.io.IOException;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;

public class ReporteVentasViewController
implements Initializable {
    @FXML
    private ComboBox<EmisorDto> cbxEmisor;
    @FXML
    private ComboBox<SucursalEmisorDto> cbxSucursal;
    @FXML
    private DatePicker dpFechaIni;
    @FXML
    private DatePicker dpFechaFin;
    @FXML
    private ComboBox<ActividadEmisorDto> cbxActividad;
    @FXML
    private Label txtTelefonoEmpresa;
    @FXML
    private Label lblDesde;
    @FXML
    private Label lblHasta;
    @FXML
    private HBox panelResultados;
    @FXML
    private JFXButton lblVentas;
    @FXML
    private JFXButton lblCreditos;
    @FXML
    private JFXButton lblTotal;
    @FXML
    private JFXButton lblDebitos;
    @FXML
    private HBox panelAcciones;
    @FXML
    private AnchorPane panelDescripcion;
    ObservableList<EmisorDto> emisoresLista;
    ObservableList<ActividadEmisorDto> actividadesLista;
    SucursalEmisorDto sucursalPrincipal = new SucursalEmisorDto();
    ObservableList<SucursalEmisorDto> sucursalLista;
    FuncionesGenerales funcionesGenerales = new FuncionesGenerales();
    ResumenVentasDto reporteVentasSeleccionado = new ResumenVentasDto();
    DateTimeFormatter formatterReport = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    public void initialize(URL url, ResourceBundle rb) {
        this.cargarEmisores();
        if (GlobalApp.idEmisor != null) {
            EmisorDto emi = this.cbxEmisor.getItems().stream().filter(c -> Objects.equals(c.getId(), GlobalApp.idEmisor)).findAny().orElse(null);
            this.cbxEmisor.getSelectionModel().select((Object)emi);
        }
        this.cargarSucursales(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId());
        if (GlobalApp.idSucursal != null) {
            SucursalEmisorDto suc;
            this.sucursalPrincipal = suc = (SucursalEmisorDto)this.cbxSucursal.getItems().stream().filter(c -> Objects.equals(c.getId(), GlobalApp.idSucursal)).findAny().orElse(null);
            this.cbxSucursal.getSelectionModel().select((Object)suc);
        }
        this.cargarActividadesEmisor((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem());
        Date date = new Date();
        Instant instant = date.toInstant();
        LocalDate localDate = instant.atZone(ZoneId.systemDefault()).toLocalDate();
        this.dpFechaFin.setValue((Object)localDate);
        this.dpFechaIni.setValue((Object)localDate);
    }

    @FXML
    private void onCbxEmisorChanged(ActionEvent event) {
    }

    @FXML
    private void onCbxActividadChanged(ActionEvent event) {
    }

    @FXML
    private void onBtnBuscar(ActionEvent event) {
        DecimalFormatSymbols simbolosPersonalizados = new DecimalFormatSymbols();
        simbolosPersonalizados.setDecimalSeparator(',');
        simbolosPersonalizados.setGroupingSeparator('.');
        DecimalFormat formatoDinero = new DecimalFormat("#,##0.00", simbolosPersonalizados);
        this.reporteVentasSeleccionado = this.getResumenVentas(((SucursalEmisorDto)this.cbxSucursal.getSelectionModel().getSelectedItem()).getId(), ((LocalDate)this.dpFechaIni.getValue()).toString(), ((LocalDate)this.dpFechaFin.getValue()).toString(), ((ActividadEmisorDto)this.cbxActividad.getSelectionModel().getSelectedItem()).getCodigo());
        if (this.reporteVentasSeleccionado != null) {
            this.lblVentas.setText("\u20a1 " + formatoDinero.format(Double.parseDouble(this.reporteVentasSeleccionado.getTotalFacturas())));
            this.lblCreditos.setText("\u20a1 " + formatoDinero.format(Double.parseDouble(this.reporteVentasSeleccionado.getTotalCreditos())));
            this.lblDebitos.setText("\u20a1 " + formatoDinero.format(Double.parseDouble(this.reporteVentasSeleccionado.getTotalDebito())));
            this.lblTotal.setText("\u20a1 " + formatoDinero.format(Double.parseDouble(this.reporteVentasSeleccionado.getTotalResumen())));
            this.lblDesde.setText(this.reporteVentasSeleccionado.getFechaInicio());
            this.lblHasta.setText(this.reporteVentasSeleccionado.getFechaFin());
        }
    }

    @FXML
    private void onBtnEnviar() {
        ResumenContableDto resumenContableDto = new ResumenContableDto();
        resumenContableDto.setFechaIni(this.formatterReport.format((TemporalAccessor)this.dpFechaIni.getValue()));
        resumenContableDto.setFechaFin(this.formatterReport.format((TemporalAccessor)this.dpFechaFin.getValue()));
        resumenContableDto.setIdEmisor(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId());
        resumenContableDto.setIdSucursal(((SucursalEmisorDto)this.cbxSucursal.getSelectionModel().getSelectedItem()).getId());
        resumenContableDto.setTotalFacturas(this.reporteVentasSeleccionado.getTotalFacturas());
        resumenContableDto.setTotalDebito(this.reporteVentasSeleccionado.getTotalDebito());
        resumenContableDto.setTotalCreditos(this.reporteVentasSeleccionado.getTotalCreditos());
        resumenContableDto.setTotalResumen(this.reporteVentasSeleccionado.getTotalResumen());
        resumenContableDto.setActividad(((ActividadEmisorDto)this.cbxActividad.getSelectionModel().getSelectedItem()).getCodigo().toString());
        this.mostrarReenvioCorreo(resumenContableDto);
    }

    private void cargarEmisores() {
        EmisorService emisorService = (EmisorService)AppContext.getInstance().get("EmisorService");
        Respuesta respuesta = emisorService.getEmisorIdEmpresa(GlobalApp.idEmpresa);
        if (respuesta.getEstado().booleanValue()) {
            this.emisoresLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("Emisores")));
            this.cbxEmisor.setItems(this.emisoresLista);
            this.cbxEmisor.getSelectionModel().selectFirst();
        }
    }

    public void mostrarReenvioCorreo(ResumenContableDto resumenContableDto) {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/ReenvioCorreoView.fxml"));
        Parent root1 = null;
        try {
            root1 = (Parent)fxmlLoader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(ParametrosGeneController.class.getName()).log(Level.SEVERE, null, ex);
        }
        ReenvioCorreoViewController controller = (ReenvioCorreoViewController)fxmlLoader.getController();
        controller.setFuncion(ESTADO.REPORTE.VALUE());
        controller.setResumenContableDto(resumenContableDto);
        FuncionesGenerales.showView(root1);
    }

    private void cargarActividadesEmisor(EmisorDto emisor) {
        this.actividadesLista = FXCollections.observableArrayList();
        this.cbxActividad.getItems().clear();
        ActividadEmisorDto todasActividades = new ActividadEmisorDto();
        todasActividades.setCodigo("%");
        todasActividades.setDescripcion("Todas");
        if (emisor.getActividadesEconomicas() != null && !emisor.getActividadesEconomicas().isEmpty()) {
            this.actividadesLista = FXCollections.observableArrayList(emisor.getActividadesEconomicas());
            this.actividadesLista.add(0, (Object)todasActividades);
            this.cbxActividad.setItems(this.actividadesLista);
            this.cbxActividad.getSelectionModel().selectFirst();
        } else {
            ActividadService actividadService = (ActividadService)AppContext.getInstance().get("ActividadService");
            Respuesta respuesta = actividadService.getByActividad(this.sucursalPrincipal.getCodigoActividad());
            ActividadDto actividadDto = null;
            if (respuesta.getEstado().booleanValue()) {
                actividadDto = (ActividadDto)respuesta.getResultado(ESTADO.OK.VALUE());
                ActividadEmisorDto act = new ActividadEmisorDto();
                act.setCodigo(actividadDto.getCodigo());
                act.setDescripcion(actividadDto.getActividad());
                this.actividadesLista.add(0, (Object)todasActividades);
                this.actividadesLista.add((Object)act);
                this.cbxActividad.setItems(this.actividadesLista);
                this.cbxActividad.getSelectionModel().selectFirst();
            }
        }
    }

    private void cargarSucursales(Integer IdEmisor) {
        SucursalEmisorService sucursalEmisorService = (SucursalEmisorService)AppContext.getInstance().get("SucursalEmisorService");
        Respuesta respuesta = sucursalEmisorService.getSucursalesEmi(IdEmisor);
        this.cbxSucursal.getItems().clear();
        if (respuesta.getEstado().booleanValue()) {
            this.sucursalLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("SucursalEmisor")));
            this.cbxSucursal.setItems(this.sucursalLista);
            this.sucursalPrincipal = (SucursalEmisorDto)this.sucursalLista.get(0);
            this.cbxSucursal.getSelectionModel().selectFirst();
        }
    }

    private ResumenVentasDto getResumenVentas(int sucursalId, String dateFrom, String dateTo, String activity) {
        ResumenVentasDto resumenVentasDto;
        ReporteVentasService service = (ReporteVentasService)AppContext.getInstance().get("ReporteVentasService");
        Respuesta respuesta = service.getResumenVentas(sucursalId, dateFrom, dateTo, activity);
        if (respuesta.getEstado().booleanValue()) {
            resumenVentasDto = (ResumenVentasDto)respuesta.getResultado(ESTADO.OK.VALUE());
        } else {
            resumenVentasDto = null;
            this.funcionesGenerales.MostrarModalInfo("Error: no se pudo obtener los datos del comprobante.");
        }
        return resumenVentasDto;
    }
}

