/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import electricpos.model.EmisorDto;
import electricpos.model.GlobalApp;
import electricpos.model.NotificacionType;
import electricpos.model.ProductoServicioDto;
import electricpos.model.SucursalEmisorDto;
import electricpos.service.EmisorService;
import electricpos.service.MovimientoInventarioService;
import electricpos.service.SucursalEmisorService;
import electricpos.util.AppContext;
import electricpos.util.ESTADO;
import electricpos.util.FuncionesGenerales;
import electricpos.util.NotificacionHelper;
import electricpos.util.Respuesta;
import java.awt.Desktop;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TextField;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperPrint;

public class ReportesInventarioViewController
implements Initializable {
    @FXML
    private ComboBox<EmisorDto> cbxEmisor;
    @FXML
    private ComboBox<SucursalEmisorDto> cbxSucursal;
    @FXML
    private DatePicker dpFechaIni;
    @FXML
    private DatePicker dpFechaFin;
    @FXML
    private TextField txtNombre;
    private ProductoServicioDto productoServicioDto = new ProductoServicioDto();
    private FuncionesGenerales funcionesGenerales = new FuncionesGenerales();
    private SucursalEmisorDto sucursalEmisorDto = new SucursalEmisorDto();
    private ObservableList<EmisorDto> emisoresLista;
    private ObservableList<SucursalEmisorDto> sucursalLista;

    public void initialize(URL url, ResourceBundle rb) {
        this.cargarEmisores();
        if (GlobalApp.idEmisor != null) {
            EmisorDto emi = new EmisorDto();
            emi = this.cbxEmisor.getItems().stream().filter(c -> c.getId() == GlobalApp.idEmisor).findAny().orElse(null);
            this.cbxEmisor.getSelectionModel().select((Object)emi);
        }
        this.cargarSucursales(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId());
        if (GlobalApp.idSucursal != null) {
            SucursalEmisorDto suc = new SucursalEmisorDto();
            suc = this.cbxSucursal.getItems().stream().filter(c -> c.getId() == GlobalApp.idSucursal).findAny().orElse(null);
            this.cbxSucursal.getSelectionModel().select((Object)suc);
        }
        Date date = new Date();
        Instant instant = date.toInstant();
        LocalDate localDate = instant.atZone(ZoneId.systemDefault()).toLocalDate();
        this.dpFechaIni.setValue((Object)localDate);
        this.dpFechaFin.setValue((Object)localDate);
    }

    @FXML
    private void onCbxEmisorChanged() {
        this.cargarSucursales(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId());
    }

    @FXML
    private void onBtnBuscar() {
        this.sucursalEmisorDto = (SucursalEmisorDto)this.cbxSucursal.getSelectionModel().getSelectedItem();
        this.productoServicioDto = this.funcionesGenerales.mostrarBusquedaPS(this.sucursalEmisorDto.getEmisor().getId(), this.sucursalEmisorDto.getId(), this.sucursalEmisorDto.getEmisor().getInventarioCompartido());
        if (this.productoServicioDto != null) {
            this.txtNombre.setText(this.productoServicioDto.getDescripcion());
        } else {
            this.productoServicioDto = new ProductoServicioDto();
            this.txtNombre.setText("Todos");
        }
    }

    @FXML
    private void onBtnReporteEntradas() {
        MovimientoInventarioService service = (MovimientoInventarioService)AppContext.getInstance().get("MovimientoInventarioService");
        Respuesta respuesta = service.getReporteMovimiento(((SucursalEmisorDto)this.cbxSucursal.getSelectionModel().getSelectedItem()).getId(), this.productoServicioDto.getId() == null ? "%" : this.productoServicioDto.getId().toString(), ((LocalDate)this.dpFechaIni.getValue()).toString(), ((LocalDate)this.dpFechaFin.getValue()).toString(), "ENT");
        if (respuesta.getEstado().booleanValue()) {
            JasperPrint reporte = (JasperPrint)respuesta.getResultado(ESTADO.OK.VALUE());
            try {
                File file = File.createTempFile("Entradas", ".pdf");
                FileOutputStream output = new FileOutputStream(file);
                JasperExportManager.exportReportToPdfStream((JasperPrint)reporte, (OutputStream)output);
                if (Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().open(file);
                        NotificacionHelper.dispararNotificacion(NotificacionType.SUCCESS, "Reporte de entradas al inventario generado correctamente.");
                    }
                    catch (IOException ex) {
                        NotificacionHelper.dispararNotificacion(NotificacionType.ERROR, "Ocurri\u00f3 un error al intentar abrir el reporte generado.");
                    }
                }
            }
            catch (Exception ex) {
                NotificacionHelper.dispararNotificacion(NotificacionType.ERROR, "Error generando el reporte de entradas al inventario.");
            }
        }
    }

    @FXML
    private void onBtnReporteSalidas() {
        MovimientoInventarioService service = (MovimientoInventarioService)AppContext.getInstance().get("MovimientoInventarioService");
        Respuesta respuesta = service.getReporteMovimiento(((SucursalEmisorDto)this.cbxSucursal.getSelectionModel().getSelectedItem()).getId(), this.productoServicioDto.getId() == null ? "%" : this.productoServicioDto.getId().toString(), ((LocalDate)this.dpFechaIni.getValue()).toString(), ((LocalDate)this.dpFechaFin.getValue()).toString(), "SAL");
        if (respuesta.getEstado().booleanValue()) {
            JasperPrint reporte = (JasperPrint)respuesta.getResultado(ESTADO.OK.VALUE());
            try {
                File file = File.createTempFile("Salidas", ".pdf");
                FileOutputStream output = new FileOutputStream(file);
                JasperExportManager.exportReportToPdfStream((JasperPrint)reporte, (OutputStream)output);
                if (Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().open(file);
                        NotificacionHelper.dispararNotificacion(NotificacionType.SUCCESS, "Reporte de salidas al inventario generado correctamente.");
                    }
                    catch (IOException ex) {
                        NotificacionHelper.dispararNotificacion(NotificacionType.ERROR, "Ocurri\u00f3 un error al intentar abrir el reporte generado.");
                    }
                }
            }
            catch (Exception ex) {
                NotificacionHelper.dispararNotificacion(NotificacionType.ERROR, "Error generando el reporte de entradas al inventario.");
            }
        }
    }

    @FXML
    private void onBtnReporteInv() {
        this.generateReporteInv("N");
    }

    @FXML
    private void onBtnReporteTomaFisica() {
        this.generateReporteInv("S");
    }

    private void generateReporteInv(String tomafisica) {
        MovimientoInventarioService service = (MovimientoInventarioService)AppContext.getInstance().get("MovimientoInventarioService");
        Respuesta respuesta = service.getReporteInv(((SucursalEmisorDto)this.cbxSucursal.getSelectionModel().getSelectedItem()).getId(), this.productoServicioDto.getId() == null ? "%" : this.productoServicioDto.getId().toString(), tomafisica);
        if (respuesta.getEstado().booleanValue()) {
            JasperPrint reporte = (JasperPrint)respuesta.getResultado(ESTADO.OK.VALUE());
            try {
                File file = File.createTempFile("ReporteInventario", ".pdf");
                FileOutputStream output = new FileOutputStream(file);
                JasperExportManager.exportReportToPdfStream((JasperPrint)reporte, (OutputStream)output);
                if (Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().open(file);
                        NotificacionHelper.dispararNotificacion(NotificacionType.SUCCESS, "Reporte de inventario generado correctamente.");
                    }
                    catch (IOException ex) {
                        NotificacionHelper.dispararNotificacion(NotificacionType.ERROR, "Ocurri\u00f3 un error al intentar abrir el reporte generado.");
                    }
                }
            }
            catch (Exception ex) {
                NotificacionHelper.dispararNotificacion(NotificacionType.ERROR, "Error generando el reporte de entradas al inventario.");
            }
        }
    }

    private void cargarSucursales(Integer IdEmisor) {
        SucursalEmisorService sucursalEmisorService = (SucursalEmisorService)AppContext.getInstance().get("SucursalEmisorService");
        Respuesta respuesta = sucursalEmisorService.getSucursalesEmi(IdEmisor);
        this.cbxSucursal.getItems().clear();
        if (respuesta.getEstado().booleanValue()) {
            this.sucursalLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("SucursalEmisor")));
            this.cbxSucursal.setItems(this.sucursalLista);
            this.cbxSucursal.getSelectionModel().selectFirst();
        }
    }

    private void cargarEmisores() {
        EmisorService emisorService = (EmisorService)AppContext.getInstance().get("EmisorService");
        Respuesta respuesta = emisorService.getEmisorIdEmpresa(GlobalApp.idEmpresa);
        if (respuesta.getEstado().booleanValue()) {
            this.emisoresLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("Emisores")));
            this.cbxEmisor.setItems(this.emisoresLista);
            this.cbxEmisor.getSelectionModel().selectFirst();
        }
    }
}

