/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import electricpos.controller.ParametrosGeneController;
import electricpos.controller.ReenvioCorreoViewController;
import electricpos.model.ResumenContableDto;
import electricpos.util.ESTADO;
import electricpos.util.FuncionesGenerales;
import java.io.IOException;
import java.net.URL;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import javafx.stage.Stage;

public class ResumenContableViewController
implements Initializable {
    @FXML
    Label lblFechaFin;
    @FXML
    Label lblFechaIni;
    @FXML
    Label lblFacturas;
    @FXML
    Label lblCredito;
    @FXML
    Label lblDebito;
    @FXML
    Label lblTotal;
    @FXML
    Label lblSumCredito;
    @FXML
    Label lblSumDebito;
    @FXML
    Label lblSumFacturas;
    FuncionesGenerales funcionesGenerales = new FuncionesGenerales();
    public Integer idEmisor;
    public Integer idSucursal;
    Double totalFacturas;
    Double totalDebito;
    Double totalCredito;
    Double totalResumen;
    String actividad = "%";
    LocalDate fechaIni;
    LocalDate fechaFin;
    DecimalFormat formatter = new DecimalFormat("#,##0.00");
    DateTimeFormatter formatterOut = DateTimeFormatter.ofPattern("EEEE, dd 'de' MMMM 'del' yyyy");
    DateTimeFormatter formatterReport = DateTimeFormatter.ofPattern("yyyy/MM/dd");

    public void initialize(URL url, ResourceBundle rb) {
    }

    @FXML
    private void onBtnCerrar(ActionEvent event) {
        Stage stage = (Stage)this.lblFechaFin.getScene().getWindow();
        stage.hide();
    }

    @FXML
    private void onBtnEnviar(ActionEvent event) {
        ResumenContableDto resumenContableDto = new ResumenContableDto();
        resumenContableDto.setFechaIni(this.formatterReport.format(this.fechaIni));
        resumenContableDto.setFechaFin(this.formatterReport.format(this.fechaFin));
        resumenContableDto.setIdEmisor(this.idEmisor);
        resumenContableDto.setIdSucursal(this.idSucursal);
        resumenContableDto.setTotalFacturas(this.totalFacturas.toString());
        resumenContableDto.setTotalDebito(this.totalDebito.toString());
        resumenContableDto.setTotalCreditos(this.totalCredito.toString());
        resumenContableDto.setTotalResumen(this.totalResumen.toString());
        resumenContableDto.setActividad(this.actividad);
        this.mostrarReenvioCorreo(resumenContableDto);
    }

    public void mostrarReenvioCorreo(ResumenContableDto resumenContableDto) {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/ReenvioCorreoView.fxml"));
        Parent root1 = null;
        try {
            root1 = (Parent)fxmlLoader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(ParametrosGeneController.class.getName()).log(Level.SEVERE, null, ex);
        }
        ReenvioCorreoViewController controller = (ReenvioCorreoViewController)fxmlLoader.getController();
        controller.setFuncion(ESTADO.REPORTE.VALUE());
        controller.setResumenContableDto(resumenContableDto);
        FuncionesGenerales.showView(root1);
    }

    public void setDatosResumen() {
        if (this.totalFacturas != null) {
            this.lblFacturas.setText(this.formatter.format(this.totalFacturas));
            this.lblSumFacturas.setText(this.formatter.format(this.totalFacturas));
        }
        if (this.totalDebito != null) {
            this.lblDebito.setText(this.formatter.format(this.totalDebito));
            this.lblSumDebito.setText(this.formatter.format(this.totalDebito));
        }
        if (this.totalCredito != null) {
            this.lblCredito.setText(this.formatter.format(this.totalCredito));
            this.lblSumCredito.setText(this.formatter.format(this.totalCredito));
        }
        this.totalResumen = this.totalFacturas + this.totalDebito - this.totalCredito;
        this.lblTotal.setText(this.formatter.format(this.totalResumen));
        this.lblFechaIni.setText(this.fechaIni.format(this.formatterOut));
        this.lblFechaFin.setText(this.fechaFin.format(this.formatterOut));
    }

    private String stringOf(Integer var) {
        String string = null;
        try {
            string = String.valueOf(var);
        }
        catch (Exception ex) {
            string = "";
        }
        return string;
    }

    private String stringOf(String var) {
        String string = null;
        try {
            string = String.valueOf(var);
        }
        catch (Exception ex) {
            string = "-";
        }
        return string;
    }

    private Integer getIntergerOf(String value) {
        Integer response;
        try {
            response = Integer.valueOf(value);
        }
        catch (Exception ex) {
            response = null;
        }
        return response;
    }

    public Double getTotalFacturas() {
        return this.totalFacturas;
    }

    public void setTotalFacturas(Double totalFacturas) {
        this.totalFacturas = totalFacturas;
    }

    public Double getTotalDebito() {
        return this.totalDebito;
    }

    public void setTotalDebito(Double totalDebito) {
        this.totalDebito = totalDebito;
    }

    public Double getTotalCredito() {
        return this.totalCredito;
    }

    public void setTotalCredito(Double totalCredito) {
        this.totalCredito = totalCredito;
    }

    public LocalDate getFechaIni() {
        return this.fechaIni;
    }

    public void setFechaIni(LocalDate fechaIni) {
        this.fechaIni = fechaIni;
    }

    public LocalDate getFechaFin() {
        return this.fechaFin;
    }

    public void setFechaFin(LocalDate fechaFin) {
        this.fechaFin = fechaFin;
    }

    public Integer getIdEmisor() {
        return this.idEmisor;
    }

    public void setIdEmisor(Integer idEmisor) {
        this.idEmisor = idEmisor;
    }

    public Integer getIdSucursal() {
        return this.idSucursal;
    }

    public void setIdSucursal(Integer idSucursal) {
        this.idSucursal = idSucursal;
    }

    public void setActividad(String actividad) {
        this.actividad = actividad;
    }
}

