/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXCheckBox;
import electricpos.model.MovimientoInventarioTv;
import electricpos.model.SucursalEmisorDto;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.stage.Stage;

public class ShowMovInvViewController
implements Initializable {
    @FXML
    private Label lblTitulo;
    @FXML
    private TextField txtCodigo;
    @FXML
    private JFXButton btnCancelar;
    @FXML
    private TextField txtDescripcion;
    @FXML
    private TextField txtPrecioU;
    @FXML
    private TextField txtExistencia;
    @FXML
    private JFXCheckBox checkActivo;
    @FXML
    private Label lblTitulo2;
    @FXML
    private TextField txtCantidadMov;
    @FXML
    private Label lblCantidadMov;
    @FXML
    private TextArea txtObservaciones;
    @FXML
    private ComboBox<SucursalEmisorDto> cbxSucursal;
    @FXML
    private TextField txtUnidadMedida;
    @FXML
    private Label lblFecha;
    private ObservableList<SucursalEmisorDto> sucursalLista;

    public void initialize(URL url, ResourceBundle rb) {
    }

    public void setMovimiento(MovimientoInventarioTv mov, SucursalEmisorDto sucursalEmisorDto) {
        if (mov.getTipo().equalsIgnoreCase("ENT")) {
            this.lblTitulo.setText("Entrada de inventario");
            this.lblTitulo2.setText("Movimiento de entrada - " + mov.getCodigo());
            this.lblCantidadMov.setText("Cantidad ingresada");
        } else if (mov.getTipo().equalsIgnoreCase("SAL")) {
            this.lblTitulo.setText("Salida de inventario");
            this.lblTitulo2.setText("Movimiento de salida - " + mov.getCodigo());
            this.lblCantidadMov.setText("Cantidad retirada");
        }
        if (sucursalEmisorDto != null) {
            ArrayList<SucursalEmisorDto> lista = new ArrayList<SucursalEmisorDto>();
            lista.add(sucursalEmisorDto);
            this.sucursalLista = FXCollections.observableArrayList(lista);
            this.cbxSucursal.setItems(this.sucursalLista);
            this.cbxSucursal.getSelectionModel().selectFirst();
        }
        this.txtCodigo.setText(mov.getProductoServicio().getCodigo());
        this.txtUnidadMedida.setText(mov.getProductoServicio().getUnidadMedida());
        this.txtDescripcion.setText(mov.getProductoServicio().getDescripcion());
        this.txtPrecioU.setText(mov.getProductoServicio().getPrecioConImp().toPlainString());
        this.txtExistencia.setText(mov.getProductoServicio().getExistencia().toPlainString());
        if (mov.getProductoServicio().getActivo().equalsIgnoreCase("S")) {
            this.checkActivo.setSelected(true);
        } else {
            this.checkActivo.setSelected(false);
        }
        this.txtCantidadMov.setText(mov.getCantidad().toString());
        this.lblFecha.setText(mov.getFechaFormat());
        this.txtObservaciones.setText(mov.getObservaciones());
    }

    @FXML
    private void OnBtnCancelar(ActionEvent event) {
        Stage stage = (Stage)this.btnCancelar.getScene().getWindow();
        stage.hide();
    }
}

