/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import electricpos.controller.MantSucursalViewController;
import electricpos.controller.ParametrosGeneController;
import electricpos.controller.PreferenciasSucursalViewController;
import electricpos.controller.ProductoServicioViewController;
import electricpos.model.EmisorDto;
import electricpos.model.GlobalApp;
import electricpos.model.NotificacionType;
import electricpos.model.SucursalEmisorDto;
import electricpos.model.SucursalEmisorTv;
import electricpos.service.EmisorService;
import electricpos.service.SucursalEmisorService;
import electricpos.util.AppContext;
import electricpos.util.FuncionesGenerales;
import electricpos.util.NotificacionHelper;
import electricpos.util.Respuesta;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;

public class SucursalViewController
implements Initializable {
    ObservableList<SucursalEmisorTv> sucursalesTv;
    ObservableList<SucursalEmisorDto> sucursales;
    ObservableList<EmisorDto> emisoresLista;
    EmisorDto emisorSeleccionado = null;
    public SucursalEmisorDto sucursalSeleccionado = new SucursalEmisorDto();
    FuncionesGenerales funcionesGenerales = new FuncionesGenerales();
    @FXML
    ComboBox<EmisorDto> cbxEmisor;
    @FXML
    private TableView<SucursalEmisorTv> tv_sucursales;
    @FXML
    private TableColumn<SucursalEmisorTv, String> tbcCodigo;
    @FXML
    private TableColumn<SucursalEmisorTv, String> tbcTel;
    @FXML
    private TableColumn<SucursalEmisorTv, String> tbcSenas;
    @FXML
    private TableColumn<SucursalEmisorTv, String> tbcSecFactura;
    @FXML
    private TableColumn<SucursalEmisorTv, String> tbcSecTiquete;
    @FXML
    private TableColumn<SucursalEmisorTv, String> tbcSecNotaCredito;
    @FXML
    private TableColumn<SucursalEmisorTv, String> tbcSecNotaDebito;
    @FXML
    private TableColumn<SucursalEmisorTv, String> tbcNombre;

    public void initialize(URL url, ResourceBundle rb) {
        this.crearRelacionTv();
        this.cargarEmisores();
        if (!this.cbxEmisor.getSelectionModel().isEmpty()) {
            this.getSucursales(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId());
        }
    }

    @FXML
    private void OnBtnCrearSucursal(ActionEvent event) {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/MantSucursalView.fxml"));
        Parent root1 = null;
        try {
            root1 = (Parent)fxmlLoader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(ProductoServicioViewController.class.getName()).log(Level.SEVERE, null, ex);
        }
        MantSucursalViewController sucursalViewController = (MantSucursalViewController)fxmlLoader.getController();
        sucursalViewController.setEmisor((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem());
        sucursalViewController.setNuevo(true);
        FuncionesGenerales.showView(root1);
        if (!this.cbxEmisor.getSelectionModel().isEmpty()) {
            this.getSucursales(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId());
        }
    }

    @FXML
    private void OnBtnPreferencias(ActionEvent event) {
        this.sucursalSeleccionado = ((SucursalEmisorTv)this.tv_sucursales.getSelectionModel().getSelectedItem()).getSucursalEmisorDto();
        if (this.sucursalSeleccionado != null) {
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/PreferenciasSucursalView.fxml"));
            Parent root1 = null;
            try {
                root1 = (Parent)fxmlLoader.load();
            }
            catch (IOException ex) {
                Logger.getLogger(ProductoServicioViewController.class.getName()).log(Level.SEVERE, null, ex);
            }
            PreferenciasSucursalViewController controller = (PreferenciasSucursalViewController)fxmlLoader.getController();
            controller.setSucursalEmisorDto(this.sucursalSeleccionado);
            FuncionesGenerales.showView(root1);
        } else {
            NotificacionHelper.dispararNotificacion(NotificacionType.INFO, "Debe de seleccionar un emisor.");
        }
    }

    @FXML
    private void onBtnVerEditar() {
        if (this.tv_sucursales.getSelectionModel().getSelectedItem() != null) {
            this.sucursalSeleccionado = ((SucursalEmisorTv)this.tv_sucursales.getSelectionModel().getSelectedItem()).getSucursalEmisorDto();
            this.editarSucursal(this.sucursalSeleccionado);
        }
    }

    public void editarSucursal(SucursalEmisorDto sucursal) {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/MantSucursalView.fxml"));
        Parent root1 = null;
        try {
            root1 = (Parent)fxmlLoader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(ParametrosGeneController.class.getName()).log(Level.SEVERE, null, ex);
        }
        MantSucursalViewController sucursalViewController = (MantSucursalViewController)fxmlLoader.getController();
        sucursalViewController.setNuevo(false);
        sucursalViewController.setEmisor((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem());
        sucursalViewController.setSucursalSeleccionada(sucursal);
        FuncionesGenerales.showView(root1);
        if (!this.cbxEmisor.getSelectionModel().isEmpty()) {
            this.getSucursales(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId());
        }
    }

    @FXML
    private void onCbxEmisorChanged(ActionEvent event) {
        if (!this.cbxEmisor.getSelectionModel().isEmpty()) {
            this.getSucursales(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId());
        }
    }

    private void getSucursales(Integer idEmisor) {
        SucursalEmisorService sucursalEmisorService = (SucursalEmisorService)AppContext.getInstance().get("SucursalEmisorService");
        Respuesta respuesta = sucursalEmisorService.getSucursalesEmi(idEmisor);
        if (respuesta.getEstado().booleanValue()) {
            this.sucursales = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("SucursalEmisor")));
            this.tv_sucursales.getItems().clear();
            this.tv_sucursales.setItems(this.converterTv(this.sucursales));
        }
    }

    private ObservableList<SucursalEmisorTv> converterTv(ObservableList<SucursalEmisorDto> sucursales) {
        ObservableList sucursalesTv = FXCollections.observableArrayList();
        for (SucursalEmisorDto sucDto : sucursales) {
            SucursalEmisorTv sucTv = new SucursalEmisorTv(sucDto);
            sucursalesTv.add((Object)sucTv);
        }
        return sucursalesTv;
    }

    private void crearRelacionTv() {
        this.tbcCodigo.setCellValueFactory(cd -> ((SucursalEmisorTv)cd.getValue()).codigo);
        this.tbcSecFactura.setCellValueFactory(cd -> ((SucursalEmisorTv)cd.getValue()).secuenciaFactura);
        this.tbcSecTiquete.setCellValueFactory(cd -> ((SucursalEmisorTv)cd.getValue()).secuenciaTiquete);
        this.tbcSecNotaDebito.setCellValueFactory(cd -> ((SucursalEmisorTv)cd.getValue()).secuenciaNotaDebito);
        this.tbcSecNotaCredito.setCellValueFactory(cd -> ((SucursalEmisorTv)cd.getValue()).secuenciaNotaCredito);
        this.tbcNombre.setCellValueFactory(cd -> ((SucursalEmisorTv)cd.getValue()).nombre);
        this.tbcTel.setCellValueFactory(cd -> ((SucursalEmisorTv)cd.getValue()).tel);
        this.tbcSenas.setCellValueFactory(cd -> ((SucursalEmisorTv)cd.getValue()).senas);
    }

    private void cargarEmisores() {
        EmisorService emisorService = (EmisorService)AppContext.getInstance().get("EmisorService");
        Respuesta respuesta = emisorService.getEmisorIdEmpresa(GlobalApp.idEmpresa);
        if (respuesta.getEstado().booleanValue()) {
            this.emisoresLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("Emisores")));
            this.cbxEmisor.setItems(this.emisoresLista);
            this.cbxEmisor.getSelectionModel().selectFirst();
        }
    }
}

