/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import com.jfoenix.controls.JFXCheckBox;
import electricpos.model.GlobalApp;
import electricpos.model.UsuarioDto;
import electricpos.model.UsuarioMenuDto;
import electricpos.service.UsuarioService;
import electricpos.util.AppContext;
import electricpos.util.ESTADO;
import electricpos.util.FuncionesGenerales;
import electricpos.util.Respuesta;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Label;
import javafx.stage.Stage;

public class UsuarioMenuViewController
implements Initializable {
    @FXML
    private JFXCheckBox ckCuenta;
    @FXML
    private JFXCheckBox ckEmpresa;
    @FXML
    private JFXCheckBox ckEmisores;
    @FXML
    private JFXCheckBox ckSucursal;
    @FXML
    private JFXCheckBox ckUsuarios;
    @FXML
    private JFXCheckBox ckClientes;
    @FXML
    private JFXCheckBox ckProductos;
    @FXML
    private JFXCheckBox ckServicios;
    @FXML
    private JFXCheckBox ckEntradas;
    @FXML
    private JFXCheckBox ckSalidas;
    @FXML
    private JFXCheckBox ckReportesInv;
    @FXML
    private JFXCheckBox ckFacturar;
    @FXML
    private JFXCheckBox ckPos;
    @FXML
    private JFXCheckBox ckFacturaCompra;
    @FXML
    private JFXCheckBox ckCrearProforma;
    @FXML
    private JFXCheckBox ckVerFacturas;
    @FXML
    private JFXCheckBox ckVerGastos;
    @FXML
    private JFXCheckBox ckVerProformas;
    @FXML
    private JFXCheckBox ckMhFacturas;
    @FXML
    private JFXCheckBox ckMhTiquetes;
    @FXML
    private JFXCheckBox ckMhCredito;
    @FXML
    private JFXCheckBox ckMhDebito;
    @FXML
    private JFXCheckBox ckMhRecibidos;
    @FXML
    private JFXCheckBox ckMhRecepcion;
    @FXML
    private JFXCheckBox ckAdministrador;
    @FXML
    private JFXCheckBox ckColaboradores;
    @FXML
    private JFXCheckBox ckReporteSalarios;
    @FXML
    private JFXCheckBox ckCreditos;
    @FXML
    private JFXCheckBox ckCajas;
    @FXML
    private JFXCheckBox ckAbrirCaja;
    @FXML
    private JFXCheckBox ckCerrarCaja;
    @FXML
    private JFXCheckBox ckRetiroEfectivo;
    @FXML
    private JFXCheckBox ckOtrosEgresos;
    @FXML
    private JFXCheckBox ckOtrosIngresos;
    @FXML
    private JFXCheckBox ckVerCierreMes;
    @FXML
    private JFXCheckBox ckCrearCierreMes;
    @FXML
    private Label txtNombre;
    FuncionesGenerales funcionesGenerales = new FuncionesGenerales();
    UsuarioDto usuario = new UsuarioDto();
    List<UsuarioMenuDto> menus = new ArrayList<UsuarioMenuDto>();

    public void initialize(URL url, ResourceBundle rb) {
    }

    @FXML
    private void onBtnCancelar() {
        Stage stage = (Stage)this.txtNombre.getScene().getWindow();
        stage.hide();
    }

    @FXML
    private void onBtnGuardar() {
        this.getMenus();
        if (!this.menus.isEmpty()) {
            UsuarioService service = (UsuarioService)AppContext.getInstance().get("UsuarioService");
            Respuesta respuesta = service.saveMenuUsuario(this.usuario.getId(), this.menus);
            if (respuesta.getEstado().booleanValue()) {
                this.funcionesGenerales.MostrarModalInfo("Usuario [" + this.usuario.getCorreo() + "] guardado correctamente.");
                if (GlobalApp.idUsuario.equals(this.usuario.getId())) {
                    GlobalApp.menusUsuarioGlobal = this.menus;
                    this.usuario.setRolDescripcion(this.ckAdministrador.isSelected() ? "A" : "P");
                    respuesta = service.saveUsuario(this.usuario);
                    if (!respuesta.getEstado().booleanValue()) {
                        this.funcionesGenerales.MostrarModalInfo("Ocurri\u00f3 un error guardando el usuario, intente m\u00e1s tarde.");
                    }
                    GlobalApp.usuarioAdmin = this.ckAdministrador.isSelected();
                }
                Stage stage = (Stage)this.txtNombre.getScene().getWindow();
                stage.hide();
            } else {
                this.funcionesGenerales.MostrarModalInfo("Ocurri\u00f3 un error guardando el usuario, intente m\u00e1s tarde.");
            }
        }
    }

    private void setMenus(int id) {
        UsuarioService service = (UsuarioService)AppContext.getInstance().get("UsuarioService");
        Respuesta respuesta = service.getMenusUsuario(id);
        if (respuesta.getEstado().booleanValue()) {
            this.checkMenus((List)respuesta.getResultado(ESTADO.OK.VALUE()));
        } else {
            this.funcionesGenerales.MostrarModalInfo("Ocurri\u00f3 un error obteniendo los permisos para el usuario, intente m\u00e1s tarde.");
        }
    }

    public void setUsuario(UsuarioDto usuario) {
        this.usuario = usuario;
        this.txtNombre.setText(usuario.getNombre() + " " + usuario.getPrimerApellido());
        if (usuario.getRolDescripcion().equalsIgnoreCase("A")) {
            this.ckAdministrador.setSelected(true);
        }
        this.setMenus(usuario.getId());
    }

    private void checkMenus(List<UsuarioMenuDto> list) {
        list.forEach(e -> this.check(e.getMenu()));
    }

    private void check(UsuarioMenuDto.MENU menu) {
        switch (menu.toString()) {
            case "MICUENTA": {
                this.ckCuenta.setSelected(true);
                break;
            }
            case "EMPRESA": {
                this.ckEmpresa.setSelected(true);
                break;
            }
            case "EMISORES": {
                this.ckEmisores.setSelected(true);
                break;
            }
            case "SUCURSALES": {
                this.ckSucursal.setSelected(true);
                break;
            }
            case "USUARIOS": {
                this.ckUsuarios.setSelected(true);
                break;
            }
            case "COLABORADORES": {
                this.ckColaboradores.setSelected(true);
                break;
            }
            case "REPORTE_SALARIOS": {
                this.ckReporteSalarios.setSelected(true);
                break;
            }
            case "CLIENTES": {
                this.ckClientes.setSelected(true);
                break;
            }
            case "CREDITOS": {
                this.ckCreditos.setSelected(true);
                break;
            }
            case "PRODUCTOS": {
                this.ckProductos.setSelected(true);
                break;
            }
            case "SERVICIOS": {
                this.ckServicios.setSelected(true);
                break;
            }
            case "ENTRADAS": {
                this.ckEntradas.setSelected(true);
                break;
            }
            case "SALIDAS": {
                this.ckSalidas.setSelected(true);
                break;
            }
            case "REPORTESINV": {
                this.ckReportesInv.setSelected(true);
                break;
            }
            case "FACTURAR": {
                this.ckFacturar.setSelected(true);
                break;
            }
            case "POS": {
                this.ckPos.setSelected(true);
                break;
            }
            case "FACTURACOMPRA": {
                this.ckFacturaCompra.setSelected(true);
                break;
            }
            case "CREARPROFORMA": {
                this.ckCrearProforma.setSelected(true);
                break;
            }
            case "VERFACTURAS": {
                this.ckVerFacturas.setSelected(true);
                break;
            }
            case "VERGASTOS": {
                this.ckVerGastos.setSelected(true);
                break;
            }
            case "VERPROFORMAS": {
                this.ckVerProformas.setSelected(true);
                break;
            }
            case "CAJAS": {
                this.ckCajas.setSelected(true);
                break;
            }
            case "ABRIR_CAJA": {
                this.ckAbrirCaja.setSelected(true);
                break;
            }
            case "CERRAR_CAJA": {
                this.ckCerrarCaja.setSelected(true);
                break;
            }
            case "RETIROS_EFECTIVO": {
                this.ckRetiroEfectivo.setSelected(true);
                break;
            }
            case "OTROS_EGRESOS": {
                this.ckOtrosEgresos.setSelected(true);
                break;
            }
            case "OTROS_INGRESOS": {
                this.ckOtrosIngresos.setSelected(true);
                break;
            }
            case "VER_CIERRES_MES": {
                this.ckVerCierreMes.setSelected(true);
                break;
            }
            case "CREAR_CIERRES_MES": {
                this.ckCrearCierreMes.setSelected(true);
                break;
            }
            case "MH_FACTURAS": {
                this.ckMhFacturas.setSelected(true);
                break;
            }
            case "MH_TIQUETES": {
                this.ckMhTiquetes.setSelected(true);
                break;
            }
            case "MH_CREDITO": {
                this.ckMhCredito.setSelected(true);
                break;
            }
            case "MH_DEBITO": {
                this.ckMhDebito.setSelected(true);
                break;
            }
            case "MH_RECIBIDOS": {
                this.ckMhRecibidos.setSelected(true);
                break;
            }
            case "MH_RECEPCION": {
                this.ckMhRecepcion.setSelected(true);
            }
        }
    }

    private void getMenus() {
        this.menus.clear();
        if (this.ckCuenta.isSelected()) {
            this.menus.add(new UsuarioMenuDto(UsuarioMenuDto.MENU.MICUENTA, this.usuario));
        }
        if (this.ckEmpresa.isSelected()) {
            this.menus.add(new UsuarioMenuDto(UsuarioMenuDto.MENU.EMPRESA, this.usuario));
        }
        if (this.ckEmisores.isSelected()) {
            this.menus.add(new UsuarioMenuDto(UsuarioMenuDto.MENU.EMISORES, this.usuario));
        }
        if (this.ckSucursal.isSelected()) {
            this.menus.add(new UsuarioMenuDto(UsuarioMenuDto.MENU.SUCURSALES, this.usuario));
        }
        if (this.ckUsuarios.isSelected()) {
            this.menus.add(new UsuarioMenuDto(UsuarioMenuDto.MENU.USUARIOS, this.usuario));
        }
        if (this.ckColaboradores.isSelected()) {
            this.menus.add(new UsuarioMenuDto(UsuarioMenuDto.MENU.COLABORADORES, this.usuario));
        }
        if (this.ckReporteSalarios.isSelected()) {
            this.menus.add(new UsuarioMenuDto(UsuarioMenuDto.MENU.REPORTE_SALARIOS, this.usuario));
        }
        if (this.ckClientes.isSelected()) {
            this.menus.add(new UsuarioMenuDto(UsuarioMenuDto.MENU.CLIENTES, this.usuario));
        }
        if (this.ckCreditos.isSelected()) {
            this.menus.add(new UsuarioMenuDto(UsuarioMenuDto.MENU.CREDITOS, this.usuario));
        }
        if (this.ckProductos.isSelected()) {
            this.menus.add(new UsuarioMenuDto(UsuarioMenuDto.MENU.PRODUCTOS, this.usuario));
        }
        if (this.ckServicios.isSelected()) {
            this.menus.add(new UsuarioMenuDto(UsuarioMenuDto.MENU.SERVICIOS, this.usuario));
        }
        if (this.ckEntradas.isSelected()) {
            this.menus.add(new UsuarioMenuDto(UsuarioMenuDto.MENU.ENTRADAS, this.usuario));
        }
        if (this.ckSalidas.isSelected()) {
            this.menus.add(new UsuarioMenuDto(UsuarioMenuDto.MENU.SALIDAS, this.usuario));
        }
        if (this.ckReportesInv.isSelected()) {
            this.menus.add(new UsuarioMenuDto(UsuarioMenuDto.MENU.REPORTESINV, this.usuario));
        }
        if (this.ckFacturar.isSelected()) {
            this.menus.add(new UsuarioMenuDto(UsuarioMenuDto.MENU.FACTURAR, this.usuario));
        }
        if (this.ckPos.isSelected()) {
            this.menus.add(new UsuarioMenuDto(UsuarioMenuDto.MENU.POS, this.usuario));
        }
        if (this.ckFacturaCompra.isSelected()) {
            this.menus.add(new UsuarioMenuDto(UsuarioMenuDto.MENU.FACTURACOMPRA, this.usuario));
        }
        if (this.ckCrearProforma.isSelected()) {
            this.menus.add(new UsuarioMenuDto(UsuarioMenuDto.MENU.CREARPROFORMA, this.usuario));
        }
        if (this.ckVerFacturas.isSelected()) {
            this.menus.add(new UsuarioMenuDto(UsuarioMenuDto.MENU.VERFACTURAS, this.usuario));
        }
        if (this.ckVerGastos.isSelected()) {
            this.menus.add(new UsuarioMenuDto(UsuarioMenuDto.MENU.VERGASTOS, this.usuario));
        }
        if (this.ckVerProformas.isSelected()) {
            this.menus.add(new UsuarioMenuDto(UsuarioMenuDto.MENU.VERPROFORMAS, this.usuario));
        }
        if (this.ckCajas.isSelected()) {
            this.menus.add(new UsuarioMenuDto(UsuarioMenuDto.MENU.CAJAS, this.usuario));
        }
        if (this.ckAbrirCaja.isSelected()) {
            this.menus.add(new UsuarioMenuDto(UsuarioMenuDto.MENU.ABRIR_CAJA, this.usuario));
        }
        if (this.ckCerrarCaja.isSelected()) {
            this.menus.add(new UsuarioMenuDto(UsuarioMenuDto.MENU.CERRAR_CAJA, this.usuario));
        }
        if (this.ckRetiroEfectivo.isSelected()) {
            this.menus.add(new UsuarioMenuDto(UsuarioMenuDto.MENU.RETIROS_EFECTIVO, this.usuario));
        }
        if (this.ckOtrosEgresos.isSelected()) {
            this.menus.add(new UsuarioMenuDto(UsuarioMenuDto.MENU.OTROS_EGRESOS, this.usuario));
        }
        if (this.ckOtrosIngresos.isSelected()) {
            this.menus.add(new UsuarioMenuDto(UsuarioMenuDto.MENU.OTROS_INGRESOS, this.usuario));
        }
        if (this.ckVerCierreMes.isSelected()) {
            this.menus.add(new UsuarioMenuDto(UsuarioMenuDto.MENU.VER_CIERRES_MES, this.usuario));
        }
        if (this.ckCrearCierreMes.isSelected()) {
            this.menus.add(new UsuarioMenuDto(UsuarioMenuDto.MENU.CREAR_CIERRES_MES, this.usuario));
        }
        if (this.ckMhFacturas.isSelected()) {
            this.menus.add(new UsuarioMenuDto(UsuarioMenuDto.MENU.MH_FACTURAS, this.usuario));
        }
        if (this.ckMhTiquetes.isSelected()) {
            this.menus.add(new UsuarioMenuDto(UsuarioMenuDto.MENU.MH_TIQUETES, this.usuario));
        }
        if (this.ckMhCredito.isSelected()) {
            this.menus.add(new UsuarioMenuDto(UsuarioMenuDto.MENU.MH_CREDITO, this.usuario));
        }
        if (this.ckMhDebito.isSelected()) {
            this.menus.add(new UsuarioMenuDto(UsuarioMenuDto.MENU.MH_DEBITO, this.usuario));
        }
        if (this.ckMhRecibidos.isSelected()) {
            this.menus.add(new UsuarioMenuDto(UsuarioMenuDto.MENU.MH_RECIBIDOS, this.usuario));
        }
        if (this.ckMhRecepcion.isSelected()) {
            this.menus.add(new UsuarioMenuDto(UsuarioMenuDto.MENU.MH_RECEPCION, this.usuario));
        }
    }
}

