/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import electricpos.controller.MantUsuarioViewController;
import electricpos.controller.ProductoServicioViewController;
import electricpos.controller.UsuarioMenuViewController;
import electricpos.model.GlobalApp;
import electricpos.model.UsuarioDto;
import electricpos.model.UsuarioTv;
import electricpos.service.UsuarioService;
import electricpos.util.AppContext;
import electricpos.util.ESTADO;
import electricpos.util.FuncionesGenerales;
import electricpos.util.Respuesta;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;

public class UsuariosViewController
implements Initializable {
    ObservableList<UsuarioTv> usuariosTv;
    ObservableList<UsuarioDto> usuarios;
    public UsuarioDto usuarioSeleccionado = new UsuarioDto();
    FuncionesGenerales funcionesGenerales = new FuncionesGenerales();
    @FXML
    private TableView<UsuarioTv> tv_usuarios;
    @FXML
    private TableColumn<UsuarioTv, String> tbcEstado;
    @FXML
    private TableColumn<UsuarioTv, String> tbcCorreo;
    @FXML
    private TableColumn<UsuarioTv, String> tbcRol;
    @FXML
    private TableColumn<UsuarioTv, String> tbcApellido;
    @FXML
    private TableColumn<UsuarioTv, String> tbcNombre;

    public void initialize(URL url, ResourceBundle rb) {
        this.crearRelacionTv();
        this.getUsuarios();
    }

    private void getUsuarios() {
        UsuarioService usuarioService = (UsuarioService)AppContext.getInstance().get("UsuarioService");
        Respuesta respuesta = usuarioService.getUsauriosEmpresa(GlobalApp.idEmpresa);
        if (respuesta.getEstado().booleanValue()) {
            this.usuarios = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado(ESTADO.OK.VALUE())));
            this.tv_usuarios.getItems().clear();
            this.tv_usuarios.setItems(this.converterTv(this.usuarios));
        }
    }

    @FXML
    private void onBtnPermisos() {
        if (this.tv_usuarios.getSelectionModel().getSelectedItem() != null) {
            this.usuarioSeleccionado = ((UsuarioTv)this.tv_usuarios.getSelectionModel().getSelectedItem()).getUsuarioDto();
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/UsuarioMenuView.fxml"));
            Parent root1 = null;
            try {
                root1 = (Parent)fxmlLoader.load();
            }
            catch (IOException ex) {
                Logger.getLogger(ProductoServicioViewController.class.getName()).log(Level.SEVERE, null, ex);
            }
            UsuarioMenuViewController controller = (UsuarioMenuViewController)fxmlLoader.getController();
            controller.setUsuario(this.usuarioSeleccionado);
            FuncionesGenerales.showView(root1);
            this.getUsuarios();
        } else {
            this.funcionesGenerales.MostrarModalInfo("Debe de seleccionar un usuario.");
        }
    }

    @FXML
    private void onBtnVerEditar() {
        if (this.tv_usuarios.getSelectionModel().getSelectedItem() != null) {
            this.usuarioSeleccionado = ((UsuarioTv)this.tv_usuarios.getSelectionModel().getSelectedItem()).getUsuarioDto();
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/MantUsuarioView.fxml"));
            Parent root1 = null;
            try {
                root1 = (Parent)fxmlLoader.load();
            }
            catch (IOException ex) {
                Logger.getLogger(ProductoServicioViewController.class.getName()).log(Level.SEVERE, null, ex);
            }
            MantUsuarioViewController controller = (MantUsuarioViewController)fxmlLoader.getController();
            controller.setUsuario(this.usuarioSeleccionado);
            FuncionesGenerales.showView(root1);
            this.getUsuarios();
        } else {
            this.funcionesGenerales.MostrarModalInfo("Debe de seleccionar un usuario.");
        }
    }

    @FXML
    private void OnBtnCrear() {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/MantUsuarioView.fxml"));
        Parent root1 = null;
        try {
            root1 = (Parent)fxmlLoader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(ProductoServicioViewController.class.getName()).log(Level.SEVERE, null, ex);
        }
        FuncionesGenerales.showView(root1);
        this.getUsuarios();
    }

    private void crearRelacionTv() {
        this.tbcCorreo.setCellValueFactory(cd -> ((UsuarioTv)cd.getValue()).correo);
        this.tbcEstado.setCellValueFactory(cd -> ((UsuarioTv)cd.getValue()).estado);
        this.tbcApellido.setCellValueFactory(cd -> ((UsuarioTv)cd.getValue()).apellido);
        this.tbcRol.setCellValueFactory(cd -> ((UsuarioTv)cd.getValue()).rolDescripcion);
        this.tbcNombre.setCellValueFactory(cd -> ((UsuarioTv)cd.getValue()).nombre);
    }

    private ObservableList<UsuarioTv> converterTv(ObservableList<UsuarioDto> usuarios) {
        ObservableList usuariosTv = FXCollections.observableArrayList();
        for (UsuarioDto usuDto : usuarios) {
            UsuarioTv usuTv = new UsuarioTv(usuDto);
            usuariosTv.add((Object)usuTv);
        }
        return usuariosTv;
    }
}

