/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import com.victorlaerte.asynctask.AsyncTask;
import electricpos.controller.NotificacionViewController;
import electricpos.model.ComprobanteCompraDto;
import electricpos.model.ComprobanteElectronicoDto;
import electricpos.model.ComprobanteProformaDto;
import electricpos.model.ComprobanteRecepcionDto;
import electricpos.model.GlobalApp;
import electricpos.model.ResumenContableDto;
import electricpos.service.ComprobanteCompraService;
import electricpos.service.ComprobanteRecepcionService;
import electricpos.service.ComprobanteService;
import electricpos.service.ProformaService;
import electricpos.util.AppContext;
import electricpos.util.ESTADO;
import electricpos.util.FuncionesGenerales;
import electricpos.util.Respuesta;
import java.net.URL;
import java.time.LocalDateTime;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.text.Text;
import net.sf.jasperreports.engine.JasperPrint;

public class WaitingViewController
implements Initializable {
    @FXML
    ImageView imgProcesando;
    @FXML
    ImageView imgResultado;
    @FXML
    Text txtEstado;
    @FXML
    Label lblTipo;
    @FXML
    Label lblFecha;
    @FXML
    Label lblCliente;
    Text txtRespuesta;
    ComprobanteElectronicoDto comprobanteElectronicoDto;
    ComprobanteCompraDto comprobanteCompraDto;
    ComprobanteProformaDto comprobanteProformaDto;
    ComprobanteRecepcionDto comprobanteRecepcionDto;
    String mensaje = null;
    Boolean correcto = false;
    AnchorPane anchorPane;
    Integer idComprobanteDto;
    ResumenContableDto resumenContableDto;
    String correoDestino;
    String tipo;
    String codigoMensaje = null;
    Integer copies = 1;
    FuncionesGenerales funcionesGenerales = new FuncionesGenerales();

    public void initialize(URL url, ResourceBundle rb) {
        AsynckAutoClose asynckAutoClose = new AsynckAutoClose();
        asynckAutoClose.setDaemon(false);
        asynckAutoClose.execute(new String[0]);
    }

    public void enviarComprobanteElectronico() {
        SendCompElectronicoTask myAsyncTask = new SendCompElectronicoTask();
        myAsyncTask.setDaemon(false);
        myAsyncTask.execute(new String[0]);
    }

    public void enviarRegistroInterno() {
        SendCompRegistroInternoTask myAsyncTask = new SendCompRegistroInternoTask();
        myAsyncTask.setDaemon(false);
        myAsyncTask.execute(new String[0]);
    }

    public void enviarFacturaSimplificada() {
        SendCompSimplificadoTask myAsyncTask = new SendCompSimplificadoTask();
        myAsyncTask.setDaemon(false);
        myAsyncTask.execute(new String[0]);
    }

    public void enviarComprobanteCompra() {
        SendCompCompraTask myAsyncTask = new SendCompCompraTask();
        myAsyncTask.setDaemon(false);
        myAsyncTask.execute(new String[0]);
    }

    public void enviarComprobanteProforma() {
        SendCompProformaTask myAsyncTask = new SendCompProformaTask();
        myAsyncTask.setDaemon(false);
        myAsyncTask.execute(new String[0]);
    }

    public void enviarComprobanteRecepcion() {
        SendCompRecepcionTask myAsyncTask = new SendCompRecepcionTask();
        myAsyncTask.setDaemon(false);
        myAsyncTask.execute(new String[0]);
    }

    public void reeenviarCorreoComprobante() {
        EnviarCorreoCompTask myAsyncTask = new EnviarCorreoCompTask();
        myAsyncTask.setDaemon(false);
        myAsyncTask.execute(new String[0]);
    }

    public void reeenviarCorreoProforma() {
        EnviarCorreoProformaTask myAsyncTask = new EnviarCorreoProformaTask();
        myAsyncTask.setDaemon(false);
        myAsyncTask.execute(new String[0]);
    }

    public void enviarCorreoResumenContable() {
        EnviarCorreoResumenContableTask myAsyncTask = new EnviarCorreoResumenContableTask();
        myAsyncTask.setDaemon(false);
        myAsyncTask.execute(new String[0]);
    }

    public void enviarCorreoResumenGastos() {
        EnviarCorreoResumenGastosTask myAsyncTask = new EnviarCorreoResumenGastosTask();
        myAsyncTask.setDaemon(false);
        myAsyncTask.execute(new String[0]);
    }

    public void setComprobanteElectronicoDto(ComprobanteElectronicoDto comprobanteElectronicoDto) {
        this.comprobanteElectronicoDto = comprobanteElectronicoDto;
        try {
            this.lblFecha.setText(FuncionesGenerales.getDateFormatedSort(comprobanteElectronicoDto.getFechaEmision()));
            this.lblCliente.setText(comprobanteElectronicoDto.getReceptor().getNombre());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setComprobanteCompraDto(ComprobanteCompraDto comprobanteCompraDto) {
        this.comprobanteCompraDto = comprobanteCompraDto;
        try {
            this.lblFecha.setText(FuncionesGenerales.getDateFormatedSort(comprobanteCompraDto.getFechaEmision()));
            this.lblCliente.setText(comprobanteCompraDto.getEmisor().getNombre());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setComprobanteProformaDto(ComprobanteProformaDto comprobanteProformaDto) {
        this.comprobanteProformaDto = comprobanteProformaDto;
        try {
            this.lblFecha.setText(FuncionesGenerales.getDateFormatedSort(comprobanteProformaDto.getFechaEmision()));
            this.lblCliente.setText(comprobanteProformaDto.getReceptor().getNombre());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setComprobanteRecepcionDto(ComprobanteRecepcionDto comprobanteRecepcionDto) {
        this.comprobanteRecepcionDto = comprobanteRecepcionDto;
        try {
            this.lblFecha.setText(FuncionesGenerales.getDateFormatedSort(LocalDateTime.now()));
            this.lblCliente.setText(comprobanteRecepcionDto.getNombreEmisor());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setAnchorPane(AnchorPane anchorPane) {
        this.anchorPane = anchorPane;
    }

    public void setTipo(String tipo) {
        this.tipo = tipo;
    }

    public void setLblFecha(String lblFecha) {
        this.lblFecha.setText(lblFecha);
    }

    public void setLblCliente(String lblCliente) {
        this.lblCliente.setText(lblCliente);
    }

    public void setCodigoMensaje(String codigoMensaje) {
        this.codigoMensaje = codigoMensaje;
    }

    public void setTxtRespuesta(Text txtRespuesta) {
        this.txtRespuesta = txtRespuesta;
    }

    public ResumenContableDto getResumenContableDto() {
        return this.resumenContableDto;
    }

    public void setResumenContableDto(ResumenContableDto resumenContableDto) {
        this.resumenContableDto = resumenContableDto;
    }

    @FXML
    private void onBtnEliminarNot(ActionEvent event) {
        GlobalApp.vBoxNotificaciones.getChildren().remove((Object)this.anchorPane);
        FuncionesGenerales.procesaVBoxNotificaciones();
    }

    public Integer getIdComprobanteDto() {
        return this.idComprobanteDto;
    }

    public void setIdComprobanteDto(Integer idComprobanteDto) {
        this.idComprobanteDto = idComprobanteDto;
    }

    public String getCorreoDestino() {
        return this.correoDestino;
    }

    public void setCorreoDestino(String correoDestino) {
        this.correoDestino = correoDestino;
    }

    public Integer getCopies() {
        return this.copies;
    }

    public void setCopies(Integer copies) {
        this.copies = copies;
    }

    private class AsynckAutoClose
    extends AsyncTask<String, Integer, Boolean> {
        private AsynckAutoClose() {
        }

        public void onPreExecute() {
        }

        public Boolean doInBackground(String ... params) {
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(NotificacionViewController.class.getName()).log(Level.SEVERE, null, ex);
            }
            return true;
        }

        public void onPostExecute(Boolean success) {
            GlobalApp.vBoxNotificaciones.getChildren().remove((Object)WaitingViewController.this.anchorPane);
            FuncionesGenerales.procesaVBoxNotificaciones();
        }

        public void progressCallback(Integer ... params) {
        }
    }

    private class SendCompCompraTask
    extends AsyncTask<String, Integer, Boolean> {
        private SendCompCompraTask() {
        }

        public void onPreExecute() {
            if (WaitingViewController.this.tipo.equalsIgnoreCase("08")) {
                WaitingViewController.this.lblTipo.setText("Factura Compra");
            }
            WaitingViewController.this.imgResultado.setVisible(false);
            WaitingViewController.this.imgProcesando.setVisible(true);
        }

        public Boolean doInBackground(String ... params) {
            ComprobanteCompraService service = (ComprobanteCompraService)AppContext.getInstance().get("ComprobanteCompraService");
            Respuesta respuesta = service.saveComprobante(WaitingViewController.this.comprobanteCompraDto);
            if (respuesta.getEstado().booleanValue()) {
                WaitingViewController.this.mensaje = "Enviado correctamente";
                WaitingViewController.this.correcto = true;
            } else {
                WaitingViewController.this.mensaje = "Finalizado incorrectamente.";
                WaitingViewController.this.correcto = false;
            }
            return true;
        }

        public void onPostExecute(Boolean success) {
            WaitingViewController.this.txtEstado.setText(WaitingViewController.this.mensaje);
            FuncionesGenerales funcionesGenerales = new FuncionesGenerales();
            if (WaitingViewController.this.correcto.booleanValue()) {
                WaitingViewController.this.imgResultado.setImage(funcionesGenerales.obtenerImagen("ok_not.png"));
            } else {
                WaitingViewController.this.imgResultado.setImage(funcionesGenerales.obtenerImagen("error_not.png"));
            }
            WaitingViewController.this.imgResultado.setVisible(true);
            WaitingViewController.this.imgProcesando.setVisible(false);
        }

        public void progressCallback(Integer ... params) {
        }
    }

    private class EnviarCorreoResumenGastosTask
    extends AsyncTask<String, Integer, Boolean> {
        String msj = null;

        private EnviarCorreoResumenGastosTask() {
        }

        public void onPreExecute() {
            WaitingViewController.this.lblTipo.setText("Env\u00edo de gastos");
            WaitingViewController.this.imgResultado.setVisible(false);
            WaitingViewController.this.imgProcesando.setVisible(true);
        }

        public Boolean doInBackground(String ... params) {
            ComprobanteService service = (ComprobanteService)AppContext.getInstance().get("ComprobanteService");
            Respuesta respuesta = service.getEnviarCorreoResumenGastos(WaitingViewController.this.resumenContableDto);
            this.msj = (String)respuesta.getResultado(ESTADO.OK.VALUE());
            if (respuesta.getEstado().booleanValue()) {
                WaitingViewController.this.mensaje = "Enviado correctamente";
                WaitingViewController.this.correcto = true;
            } else {
                WaitingViewController.this.mensaje = "Finalizado incorrectamente";
                WaitingViewController.this.correcto = false;
            }
            return true;
        }

        public void onPostExecute(Boolean success) {
            WaitingViewController.this.txtEstado.setText(WaitingViewController.this.mensaje);
            FuncionesGenerales funcionesGenerales = new FuncionesGenerales();
            if (WaitingViewController.this.correcto.booleanValue()) {
                WaitingViewController.this.imgResultado.setImage(funcionesGenerales.obtenerImagen("ok_not.png"));
                WaitingViewController.this.txtRespuesta.setText(this.msj);
            } else {
                WaitingViewController.this.imgResultado.setImage(funcionesGenerales.obtenerImagen("error_not.png"));
                WaitingViewController.this.txtRespuesta.setText(this.msj);
            }
            WaitingViewController.this.imgResultado.setVisible(true);
            WaitingViewController.this.imgProcesando.setVisible(false);
        }

        public void progressCallback(Integer ... params) {
        }
    }

    public class EnviarCorreoResumenContableTask
    extends AsyncTask<String, Integer, Boolean> {
        String msj = null;

        public void onPreExecute() {
            WaitingViewController.this.lblTipo.setText("Env\u00edo de documentos contables");
            WaitingViewController.this.imgResultado.setVisible(false);
            WaitingViewController.this.imgProcesando.setVisible(true);
        }

        public Boolean doInBackground(String ... params) {
            ComprobanteService service = (ComprobanteService)AppContext.getInstance().get("ComprobanteService");
            Respuesta respuesta = service.getEnviarCorreoResumenContable(WaitingViewController.this.resumenContableDto);
            this.msj = (String)respuesta.getResultado(ESTADO.OK.VALUE());
            if (respuesta.getEstado().booleanValue()) {
                WaitingViewController.this.mensaje = "Enviado correctamente";
                WaitingViewController.this.correcto = true;
            } else {
                WaitingViewController.this.mensaje = "Finalizado incorrectamente";
                WaitingViewController.this.correcto = false;
            }
            return true;
        }

        public void onPostExecute(Boolean success) {
            WaitingViewController.this.txtEstado.setText(WaitingViewController.this.mensaje);
            FuncionesGenerales funcionesGenerales = new FuncionesGenerales();
            if (WaitingViewController.this.correcto.booleanValue()) {
                WaitingViewController.this.imgResultado.setImage(funcionesGenerales.obtenerImagen("ok_not.png"));
                WaitingViewController.this.txtRespuesta.setText(this.msj);
            } else {
                WaitingViewController.this.imgResultado.setImage(funcionesGenerales.obtenerImagen("error_not.png"));
                WaitingViewController.this.txtRespuesta.setText(this.msj);
            }
            WaitingViewController.this.imgResultado.setVisible(true);
            WaitingViewController.this.imgProcesando.setVisible(false);
        }

        public void progressCallback(Integer ... params) {
        }
    }

    public class EnviarCorreoProformaTask
    extends AsyncTask<String, Integer, Boolean> {
        String msj = null;

        public void onPreExecute() {
            WaitingViewController.this.lblTipo.setText("Reenv\u00edo de proforma");
            WaitingViewController.this.imgResultado.setVisible(false);
            WaitingViewController.this.imgProcesando.setVisible(true);
        }

        public Boolean doInBackground(String ... params) {
            ProformaService service = (ProformaService)AppContext.getInstance().get("ProformaService");
            Respuesta respuesta = service.getEnviarCorreoComp(WaitingViewController.this.idComprobanteDto, WaitingViewController.this.correoDestino);
            this.msj = (String)respuesta.getResultado(ESTADO.OK.VALUE());
            if (respuesta.getEstado().booleanValue()) {
                WaitingViewController.this.mensaje = "Enviado correctamente";
                WaitingViewController.this.correcto = true;
            } else {
                WaitingViewController.this.mensaje = "Finalizado incorrectamente";
                WaitingViewController.this.correcto = false;
            }
            return true;
        }

        public void onPostExecute(Boolean success) {
            WaitingViewController.this.txtEstado.setText(WaitingViewController.this.mensaje);
            FuncionesGenerales funcionesGenerales = new FuncionesGenerales();
            if (WaitingViewController.this.correcto.booleanValue()) {
                WaitingViewController.this.imgResultado.setImage(funcionesGenerales.obtenerImagen("ok_not.png"));
                WaitingViewController.this.txtRespuesta.setText(this.msj);
            } else {
                WaitingViewController.this.imgResultado.setImage(funcionesGenerales.obtenerImagen("error_not.png"));
                WaitingViewController.this.txtRespuesta.setText(this.msj);
            }
            WaitingViewController.this.imgResultado.setVisible(true);
            WaitingViewController.this.imgProcesando.setVisible(false);
        }

        public void progressCallback(Integer ... params) {
        }
    }

    private class EnviarCorreoCompTask
    extends AsyncTask<String, Integer, Boolean> {
        String msj = null;

        private EnviarCorreoCompTask() {
        }

        public void onPreExecute() {
            WaitingViewController.this.lblTipo.setText("Reenv\u00edo de documentos");
            WaitingViewController.this.imgResultado.setVisible(false);
            WaitingViewController.this.imgProcesando.setVisible(true);
        }

        public Boolean doInBackground(String ... params) {
            ComprobanteService service = (ComprobanteService)AppContext.getInstance().get("ComprobanteService");
            Respuesta respuesta = service.getEnviarCorreoComp(WaitingViewController.this.idComprobanteDto, WaitingViewController.this.correoDestino);
            this.msj = (String)respuesta.getResultado(ESTADO.OK.VALUE());
            if (respuesta.getEstado().booleanValue()) {
                WaitingViewController.this.mensaje = "Enviado correctamente";
                WaitingViewController.this.correcto = true;
            } else {
                WaitingViewController.this.mensaje = "Finalizado incorrectamente";
                WaitingViewController.this.correcto = false;
            }
            return true;
        }

        public void onPostExecute(Boolean success) {
            WaitingViewController.this.txtEstado.setText(WaitingViewController.this.mensaje);
            FuncionesGenerales funcionesGenerales = new FuncionesGenerales();
            if (WaitingViewController.this.correcto.booleanValue()) {
                WaitingViewController.this.imgResultado.setImage(funcionesGenerales.obtenerImagen("ok_not.png"));
                WaitingViewController.this.txtRespuesta.setText(this.msj);
            } else {
                WaitingViewController.this.imgResultado.setImage(funcionesGenerales.obtenerImagen("error_not.png"));
                WaitingViewController.this.txtRespuesta.setText(this.msj);
            }
            WaitingViewController.this.imgResultado.setVisible(true);
            WaitingViewController.this.imgProcesando.setVisible(false);
        }

        public void progressCallback(Integer ... params) {
        }
    }

    private class SendCompRecepcionTask
    extends AsyncTask<String, Integer, Boolean> {
        private SendCompRecepcionTask() {
        }

        public void onPreExecute() {
            if (WaitingViewController.this.codigoMensaje.equalsIgnoreCase("1")) {
                WaitingViewController.this.lblTipo.setText("Confirmaci\u00f3n de aceptado");
            }
            if (WaitingViewController.this.codigoMensaje.equalsIgnoreCase("2")) {
                WaitingViewController.this.lblTipo.setText("Confirmaci\u00f3n de aceptado parcial");
            }
            if (WaitingViewController.this.codigoMensaje.equalsIgnoreCase("3")) {
                WaitingViewController.this.lblTipo.setText("Confirmaci\u00f3n de rechazo");
            }
            WaitingViewController.this.imgResultado.setVisible(false);
            WaitingViewController.this.imgProcesando.setVisible(true);
        }

        public Boolean doInBackground(String ... params) {
            ComprobanteRecepcionService service = (ComprobanteRecepcionService)AppContext.getInstance().get("ComprobanteRecepcionService");
            Respuesta respuesta = service.saveComprobanteRecepcion(WaitingViewController.this.comprobanteRecepcionDto);
            if (respuesta.getEstado().booleanValue()) {
                WaitingViewController.this.mensaje = "Enviado correctamente";
                WaitingViewController.this.correcto = true;
            } else {
                WaitingViewController.this.mensaje = "Finalizado incorrectamente";
                WaitingViewController.this.correcto = false;
            }
            return true;
        }

        public void onPostExecute(Boolean success) {
            WaitingViewController.this.txtEstado.setText(WaitingViewController.this.mensaje);
            FuncionesGenerales funcionesGenerales = new FuncionesGenerales();
            if (WaitingViewController.this.correcto.booleanValue()) {
                WaitingViewController.this.imgResultado.setImage(funcionesGenerales.obtenerImagen("ok_not.png"));
                WaitingViewController.this.txtRespuesta.setText("El comprobante fue enviado al Ministerio de Hacienda correctamente, favor verificar la respuesta en el m\u00f3dulo de confirmaciones realizadas.");
            } else {
                WaitingViewController.this.imgResultado.setImage(funcionesGenerales.obtenerImagen("error_not.png"));
                WaitingViewController.this.txtRespuesta.setText("El comprobante no pudo ser enviado al Ministerio de Hacienda, favor verifica los datos del archivo y contacte al emisor.");
            }
            WaitingViewController.this.imgResultado.setVisible(true);
            WaitingViewController.this.imgProcesando.setVisible(false);
        }

        public void progressCallback(Integer ... params) {
        }
    }

    private class SendCompProformaTask
    extends AsyncTask<String, Integer, Boolean> {
        private SendCompProformaTask() {
        }

        public void onPreExecute() {
            WaitingViewController.this.lblTipo.setText("Factura proforma");
            WaitingViewController.this.imgResultado.setVisible(false);
            WaitingViewController.this.imgProcesando.setVisible(true);
        }

        public Boolean doInBackground(String ... params) {
            ProformaService service = (ProformaService)AppContext.getInstance().get("ProformaService");
            Respuesta respuesta = service.saveComprobante(WaitingViewController.this.comprobanteProformaDto);
            if (respuesta.getEstado().booleanValue()) {
                WaitingViewController.this.mensaje = "Enviado correctamente";
                WaitingViewController.this.correcto = true;
            } else {
                WaitingViewController.this.mensaje = "Finalizado incorrectamente";
                WaitingViewController.this.correcto = false;
            }
            JasperPrint reporte = (JasperPrint)respuesta.getResultado(ESTADO.OK.VALUE());
            try {
                WaitingViewController.this.funcionesGenerales.printInvoice(reporte);
                if (WaitingViewController.this.copies == 2) {
                    WaitingViewController.this.funcionesGenerales.printInvoice(reporte);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }

        public void onPostExecute(Boolean success) {
            WaitingViewController.this.txtEstado.setText(WaitingViewController.this.mensaje);
            FuncionesGenerales funcionesGenerales = new FuncionesGenerales();
            if (WaitingViewController.this.correcto.booleanValue()) {
                WaitingViewController.this.imgResultado.setImage(funcionesGenerales.obtenerImagen("okIcon.png"));
            } else {
                WaitingViewController.this.imgResultado.setImage(funcionesGenerales.obtenerImagen("cloudErrorIcon.png"));
            }
            WaitingViewController.this.imgResultado.setVisible(true);
            WaitingViewController.this.imgProcesando.setVisible(false);
        }

        public void progressCallback(Integer ... params) {
        }
    }

    private class SendCompElectronicoTask
    extends AsyncTask<String, Integer, Boolean> {
        private SendCompElectronicoTask() {
        }

        public void onPreExecute() {
            if (WaitingViewController.this.tipo.equalsIgnoreCase("01")) {
                WaitingViewController.this.lblTipo.setText("Factura electr\u00f3nica");
            }
            if (WaitingViewController.this.tipo.equalsIgnoreCase("02")) {
                WaitingViewController.this.lblTipo.setText("Nota d\u00e9dito electr\u00f3nica");
            }
            if (WaitingViewController.this.tipo.equalsIgnoreCase("03")) {
                WaitingViewController.this.lblTipo.setText("Nota cr\u00e9dito electr\u00f3nica");
            }
            if (WaitingViewController.this.tipo.equalsIgnoreCase("04")) {
                WaitingViewController.this.lblTipo.setText("Tiquete electr\u00f3nico");
            }
            WaitingViewController.this.imgResultado.setVisible(false);
            WaitingViewController.this.imgProcesando.setVisible(true);
        }

        public Boolean doInBackground(String ... params) {
            ComprobanteService service = (ComprobanteService)AppContext.getInstance().get("ComprobanteService");
            Respuesta respuesta = service.saveComprobante(WaitingViewController.this.comprobanteElectronicoDto);
            if (respuesta.getEstado().booleanValue()) {
                WaitingViewController.this.mensaje = "Enviado correctamente";
                WaitingViewController.this.correcto = true;
                JasperPrint reporte = (JasperPrint)respuesta.getResultado(ESTADO.OK.VALUE());
                try {
                    WaitingViewController.this.funcionesGenerales.printInvoice(reporte);
                    if (WaitingViewController.this.copies == 2) {
                        WaitingViewController.this.funcionesGenerales.printInvoice(reporte);
                    }
                }
                catch (Exception exception) {}
            } else {
                WaitingViewController.this.mensaje = "Comprobante No enviado!";
                WaitingViewController.this.correcto = false;
            }
            return true;
        }

        public void onPostExecute(Boolean success) {
            WaitingViewController.this.txtEstado.setText(WaitingViewController.this.mensaje);
            FuncionesGenerales funcionesGenerales = new FuncionesGenerales();
            if (WaitingViewController.this.correcto.booleanValue()) {
                WaitingViewController.this.imgResultado.setImage(funcionesGenerales.obtenerImagen("ok_not.png"));
            } else {
                WaitingViewController.this.imgResultado.setImage(funcionesGenerales.obtenerImagen("error_not.png"));
            }
            WaitingViewController.this.imgResultado.setVisible(true);
            WaitingViewController.this.imgProcesando.setVisible(false);
        }

        public void progressCallback(Integer ... params) {
        }
    }

    private class SendCompRegistroInternoTask
    extends AsyncTask<String, Integer, Boolean> {
        private SendCompRegistroInternoTask() {
        }

        public void onPreExecute() {
            WaitingViewController.this.lblTipo.setText("Registro Interno");
            WaitingViewController.this.imgResultado.setVisible(false);
            WaitingViewController.this.imgProcesando.setVisible(true);
        }

        public Boolean doInBackground(String ... params) {
            ComprobanteService service = (ComprobanteService)AppContext.getInstance().get("ComprobanteService");
            Respuesta respuesta = service.saveRegistroInterno(WaitingViewController.this.comprobanteElectronicoDto);
            if (respuesta.getEstado().booleanValue()) {
                WaitingViewController.this.mensaje = "Registo guardado!";
                WaitingViewController.this.correcto = true;
            } else {
                WaitingViewController.this.mensaje = "Error con el Registro!";
                WaitingViewController.this.correcto = false;
            }
            return true;
        }

        public void onPostExecute(Boolean success) {
            WaitingViewController.this.txtEstado.setText(WaitingViewController.this.mensaje);
            FuncionesGenerales funcionesGenerales = new FuncionesGenerales();
            if (WaitingViewController.this.correcto.booleanValue()) {
                WaitingViewController.this.imgResultado.setImage(funcionesGenerales.obtenerImagen("ok_not.png"));
            } else {
                WaitingViewController.this.imgResultado.setImage(funcionesGenerales.obtenerImagen("error_not.png"));
            }
            WaitingViewController.this.imgResultado.setVisible(true);
            WaitingViewController.this.imgProcesando.setVisible(false);
        }

        public void progressCallback(Integer ... params) {
        }
    }

    private class SendCompSimplificadoTask
    extends AsyncTask<String, Integer, Boolean> {
        private SendCompSimplificadoTask() {
        }

        public void onPreExecute() {
            WaitingViewController.this.lblTipo.setText("Factura simplificada");
            WaitingViewController.this.imgResultado.setVisible(false);
            WaitingViewController.this.imgProcesando.setVisible(true);
        }

        public Boolean doInBackground(String ... params) {
            ComprobanteService service = (ComprobanteService)AppContext.getInstance().get("ComprobanteService");
            Respuesta respuesta = service.saveSimplificado(WaitingViewController.this.comprobanteElectronicoDto);
            if (respuesta.getEstado().booleanValue()) {
                WaitingViewController.this.mensaje = "Factura registrada!";
                WaitingViewController.this.correcto = true;
                if (WaitingViewController.this.copies == 2) {
                    JasperPrint reporte = (JasperPrint)respuesta.getResultado(ESTADO.OK.VALUE());
                    try {
                        WaitingViewController.this.funcionesGenerales.printInvoice(reporte);
                    }
                    catch (Exception exception) {}
                }
            } else {
                WaitingViewController.this.mensaje = "Error registrando factura!";
                WaitingViewController.this.correcto = false;
            }
            return true;
        }

        public void onPostExecute(Boolean success) {
            WaitingViewController.this.txtEstado.setText(WaitingViewController.this.mensaje);
            FuncionesGenerales funcionesGenerales = new FuncionesGenerales();
            if (WaitingViewController.this.correcto.booleanValue()) {
                WaitingViewController.this.imgResultado.setImage(funcionesGenerales.obtenerImagen("ok_not.png"));
            } else {
                WaitingViewController.this.imgResultado.setImage(funcionesGenerales.obtenerImagen("error_not.png"));
            }
            WaitingViewController.this.imgResultado.setVisible(true);
            WaitingViewController.this.imgProcesando.setVisible(false);
        }

        public void progressCallback(Integer ... params) {
        }
    }
}

