/*
 * Decompiled with CFR 0.152.
 */
package electricpos.customcontrol;

import com.jfoenix.controls.JFXButton;
import electricpos.model.CicloFacturacionDto;
import electricpos.util.FuncionesGenerales;
import java.io.IOException;
import java.text.DecimalFormat;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;

public class CicloFacturacionController
extends AnchorPane {
    @FXML
    private ImageView imgEstado;
    @FXML
    private Label lblFechaIni;
    @FXML
    private Label lblFechaFin;
    @FXML
    private Label lblTipo;
    @FXML
    private Label lblTotal;
    @FXML
    private Label lblEstado;
    @FXML
    JFXButton btnPagar;
    DecimalFormat df = new DecimalFormat("\u20a1 ###,###.00");
    DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd-MMMM-yyyy", new Locale("es", "ES"));
    FuncionesGenerales funcionesGenerales = new FuncionesGenerales();

    public CicloFacturacionController(CicloFacturacionDto cf) {
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/electricpos/customcontrol/CicloFacturacion.fxml"));
        fxmlLoader.setRoot((Object)this);
        fxmlLoader.setController((Object)this);
        try {
            fxmlLoader.load();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        this.lblTotal.setText(this.df.format(cf.getTotal()));
        this.lblFechaIni.setText(cf.getFechaInicio().format(this.formatter));
        this.lblFechaFin.setText(cf.getFechaFin().format(this.formatter));
        this.lblTipo.setText(cf.getDescripcionPlan());
        if (cf.getCancelado().equalsIgnoreCase("S")) {
            this.lblEstado.setText("Pagada");
            this.btnPagar.setDisable(true);
            this.imgEstado.setImage(this.funcionesGenerales.obtenerImagen("okIcon.png"));
        } else {
            this.lblEstado.setText("Pendiente");
            this.btnPagar.setDisable(false);
            this.imgEstado.setImage(this.funcionesGenerales.obtenerImagen("advertencia.png"));
        }
    }
}

