/*
 * Decompiled with CFR 0.152.
 */
package electricpos.customcontrol;

import com.jfoenix.controls.JFXButton;
import electricpos.controller.FacturasViewController;
import electricpos.controller.MensajeHaciendaViewController;
import electricpos.controller.PrincipalController;
import electricpos.controller.ProductoServicioViewController;
import electricpos.controller.WaitingViewController;
import electricpos.model.ComprobanteElectronicoDto;
import electricpos.model.ComprobanteHaciendaDto;
import electricpos.model.GlobalApp;
import electricpos.model.MensajeHacienda;
import electricpos.service.ComprobanteService;
import electricpos.util.AppContext;
import electricpos.util.FuncionesGenerales;
import electricpos.util.Mensaje;
import electricpos.util.Respuesta;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.codec.binary.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class ComprobanteCCController
extends AnchorPane {
    @FXML
    ImageView imgTipo;
    @FXML
    ImageView imgHacienda;
    @FXML
    ImageView imgEstado;
    @FXML
    JFXButton btnReversar;
    @FXML
    Label lblClave;
    @FXML
    Label lblHacienda;
    @FXML
    Label lblFecha;
    @FXML
    Label lblEnvio;
    @FXML
    Label lblEstado;
    String respuestaXml;
    String claveComp = null;
    String tipoComp = null;
    Boolean puedeReversar = false;
    MensajeHacienda mensajeHac = new MensajeHacienda();
    FuncionesGenerales funcionesGenerales = new FuncionesGenerales();

    public ComprobanteCCController(ComprobanteHaciendaDto comprobanteHaciendaDtos) {
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/electricpos/customcontrol/ComprobanteCC.fxml"));
        fxmlLoader.setRoot((Object)this);
        fxmlLoader.setController((Object)this);
        try {
            fxmlLoader.load();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        try {
            if (comprobanteHaciendaDtos.getTipo().equalsIgnoreCase("04")) {
                this.puedeReversar = true;
                this.imgTipo.setImage(this.funcionesGenerales.obtenerImagen("tiqueteIcon.png"));
            }
            if (comprobanteHaciendaDtos.getTipo().equalsIgnoreCase("01")) {
                this.puedeReversar = true;
                this.imgTipo.setImage(this.funcionesGenerales.obtenerImagen("facturaIcon.png"));
            }
            if (comprobanteHaciendaDtos.getTipo().equalsIgnoreCase("03")) {
                this.imgTipo.setImage(this.funcionesGenerales.obtenerImagen("creditoIcon.png"));
            }
            if (comprobanteHaciendaDtos.getTipo().equalsIgnoreCase("02")) {
                this.imgTipo.setImage(this.funcionesGenerales.obtenerImagen("debitoIcon.png"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (comprobanteHaciendaDtos.getEstadoComprobante().equalsIgnoreCase("aceptado")) {
                this.puedeReversar = true;
                this.imgHacienda.setImage(this.funcionesGenerales.obtenerImagen("aceptadoIcon.png"));
            }
            if (comprobanteHaciendaDtos.getEstadoComprobante().equalsIgnoreCase("rechazado")) {
                this.puedeReversar = true;
                this.imgHacienda.setImage(this.funcionesGenerales.obtenerImagen("rechazadoIcon.png"));
            }
            if (comprobanteHaciendaDtos.getEstadoComprobante().equalsIgnoreCase("procesando")) {
                this.puedeReversar = false;
                this.imgHacienda.setImage(this.funcionesGenerales.obtenerImagen("procesandoIcon.png"));
            }
            if (comprobanteHaciendaDtos.getEstadoComprobante().equalsIgnoreCase("recibido")) {
                this.puedeReversar = false;
                this.imgHacienda.setImage(this.funcionesGenerales.obtenerImagen("recibidoIcon.png"));
            }
            if (comprobanteHaciendaDtos.getEstadoComprobante().equalsIgnoreCase("error")) {
                this.puedeReversar = true;
                this.imgHacienda.setImage(this.funcionesGenerales.obtenerImagen("errorIcon.png"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (comprobanteHaciendaDtos.getReversadoTotal().equalsIgnoreCase("S")) {
                this.puedeReversar = false;
                this.lblEstado.setText("Reversado");
                this.imgEstado.setImage(this.funcionesGenerales.obtenerImagen("reversadoIcon.png"));
            } else {
                if (!comprobanteHaciendaDtos.getEstadoComprobante().equalsIgnoreCase("recibido") && !comprobanteHaciendaDtos.getEstadoComprobante().equalsIgnoreCase("procesando")) {
                    this.puedeReversar = true;
                }
                this.lblEstado.setText("Activo");
                this.imgEstado.setImage(this.funcionesGenerales.obtenerImagen("activoIcon.png"));
            }
        }
        catch (Exception ex) {
            this.lblEstado.setText("Activo");
            this.imgEstado.setImage(this.funcionesGenerales.obtenerImagen("activoIcon.png"));
        }
        if (comprobanteHaciendaDtos.getEnviado().equalsIgnoreCase("N")) {
            this.puedeReversar = false;
        }
        if (comprobanteHaciendaDtos.getInterno().equalsIgnoreCase("N")) {
            this.puedeReversar = false;
        }
        this.lblClave.setText(comprobanteHaciendaDtos.getClave());
        if (comprobanteHaciendaDtos.getEnviado().equalsIgnoreCase("N")) {
            this.lblHacienda.setText("En espera");
        } else {
            this.lblHacienda.setText(comprobanteHaciendaDtos.getEstadoComprobante());
        }
        String str = comprobanteHaciendaDtos.getFecha();
        DateTimeFormatter formatterIn = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssXXX");
        DateTimeFormatter formatterIn2 = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");
        DateTimeFormatter formatterOut = DateTimeFormatter.ofPattern("dd-MM-yyyy HH:mm a");
        try {
            LocalDateTime dateTime = LocalDateTime.parse(str, formatterIn);
            this.lblFecha.setText(dateTime.format(formatterOut));
        }
        catch (Exception ex) {
            try {
                LocalDateTime dateTime = LocalDateTime.parse(str, formatterIn2);
                this.lblFecha.setText(dateTime.format(formatterOut));
            }
            catch (Exception e) {
                this.lblFecha.setText(str);
            }
        }
        this.respuestaXml = comprobanteHaciendaDtos.getRespuestaXml();
        if (comprobanteHaciendaDtos.getEnviado().equalsIgnoreCase("N")) {
            this.lblEnvio.setText("En cola");
        } else {
            this.lblEnvio.setText(comprobanteHaciendaDtos.getRespuestaEnvio());
        }
        this.claveComp = comprobanteHaciendaDtos.getClave();
        this.tipoComp = comprobanteHaciendaDtos.getTipo();
        this.btnReversar.setDisable(this.puedeReversar == false);
    }

    @FXML
    private void onBtnDetalle(ActionEvent event) {
        this.leerXmlRespuesta();
    }

    public boolean mostrarComprobanteHilo(ComprobanteElectronicoDto comp) {
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/electricpos/view/WaitingView.fxml"));
            AnchorPane ancho = (AnchorPane)fxmlLoader.load();
            FuncionesGenerales.procesaVBoxNotificaciones();
            GlobalApp.vBoxNotificaciones.setVisible(true);
            GlobalApp.vBoxNotificaciones.getChildren().add((Object)ancho);
            WaitingViewController waitingViewController = (WaitingViewController)fxmlLoader.getController();
            waitingViewController.setAnchorPane(ancho);
            waitingViewController.setTipo(comp.getTipoCom());
            waitingViewController.setComprobanteElectronicoDto(comp);
            waitingViewController.enviarComprobanteElectronico();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @FXML
    private void onBtnReversar(ActionEvent event) {
        if (this.funcionesGenerales.getConfirmacionMensajeView("\u00bfEsta seguro de reversar la factura?")) {
            this.reversarComprobante(this.claveComp, this.tipoComp);
            try {
                FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/electricpos/view/FacturasView.fxml"));
                AnchorPane ancho = (AnchorPane)fxmlLoader.load();
                FacturasViewController controller = (FacturasViewController)fxmlLoader.getController();
                controller.setTipoComprobante("01");
                GlobalApp.panelPrincipalGlobal.getChildren().setAll((Object[])new Node[]{ancho});
            }
            catch (IOException ex) {
                Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private ComprobanteElectronicoDto getComprobanteClave(String clave) {
        Stage stage = (Stage)this.lblClave.getScene().getWindow();
        ComprobanteService service = (ComprobanteService)AppContext.getInstance().get("ComprobanteService");
        Respuesta respuesta = service.getComprobanteClave(clave);
        ComprobanteElectronicoDto comprobanteDto = null;
        if (respuesta.getEstado().booleanValue()) {
            comprobanteDto = (ComprobanteElectronicoDto)respuesta.getResultado("ComprobanteElectronico");
        } else {
            Mensaje.getInstance().showModal(Alert.AlertType.ERROR, "Obtener Comprobante", (Window)stage, respuesta.getMensaje());
        }
        return comprobanteDto;
    }

    private void reversarComprobante(String clave, String tipo) {
        ComprobanteElectronicoDto comprobanteReversar = this.getComprobanteClave(clave);
        Stage stage = (Stage)this.lblClave.getScene().getWindow();
        if (comprobanteReversar != null) {
            ComprobanteService service = (ComprobanteService)AppContext.getInstance().get("ComprobanteService");
            ComprobanteElectronicoDto comprobanteNuevo = new ComprobanteElectronicoDto();
            comprobanteNuevo = comprobanteReversar;
            comprobanteNuevo.setId(null);
            LocalDateTime date = LocalDateTime.now();
            comprobanteNuevo.setFechaEmision(date);
            if (tipo.equalsIgnoreCase("01") || tipo.equalsIgnoreCase("04")) {
                comprobanteNuevo.setTipoCom("03");
            }
            if (tipo.equalsIgnoreCase("03")) {
                comprobanteNuevo.setTipoCom("02");
            }
            if (tipo.equalsIgnoreCase("02")) {
                comprobanteNuevo.setTipoCom("03");
            }
            comprobanteNuevo.setTipoDocReferencia(tipo);
            comprobanteNuevo.setNumeroDocReferencia(comprobanteReversar.getClave());
            comprobanteNuevo.setFechaEmisionReferencia(comprobanteReversar.getFechaEmision());
            comprobanteNuevo.setCodigoReferencia("01");
            comprobanteNuevo.setRazonReferencia("Acuerdo entre emisor y receptor.");
            comprobanteNuevo.setReversadoTotal("N");
            this.mostrarComprobanteHilo(comprobanteNuevo);
        }
    }

    private void leerXmlRespuesta() {
        try {
            String string = this.respuestaXml;
            byte[] byteArray = Base64.decodeBase64((byte[])string.getBytes());
            String decodedString = new String(byteArray);
            ByteArrayInputStream stream = new ByteArrayInputStream(decodedString.getBytes(StandardCharsets.UTF_8));
            DocumentBuilder dBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = dBuilder.parse(stream);
            if (doc.hasChildNodes()) {
                this.printNote(doc.getChildNodes());
            }
            FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/electricpos/view/MensajeHaciendaView.fxml"));
            Parent root1 = null;
            try {
                root1 = (Parent)fxmlLoader.load();
            }
            catch (IOException ex) {
                Logger.getLogger(ProductoServicioViewController.class.getName()).log(Level.SEVERE, null, ex);
            }
            MensajeHaciendaViewController mensajeHaciendaViewController = (MensajeHaciendaViewController)fxmlLoader.getController();
            mensajeHaciendaViewController.setMensajeHacienda(this.mensajeHac);
            FuncionesGenerales.showView(root1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void printNote(NodeList nodeList) {
        for (int count = 0; count < nodeList.getLength(); ++count) {
            org.w3c.dom.Node tempNode = nodeList.item(count);
            if (tempNode.getNodeType() != 1) continue;
            if (tempNode.getNodeName().equalsIgnoreCase("Clave")) {
                this.mensajeHac.setClave(tempNode.getTextContent());
            }
            if (tempNode.getNodeName().equalsIgnoreCase("NombreEmisor")) {
                this.mensajeHac.setEmisor(tempNode.getTextContent());
            }
            if (tempNode.getNodeName().equalsIgnoreCase("NombreReceptor")) {
                this.mensajeHac.setReceptor(tempNode.getTextContent());
            }
            if (tempNode.getNodeName().equalsIgnoreCase("Clave")) {
                this.mensajeHac.setClave(tempNode.getTextContent());
            }
            if (tempNode.getNodeName().equalsIgnoreCase("DetalleMensaje")) {
                this.mensajeHac.setDetalle(tempNode.getTextContent());
            }
            if (tempNode.getNodeName().equalsIgnoreCase("Mensaje")) {
                this.mensajeHac.setMensaje(tempNode.getTextContent());
                Integer value = Integer.valueOf(this.mensajeHac.getMensaje());
                if (value == 1) {
                    this.mensajeHac.setSignificadoMensaje("Aceptado");
                }
                if (value == 2) {
                    this.mensajeHac.setSignificadoMensaje("Parcialmente aceptado");
                }
                if (value == 3) {
                    this.mensajeHac.setSignificadoMensaje("Rechazado");
                }
            }
            if (tempNode.getNodeName().equalsIgnoreCase("MontoTotalImpuesto")) {
                this.mensajeHac.setImpuesto(tempNode.getTextContent());
            }
            if (tempNode.getNodeName().equalsIgnoreCase("TotalFactura")) {
                this.mensajeHac.setTotal(tempNode.getTextContent());
            }
            if (!tempNode.hasChildNodes()) continue;
            this.printNote(tempNode.getChildNodes());
        }
    }
}

