/*
 * Decompiled with CFR 0.152.
 */
package electricpos.model;

import electricpos.model.CajaDto;
import java.io.Serializable;
import java.time.format.DateTimeFormatter;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;

public class CajaTv
implements Serializable {
    private static final long serialVersionUID = 1L;
    public Integer id;
    public SimpleStringProperty estado = new SimpleStringProperty();
    public SimpleStringProperty observaciones;
    public SimpleDoubleProperty montoCierre;
    public SimpleDoubleProperty montoApertura;
    public SimpleStringProperty fechaApertura = new SimpleStringProperty();
    public SimpleStringProperty fechaCierre;
    public CajaDto caja;

    public CajaTv(CajaDto caja) {
        this.observaciones = new SimpleStringProperty();
        this.fechaCierre = new SimpleStringProperty();
        this.montoCierre = new SimpleDoubleProperty();
        this.montoApertura = new SimpleDoubleProperty();
        this.caja = caja;
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd-MM-yyyy hh:mm:ss a");
        this.fechaApertura.set(caja.getFechaApertura().format(formatter));
        if (caja.getFechaCierre() != null) {
            this.fechaCierre.set(caja.getFechaCierre().format(formatter));
        }
        this.estado.set(caja.getEstado().equalsIgnoreCase("A") ? "Abierta" : "Cerrada");
        this.observaciones.set(caja.getObservaciones());
        this.montoCierre.set(caja.getMontoCierre().doubleValue());
        this.montoApertura.set(caja.getMontoApertura().doubleValue());
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public SimpleStringProperty getEstado() {
        return this.estado;
    }

    public void setEstado(SimpleStringProperty estado) {
        this.estado = estado;
    }

    public SimpleStringProperty getObservaciones() {
        return this.observaciones;
    }

    public void setObservaciones(SimpleStringProperty observaciones) {
        this.observaciones = observaciones;
    }

    public SimpleDoubleProperty getMontoCierre() {
        return this.montoCierre;
    }

    public void setMontoCierre(SimpleDoubleProperty montoCierre) {
        this.montoCierre = montoCierre;
    }

    public SimpleDoubleProperty getMontoApertura() {
        return this.montoApertura;
    }

    public void setMontoApertura(SimpleDoubleProperty montoApertura) {
        this.montoApertura = montoApertura;
    }

    public CajaDto getCaja() {
        return this.caja;
    }

    public void setCaja(CajaDto caja) {
        this.caja = caja;
    }

    public SimpleStringProperty getFechaApertura() {
        return this.fechaApertura;
    }

    public void setFechaApertura(SimpleStringProperty fechaApertura) {
        this.fechaApertura = fechaApertura;
    }

    public SimpleStringProperty getFechaCierre() {
        return this.fechaCierre;
    }

    public void setFechaCierre(SimpleStringProperty fechaCierre) {
        this.fechaCierre = fechaCierre;
    }
}

