/*
 * Decompiled with CFR 0.152.
 */
package electricpos.model;

import electricpos.model.ComprobanteResumenDto;
import electricpos.model.GlobalApp;
import java.time.format.DateTimeFormatter;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;

public class FacturasTv {
    public SimpleStringProperty tipo = new SimpleStringProperty();
    public SimpleStringProperty codigo;
    public SimpleStringProperty fecha = new SimpleStringProperty();
    public SimpleDoubleProperty montoTotal;
    public SimpleStringProperty cliente;
    public SimpleStringProperty estado;
    private ComprobanteResumenDto factura;

    public FacturasTv() {
        this.codigo = new SimpleStringProperty();
        this.montoTotal = new SimpleDoubleProperty();
        this.cliente = new SimpleStringProperty();
        this.estado = new SimpleStringProperty();
        this.factura = new ComprobanteResumenDto();
    }

    public FacturasTv(ComprobanteResumenDto comp) {
        this.codigo = new SimpleStringProperty();
        this.montoTotal = new SimpleDoubleProperty();
        this.cliente = new SimpleStringProperty();
        this.estado = new SimpleStringProperty();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd-MM-yyyy hh:mm:ss a");
        this.fecha.set(comp.getFechaEmision().format(formatter));
        String tipoMean = null;
        if (comp.getTipoCom().equals("01")) {
            tipoMean = "Factura";
        }
        if (comp.getTipoCom().equals("02")) {
            tipoMean = "Nota de d\u00e9bito";
        }
        if (comp.getTipoCom().equals("03")) {
            tipoMean = "Nota de cr\u00e9dito";
        }
        if (comp.getTipoCom().equals("04")) {
            tipoMean = "Tiquete";
        }
        this.tipo.set(tipoMean);
        if (comp.getNumeroConsecutivo().equalsIgnoreCase("0")) {
            this.codigo.set("Interno");
            if (GlobalApp.empresa.getEsSimplificado().equalsIgnoreCase("S")) {
                tipoMean = "Venta";
                if (comp.getTipoCom().equals("03")) {
                    tipoMean = "Devolucion";
                }
            } else {
                tipoMean = "Registro interno";
            }
            this.tipo.set(tipoMean);
        } else {
            this.codigo.set(comp.getNumeroConsecutivo());
        }
        try {
            this.cliente.set(comp.getReceptor().getNombre());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            String mean = comp.getReversadoTotal().equalsIgnoreCase("N") ? "Aplicada" : "Reversada";
            this.estado.set(mean);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.montoTotal.set(comp.getTotalComprobanteResumen().doubleValue());
        this.factura = comp;
    }

    public SimpleStringProperty getCodigo() {
        return this.codigo;
    }

    public void setCodigo(SimpleStringProperty codigo) {
        this.codigo = codigo;
    }

    public SimpleStringProperty getFecha() {
        return this.fecha;
    }

    public void setFecha(SimpleStringProperty fecha) {
        this.fecha = fecha;
    }

    public SimpleDoubleProperty getMontoTotal() {
        return this.montoTotal;
    }

    public void setMontoTotal(SimpleDoubleProperty montoTotal) {
        this.montoTotal = montoTotal;
    }

    public SimpleStringProperty getCliente() {
        return this.cliente;
    }

    public void setCliente(SimpleStringProperty cliente) {
        this.cliente = cliente;
    }

    public SimpleStringProperty getEstado() {
        return this.estado;
    }

    public void setEstado(SimpleStringProperty estado) {
        this.estado = estado;
    }

    public ComprobanteResumenDto getFactura() {
        return this.factura;
    }

    public void setFactura(ComprobanteResumenDto factura) {
        this.factura = factura;
    }
}

