/*
 * Decompiled with CFR 0.152.
 */
package electricpos.model;

import electricpos.model.ComprobanteRecepcionResumenDto;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;

public class GastosTv {
    public SimpleStringProperty consecutivo = new SimpleStringProperty();
    public SimpleStringProperty emisor = new SimpleStringProperty();
    public SimpleStringProperty fechaFactura = new SimpleStringProperty();
    public SimpleStringProperty fechaRecepcion = new SimpleStringProperty();
    public SimpleDoubleProperty montoImpuestos;
    public SimpleDoubleProperty montoTotal = new SimpleDoubleProperty();
    public SimpleStringProperty mensaje;
    public SimpleStringProperty estado;
    public SimpleStringProperty tipo;
    private ComprobanteRecepcionResumenDto comprobante;

    public GastosTv() {
        this.montoImpuestos = new SimpleDoubleProperty();
        this.mensaje = new SimpleStringProperty();
        this.estado = new SimpleStringProperty();
        this.tipo = new SimpleStringProperty();
        this.comprobante = new ComprobanteRecepcionResumenDto();
    }

    public GastosTv(ComprobanteRecepcionResumenDto comp) {
        this.montoImpuestos = new SimpleDoubleProperty();
        this.mensaje = new SimpleStringProperty();
        this.estado = new SimpleStringProperty();
        this.tipo = new SimpleStringProperty();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd-MM-yyyy hh:mm:ss a");
        this.consecutivo.set(comp.getConsecutivo());
        this.emisor.set(comp.getEmisor());
        DateTimeFormatter formatter1 = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssXXX");
        DateTimeFormatter formatter2 = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.0");
        DateTimeFormatter formatter3 = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        try {
            LocalDateTime formatDateTime = comp.getTipoCom().equalsIgnoreCase("08") ? LocalDateTime.parse(comp.getFechaComprobante(), formatter3) : LocalDateTime.parse(comp.getFechaComprobante(), formatter1);
            this.fechaFactura.set(formatDateTime.format(formatter));
        }
        catch (Exception ex) {
            this.fechaFactura.set(comp.getFechaComprobante());
        }
        try {
            LocalDateTime formatDateTime2 = LocalDateTime.parse(comp.getFechaRecepcion(), formatter2);
            this.fechaRecepcion.set(formatDateTime2.format(formatter));
        }
        catch (Exception ex) {
            this.fechaRecepcion.set(comp.getFechaRecepcion());
        }
        this.montoTotal.set(comp.getTotalComprobante().doubleValue());
        this.montoImpuestos.set(comp.getTotalImpuesto().doubleValue());
        this.mensaje.set(comp.getMensaje());
        this.estado.set(comp.getEstadoHacienda());
        String tipoDescripcion = "";
        tipoDescripcion = comp.getTipoCom().equalsIgnoreCase("01") ? "Comprobante recepci\u00f3n" : (comp.getTipoCom().equalsIgnoreCase("08") ? "Factura de compra" : comp.getTipoCom());
        this.tipo.set(tipoDescripcion);
        this.comprobante = comp;
    }

    public SimpleStringProperty getConsecutivo() {
        return this.consecutivo;
    }

    public void setConsecutivo(SimpleStringProperty consecutivo) {
        this.consecutivo = consecutivo;
    }

    public SimpleStringProperty getEmisor() {
        return this.emisor;
    }

    public void setEmisor(SimpleStringProperty emisor) {
        this.emisor = emisor;
    }

    public SimpleStringProperty getFechaFactura() {
        return this.fechaFactura;
    }

    public void setFechaFactura(SimpleStringProperty fechaFactura) {
        this.fechaFactura = fechaFactura;
    }

    public SimpleStringProperty getFechaRecepcion() {
        return this.fechaRecepcion;
    }

    public void setFechaRecepcion(SimpleStringProperty fechaRecepcion) {
        this.fechaRecepcion = fechaRecepcion;
    }

    public SimpleDoubleProperty getMontoImpuestos() {
        return this.montoImpuestos;
    }

    public void setMontoImpuestos(SimpleDoubleProperty montoImpuestos) {
        this.montoImpuestos = montoImpuestos;
    }

    public SimpleDoubleProperty getMontoTotal() {
        return this.montoTotal;
    }

    public void setMontoTotal(SimpleDoubleProperty montoTotal) {
        this.montoTotal = montoTotal;
    }

    public SimpleStringProperty getMensaje() {
        return this.mensaje;
    }

    public void setMensaje(SimpleStringProperty mensaje) {
        this.mensaje = mensaje;
    }

    public SimpleStringProperty getEstado() {
        return this.estado;
    }

    public void setEstado(SimpleStringProperty estado) {
        this.estado = estado;
    }

    public ComprobanteRecepcionResumenDto getComprobante() {
        return this.comprobante;
    }

    public void setComprobante(ComprobanteRecepcionResumenDto comprobante) {
        this.comprobante = comprobante;
    }
}

