/*
 * Decompiled with CFR 0.152.
 */
package electricpos.model;

import electricpos.model.MovimientoCreditoDto;
import java.time.format.DateTimeFormatter;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;

public class MovimientoCreditoTv {
    public SimpleStringProperty tipo;
    public SimpleStringProperty producto;
    public SimpleStringProperty estado;
    public SimpleStringProperty fecha;
    public SimpleDoubleProperty total;
    public SimpleDoubleProperty abono;
    public SimpleDoubleProperty saldo;
    public MovimientoCreditoDto movimientoCreditoDto;

    public MovimientoCreditoTv() {
        this.tipo = new SimpleStringProperty();
        this.producto = new SimpleStringProperty();
        this.estado = new SimpleStringProperty();
        this.fecha = new SimpleStringProperty();
        this.total = new SimpleDoubleProperty();
        this.abono = new SimpleDoubleProperty();
        this.saldo = new SimpleDoubleProperty();
    }

    public MovimientoCreditoTv(MovimientoCreditoDto mov) {
        this.movimientoCreditoDto = mov;
        this.tipo = new SimpleStringProperty();
        this.producto = new SimpleStringProperty();
        this.estado = new SimpleStringProperty();
        this.fecha = new SimpleStringProperty();
        this.total = new SimpleDoubleProperty();
        this.abono = new SimpleDoubleProperty();
        this.saldo = new SimpleDoubleProperty();
        if (mov.getProductoServicio() != null) {
            this.producto.set(mov.getProductoServicio().getDescripcion());
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd-MM-yyyy hh:mm:ss a");
        this.fecha.set(mov.getFecha().format(formatter));
        this.total.set(mov.getPrecio().doubleValue());
        this.abono.set(mov.getAbono().doubleValue());
        this.saldo.set(mov.getSaldo().doubleValue());
        String tipo = "";
        if (mov.getTipo().equalsIgnoreCase("V")) {
            tipo = "Venta";
        } else if (mov.getTipo().equalsIgnoreCase("A")) {
            tipo = "Abono";
        } else if (mov.getTipo().equalsIgnoreCase("D")) {
            tipo = "Devoluci\u00f3n";
        }
        this.tipo.set(tipo);
        String estado = "Activo";
        if (mov.getDevuelto() != null && mov.getDevuelto().equalsIgnoreCase("S")) {
            estado = "Devuelto";
        }
        this.estado.set(estado);
    }

    public SimpleStringProperty getTipo() {
        return this.tipo;
    }

    public void setTipo(SimpleStringProperty tipo) {
        this.tipo = tipo;
    }

    public SimpleStringProperty getProducto() {
        return this.producto;
    }

    public String getNombreProducto() {
        return this.producto.get();
    }

    public void setProducto(SimpleStringProperty producto) {
        this.producto = producto;
    }

    public SimpleStringProperty getFecha() {
        return this.fecha;
    }

    public void setFecha(SimpleStringProperty fecha) {
        this.fecha = fecha;
    }

    public SimpleDoubleProperty getTotal() {
        return this.total;
    }

    public Double getTotalMovimiento() {
        return this.total.get();
    }

    public void setTotal(SimpleDoubleProperty total) {
        this.total = total;
    }

    public SimpleDoubleProperty getAbono() {
        return this.abono;
    }

    public void setAbono(SimpleDoubleProperty abono) {
        this.abono = abono;
    }

    public SimpleDoubleProperty getSaldo() {
        return this.saldo;
    }

    public void setSaldo(SimpleDoubleProperty saldo) {
        this.saldo = saldo;
    }

    public MovimientoCreditoDto getMovimientoCreditoDto() {
        return this.movimientoCreditoDto;
    }

    public void setMovimientoCreditoDto(MovimientoCreditoDto movimientoCreditoDto) {
        this.movimientoCreditoDto = movimientoCreditoDto;
    }

    public SimpleStringProperty getEstado() {
        return this.estado;
    }

    public void setEstado(SimpleStringProperty estado) {
        this.estado = estado;
    }
}

