/*
 * Decompiled with CFR 0.152.
 */
package electricpos.service;

import electricpos.model.ActividadDto;
import electricpos.util.ESTADO;
import electricpos.util.Request;
import electricpos.util.Respuesta;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.GenericType;

public class ActividadService {
    public Respuesta getByCodigo(String codigo) {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("codigo", codigo);
            Request request = new Request("Actividad/codigo", "/{codigo}", parametros);
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            List lista = (List)request.readEntity(new GenericType<List<ActividadDto>>(){});
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), lista);
        }
        catch (Exception ex) {
            Logger.getLogger(ActividadService.class.getName()).log(Level.SEVERE, "Error obteniendo las actividades", ex);
            return new Respuesta(false, "Error obteniendo la informaci\u00f3n de las actividades.", "getByCodigo " + ex.getMessage());
        }
    }

    public Respuesta getByActividad(String codigo) {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("codigo", codigo);
            Request request = new Request("Actividad/actividad", "/{codigo}", parametros);
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            ActividadDto actividadDto = (ActividadDto)request.readEntity(ActividadDto.class);
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), actividadDto);
        }
        catch (Exception ex) {
            Logger.getLogger(ActividadService.class.getName()).log(Level.SEVERE, "Error obteniendo la actividad", ex);
            return new Respuesta(false, "Error obteniendo la informaci\u00f3n de la actividad.", "getByActividad " + ex.getMessage());
        }
    }

    public Respuesta getByDescripcion(String descripcion) {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("descripcion", descripcion);
            Request request = new Request("Actividad/descripcion", "/{descripcion}", parametros);
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            List lista = (List)request.readEntity(new GenericType<List<ActividadDto>>(){});
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), lista);
        }
        catch (Exception ex) {
            Logger.getLogger(ActividadService.class.getName()).log(Level.SEVERE, "Error obteniendo las actividades", ex);
            return new Respuesta(false, "Error obteniendo la informaci\u00f3n de las actividades.", "getByCodigo " + ex.getMessage());
        }
    }

    public Respuesta getAll() {
        try {
            Request request = new Request("Actividad/todas");
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            List lista = (List)request.readEntity(new GenericType<List<ActividadDto>>(){});
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), lista);
        }
        catch (Exception ex) {
            Logger.getLogger(ActividadService.class.getName()).log(Level.SEVERE, "Error obteniendo las actividades", ex);
            return new Respuesta(false, "Error obteniendo la informaci\u00f3n de las actividades.", "getByCodigo " + ex.getMessage());
        }
    }
}

