/*
 * Decompiled with CFR 0.152.
 */
package electricpos.service;

import electricpos.model.CabysDto;
import electricpos.model.CabysQueryDto;
import electricpos.model.CabysTv;
import electricpos.util.ESTADO;
import electricpos.util.ExternalRequest;
import electricpos.util.Respuesta;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javafx.beans.property.SimpleStringProperty;
import javax.ws.rs.core.GenericType;

public class CabysService {
    private static final Logger LOGGER = Logger.getLogger(CabysService.class.getName());
    private static final String URL_BASE = "https://api.hacienda.go.cr/fe/cabys";

    public Respuesta getCabysByCodigoExternal(String codigo) {
        try {
            ExternalRequest request = this.createRequest(Collections.singletonMap("codigo", codigo));
            request.get();
            if (request.isError()) {
                return this.buildErrorResponse(request);
            }
            List<CabysDto> response = request.readEntity(new GenericType<List<CabysDto>>(){});
            CabysTv cabys = response.stream().findFirst().map(this::mapToCabysTv).orElse(null);
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), cabys);
        }
        catch (Exception ex) {
            return this.handleException("getCabysByCodigoExternal", ex);
        }
    }

    public Respuesta getCabysQuery(String codigo, String descripcion) {
        try {
            List cabysList;
            HashMap<String, Object> params = new HashMap<String, Object>();
            boolean isByCode = false;
            if (codigo != null && !codigo.trim().isEmpty()) {
                isByCode = true;
                params.put("codigo", codigo.trim());
            } else if (descripcion != null && !descripcion.trim().isEmpty()) {
                params.put("q", descripcion.trim());
            }
            ExternalRequest request = this.createRequest(params);
            request.get();
            if (request.isError()) {
                return this.buildErrorResponse(request);
            }
            if (isByCode) {
                List<CabysDto> response = request.readEntity(new GenericType<List<CabysDto>>(){});
                cabysList = response.stream().map(this::mapToCabysTv).collect(Collectors.toList());
            } else {
                CabysQueryDto response = request.readEntity(CabysQueryDto.class);
                cabysList = response.getCabys().stream().map(this::mapToCabysTv).collect(Collectors.toList());
            }
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), cabysList);
        }
        catch (Exception ex) {
            return this.handleException("getCabysQuery", ex);
        }
    }

    private ExternalRequest createRequest(Map<String, Object> queryParams) {
        ExternalRequest request = new ExternalRequest();
        request.setTarget(URL_BASE, "");
        request.addQueryParams(queryParams);
        return request;
    }

    private Respuesta buildErrorResponse(ExternalRequest request) {
        String errorMsg = request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : request.readEntity(String.class);
        return new Respuesta(false, errorMsg, "");
    }

    private Respuesta handleException(String context, Exception ex) {
        LOGGER.log(Level.SEVERE, "Error en " + context, ex);
        return new Respuesta(false, "Error obteniendo los c\u00f3digos Cabys.", context + " " + ex.getMessage());
    }

    private CabysTv mapToCabysTv(CabysDto dto) {
        CabysTv tv = new CabysTv();
        tv.codigo = new SimpleStringProperty(dto.getCodigo());
        tv.descripcion = new SimpleStringProperty(dto.getDescripcion());
        tv.impuesto = new SimpleStringProperty(dto.getImpuesto() != null ? dto.getImpuesto().toString() : "");
        return tv;
    }
}

