/*
 * Decompiled with CFR 0.152.
 */
package electricpos.service;

import electricpos.model.CajaDto;
import electricpos.model.CierreCajaDto;
import electricpos.service.ComprobanteService;
import electricpos.service.MovimientoInventarioService;
import electricpos.util.ESTADO;
import electricpos.util.Request;
import electricpos.util.Respuesta;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.GenericType;
import net.sf.jasperreports.engine.JasperPrint;

public class CajasService {
    public Respuesta getCajasSucursalEmisor(Integer idSucursal, String inicio, String fin) {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("id", idSucursal);
            parametros.put("fechaIni", inicio);
            parametros.put("fechaFin", fin);
            Request request = new Request("caja/sucursalEmisor/", "/{id}/{fechaIni}/{fechaFin}", parametros);
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            List lista = (List)request.readEntity(new GenericType<List<CajaDto>>(){});
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), lista);
        }
        catch (Exception ex) {
            Logger.getLogger(CajasService.class.getName()).log(Level.SEVERE, "Error obteniendo las cajas", ex);
            return new Respuesta(false, "Error obteniendo los movimientos", "getMovimientoInventarioFiltro " + ex.getMessage());
        }
    }

    public Respuesta getUltimaCaja(Integer idSucursal) {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("idSucursal", idSucursal);
            Request request = new Request("caja/last", "/{idSucursal}", parametros);
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            CajaDto cajaDto = (CajaDto)request.readEntity(CajaDto.class);
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), cajaDto);
        }
        catch (Exception ex) {
            Logger.getLogger(CajasService.class.getName()).log(Level.SEVERE, "Error obteniendo la \u00faltima caja.", ex);
            return new Respuesta(false, "Error obteniendo la \u00faltima caja.", "getUltimaCaja " + ex.getMessage());
        }
    }

    public Respuesta getReporteCierre(Integer idCaja) {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("idCaja", idCaja);
            Request request = new Request("caja/reporte", "/{idCaja}", parametros);
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            CierreCajaDto cierreCajaDto = (CierreCajaDto)request.readEntity(CierreCajaDto.class);
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), cierreCajaDto);
        }
        catch (Exception ex) {
            Logger.getLogger(CajasService.class.getName()).log(Level.SEVERE, "Error obteniendo el reporte de la caja.", ex);
            return new Respuesta(false, "Error obteniendo el reporte de la caja.", "getReporteCierre " + ex.getMessage());
        }
    }

    public Respuesta getCierreById(Integer idCierre) {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("id", idCierre);
            Request request = new Request("caja/cierre/id", "/{id}", parametros);
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            CierreCajaDto cierreCajaDto = (CierreCajaDto)request.readEntity(CierreCajaDto.class);
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), cierreCajaDto);
        }
        catch (Exception ex) {
            Logger.getLogger(CajasService.class.getName()).log(Level.SEVERE, "Error obteniendo el reporte de la caja.", ex);
            return new Respuesta(false, "Error obteniendo el reporte de la caja.", "getReporteCierre " + ex.getMessage());
        }
    }

    public Respuesta getReporteCierreMes(Integer idSucursal, String inicio, String fin) {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("idSucursal", idSucursal);
            parametros.put("fechaIni", inicio);
            parametros.put("fechaFin", fin);
            Request request = new Request("caja/reporte/mes", "/{idSucursal}/{fechaIni}/{fechaFin}", parametros);
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            CierreCajaDto cierreCajaDto = (CierreCajaDto)request.readEntity(CierreCajaDto.class);
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), cierreCajaDto);
        }
        catch (Exception ex) {
            Logger.getLogger(CajasService.class.getName()).log(Level.SEVERE, "Error obteniendo el reporte de la caja.", ex);
            return new Respuesta(false, "Error obteniendo el reporte de la caja.", "getReporteCierre " + ex.getMessage());
        }
    }

    public Respuesta getCierresMes(Integer idSucursal) {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("idSucursal", idSucursal);
            Request request = new Request("caja/cierre/mes", "/{idSucursal}", parametros);
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            List lista = (List)request.readEntity(new GenericType<List<CierreCajaDto>>(){});
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), lista);
        }
        catch (Exception ex) {
            Logger.getLogger(CajasService.class.getName()).log(Level.SEVERE, "Error obteniendo los cierres de mes.", ex);
            return new Respuesta(false, "Error obteniendo los cierres de mes.", "getCierresMes " + ex.getMessage());
        }
    }

    public Respuesta save(CajaDto caja, String accion) {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("accion", accion);
            Request request = new Request("caja", "/{accion}", parametros);
            request.post(caja);
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            CajaDto obj = (CajaDto)request.readEntity(CajaDto.class);
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), obj);
        }
        catch (Exception ex) {
            Logger.getLogger(ComprobanteService.class.getName()).log(Level.SEVERE, "Error guardando la caja.", ex);
            return new Respuesta(false, "Error guardando la caja.", "save " + ex.getMessage());
        }
    }

    public Respuesta saveCierre(CierreCajaDto cierre) {
        try {
            Request request = new Request("caja/cierre");
            request.post(cierre);
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            CierreCajaDto obj = (CierreCajaDto)request.readEntity(CierreCajaDto.class);
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), obj);
        }
        catch (Exception ex) {
            Logger.getLogger(ComprobanteService.class.getName()).log(Level.SEVERE, "Error guardando el cierre de caja.", ex);
            return new Respuesta(false, "Error guardando el cierre de caja.", "saveCierre " + ex.getMessage());
        }
    }

    public Respuesta getReporteCierreDia(Integer idCierre, Integer idEmpresa) {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("id", idCierre);
            parametros.put("idEmpresa", idEmpresa);
            Request request = new Request("caja/reporte/cierre/dia", "/{id}/{idEmpresa}", parametros);
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            InputStream responseStream = (InputStream)request.readEntity(InputStream.class);
            JasperPrint reporte = (JasperPrint)new ObjectInputStream(responseStream).readObject();
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), reporte);
        }
        catch (Exception ex) {
            Logger.getLogger(MovimientoInventarioService.class.getName()).log(Level.SEVERE, "Error obteniendo el reporte del cierre de dia", ex);
            return new Respuesta(false, "Error obteniendo el reporte del cierre de dia", "getReporte " + ex.getMessage());
        }
    }

    public Respuesta getReporteCierreMes(Integer idCierre, Integer idEmpresa) {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("id", idCierre);
            parametros.put("idEmpresa", idEmpresa);
            Request request = new Request("caja/reporte/cierre/mes", "/{id}/{idEmpresa}", parametros);
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            InputStream responseStream = (InputStream)request.readEntity(InputStream.class);
            JasperPrint reporte = (JasperPrint)new ObjectInputStream(responseStream).readObject();
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), reporte);
        }
        catch (Exception ex) {
            Logger.getLogger(MovimientoInventarioService.class.getName()).log(Level.SEVERE, "Error obteniendo el reporte del cierre de mes", ex);
            return new Respuesta(false, "Error obteniendo el reporte del cierre de mes", "getReporte " + ex.getMessage());
        }
    }
}

