/*
 * Decompiled with CFR 0.152.
 */
package electricpos.service;

import electricpos.model.CicloFacturacionDto;
import electricpos.service.EmpresaService;
import electricpos.util.ESTADO;
import electricpos.util.Request;
import electricpos.util.Respuesta;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.GenericType;

public class CicloFacturacionService {
    public Respuesta getCicloFacturacionActivo(Integer idEmisor) {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("id", idEmisor);
            Request request = new Request("ciclofacturacion/emisor/activo", "/{id}", parametros);
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            CicloFacturacionDto cicloFacturacionDto = (CicloFacturacionDto)request.readEntity(CicloFacturacionDto.class);
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), cicloFacturacionDto);
        }
        catch (Exception ex) {
            Logger.getLogger(CicloFacturacionService.class.getName()).log(Level.SEVERE, "Error obteniendo el ciclo de facturaci\u00f3n.", ex);
            return new Respuesta(false, "Error obteniendo el ciclo de facturaci\u00f3n.", "getCicloFacturacionActivo " + ex.getMessage());
        }
    }

    public Respuesta getCiclosFacturacion(Integer idEmisor) {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("id", idEmisor);
            Request request = new Request("ciclofacturacion/emisor", "/{id}", parametros);
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            List lista = (List)request.readEntity(new GenericType<List<CicloFacturacionDto>>(){});
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), lista);
        }
        catch (Exception ex) {
            Logger.getLogger(EmpresaService.class.getName()).log(Level.SEVERE, "Error obteniendo los ciclos de facturaci\u00f3n para el emisor el id [" + idEmisor + "]", ex);
            return new Respuesta(false, "Error obteniendo los ciclos de facturaci\u00f3n para el emisor el id [" + idEmisor + "]", "getCiclosFacturacion " + ex.getMessage());
        }
    }
}

