/*
 * Decompiled with CFR 0.152.
 */
package electricpos.service;

import electricpos.model.ColaboradorDto;
import electricpos.model.DetalleVentasColaboradorTv;
import electricpos.service.MovimientoInventarioService;
import electricpos.util.ESTADO;
import electricpos.util.Request;
import electricpos.util.Respuesta;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.GenericType;
import net.sf.jasperreports.engine.JasperPrint;

public class ColaboradoresService {
    public Respuesta getColaboradores(Integer idEmpresa) {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("id", idEmpresa);
            Request request = new Request("colaborador/empresa", "/{id}", parametros);
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            List lista = (List)request.readEntity(new GenericType<List<ColaboradorDto>>(){});
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), lista);
        }
        catch (Exception ex) {
            Logger.getLogger(ColaboradoresService.class.getName()).log(Level.SEVERE, "Error obteniendo los colaboradores.", ex);
            return new Respuesta(false, "Error obteniendo los colaboradores", "getColaboradores " + ex.getMessage());
        }
    }

    public Respuesta getDetalleColaborador(Integer idColaborador, String inicio, String fin) {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("idColaborador", idColaborador);
            parametros.put("fechaIni", inicio);
            parametros.put("fechaFin", fin);
            Request request = new Request("colaborador/detalle", "/{idColaborador}/{fechaIni}/{fechaFin}", parametros);
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            List lista = (List)request.readEntity(new GenericType<List<DetalleVentasColaboradorTv>>(){});
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), lista);
        }
        catch (Exception ex) {
            Logger.getLogger(ColaboradoresService.class.getName()).log(Level.SEVERE, "Error obteniendo el detalle del colaborador.", ex);
            return new Respuesta(false, "Error obteniendo el detalle del colaborador.", "getDetalleColaborador " + ex.getMessage());
        }
    }

    public Respuesta save(ColaboradorDto col) {
        try {
            Request request = new Request("colaborador");
            request.post(col);
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            ColaboradorDto obj = (ColaboradorDto)request.readEntity(ColaboradorDto.class);
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), obj);
        }
        catch (Exception ex) {
            Logger.getLogger(ColaboradoresService.class.getName()).log(Level.SEVERE, "Error guardando el colaborador.", ex);
            return new Respuesta(false, "Error guardando el colaborador.", "saveColaborador " + ex.getMessage());
        }
    }

    public Respuesta deleteColaborador(int id) {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("id", id);
            Request request = new Request("colaborador", "/{id}", parametros);
            request.delete();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            return new Respuesta(true, "", "");
        }
        catch (Exception ex) {
            Logger.getLogger(ColaboradoresService.class.getName()).log(Level.SEVERE, "Error eliminado el colaborador.", ex);
            return new Respuesta(false, "Error eliminado el colaborador.", "deleteColaborador " + ex.getMessage());
        }
    }

    public Respuesta getReporte(Integer idColaborador, Integer idEmpresa, String inicio, String fin) {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("idColaborador", idColaborador);
            parametros.put("idEmpresa", idEmpresa);
            parametros.put("fechaIni", inicio);
            parametros.put("fechaFin", fin);
            Request request = new Request("colaborador/reporte", "/{idColaborador}/{idEmpresa}/{fechaIni}/{fechaFin}", parametros);
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            InputStream responseStream = (InputStream)request.readEntity(InputStream.class);
            JasperPrint reporte = (JasperPrint)new ObjectInputStream(responseStream).readObject();
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), reporte);
        }
        catch (Exception ex) {
            Logger.getLogger(MovimientoInventarioService.class.getName()).log(Level.SEVERE, "Error obteniendo el reporte del colaborador", ex);
            return new Respuesta(false, "Error obteniendo el reporte del colaborador", "getReporte " + ex.getMessage());
        }
    }
}

