/*
 * Decompiled with CFR 0.152.
 */
package electricpos.service;

import electricpos.model.ComprobanteCompraDto;
import electricpos.model.ComprobanteElectronicoDto;
import electricpos.model.ComprobanteResumenDto;
import electricpos.service.StatsService;
import electricpos.util.ESTADO;
import electricpos.util.Request;
import electricpos.util.Respuesta;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.GenericType;

public class ComprobanteCompraService {
    public Respuesta saveComprobante(ComprobanteCompraDto comprobante) {
        try {
            Request request = new Request("ComprobanteCompra/comprobanteElectronico");
            request.post(comprobante);
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), "");
        }
        catch (Exception ex) {
            Logger.getLogger(ComprobanteCompraService.class.getName()).log(Level.SEVERE, "Error guardando el comprobante electronico.", ex);
            return new Respuesta(false, "Error guardando el comprobante electronico.", "saveComprobante " + ex.getMessage());
        }
    }

    public Respuesta getComprobanteClave(String clave) {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("clave", clave);
            Request request = new Request("ComprobanteCompra/comprobanteclave", "/{clave}", parametros);
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            ComprobanteCompraDto com = (ComprobanteCompraDto)request.readEntity(ComprobanteElectronicoDto.class);
            return new Respuesta(true, "", "", "ComprobanteElectronico", com);
        }
        catch (Exception ex) {
            Logger.getLogger(StatsService.class.getName()).log(Level.SEVERE, "Error obteniendo el comprobante con la clave [" + clave + "]", ex);
            return new Respuesta(false, "Error obteniendo el comprobante con la clave [" + clave + "]", "getComprobanteClave " + ex.getMessage());
        }
    }

    public Respuesta getComprobanteFiltro(Integer idSucursal, String inicio, String fin, String tipo) {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("idSucursal", idSucursal);
            parametros.put("fechaIni", inicio);
            parametros.put("fechaFin", fin);
            parametros.put("tipo", tipo);
            Request request = new Request("ComprobanteCompra/comprobantesFiltro", "/{idSucursal}/{fechaIni}/{fechaFin}/{tipo}", parametros);
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            List lista = (List)request.readEntity(new GenericType<List<ComprobanteResumenDto>>(){});
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), lista);
        }
        catch (Exception ex) {
            Logger.getLogger(ComprobanteCompraService.class.getName()).log(Level.SEVERE, "Error obteniendo los comprobantes", ex);
            return new Respuesta(false, "Error obteniendo los comprobantes", "getComprobanteFiltro " + ex.getMessage());
        }
    }
}

