/*
 * Decompiled with CFR 0.152.
 */
package electricpos.service;

import electricpos.model.ComprobanteHaciendaDto;
import electricpos.util.Request;
import electricpos.util.Respuesta;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.GenericType;

public class ComprobanteHaciendaService {
    public Respuesta getComprobanteHaciendaIdSucursal(Integer idSucursal, String tipo, String fecha) {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("id", idSucursal);
            parametros.put("tipo", tipo);
            parametros.put("fecha", fecha);
            Request request = new Request("ComprobanteHacienda/comprobanteHaciendaIdSucursal", "/{id}/{tipo}/{fecha}", parametros);
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            List lista = (List)request.readEntity(new GenericType<List<ComprobanteHaciendaDto>>(){});
            return new Respuesta(true, "", "", "Comprobantes", lista);
        }
        catch (Exception ex) {
            Logger.getLogger(ComprobanteHaciendaService.class.getName()).log(Level.SEVERE, "Error obteniendo los comprobantes", ex);
            return new Respuesta(false, "Error obteniendo la informaci\u00f3n de los comprobantes.", "getComprobanteHaciendaIdSucursal " + ex.getMessage());
        }
    }

    public Respuesta getComprobanteHaciendaFechas(Integer idSucursal, String tipo, String fechaIni, String fechaFin) {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("id", idSucursal);
            parametros.put("tipo", tipo);
            parametros.put("fechaIni", fechaIni);
            parametros.put("fechaFin", fechaFin);
            Request request = new Request("ComprobanteHacienda/comprobanteHaciendaFechas", "/{id}/{tipo}/{fechaIni}/{fechaFin}", parametros);
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            List lista = (List)request.readEntity(new GenericType<List<ComprobanteHaciendaDto>>(){});
            return new Respuesta(true, "", "", "Comprobantes", lista);
        }
        catch (Exception ex) {
            Logger.getLogger(ComprobanteHaciendaService.class.getName()).log(Level.SEVERE, "Error obteniendo los comprobantes", ex);
            return new Respuesta(false, "Error obteniendo la informaci\u00f3n de los comprobantes.", "getComprobanteHaciendaIdSucursal " + ex.getMessage());
        }
    }

    public Respuesta getComprobanteHaciendaRecepcion(Integer idSucursal, String fechaIni, String fechaFin) {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("id", idSucursal);
            parametros.put("fechaIni", fechaIni);
            parametros.put("fechaFin", fechaFin);
            Request request = new Request("ComprobanteHacienda/comprobanteHaciendaRecepcionFechas", "/{id}/{fechaIni}/{fechaFin}", parametros);
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            List lista = (List)request.readEntity(new GenericType<List<ComprobanteHaciendaDto>>(){});
            return new Respuesta(true, "", "", "Comprobantes", lista);
        }
        catch (Exception ex) {
            Logger.getLogger(ComprobanteHaciendaService.class.getName()).log(Level.SEVERE, "Error obteniendo los comprobantes", ex);
            return new Respuesta(false, "Error obteniendo la informaci\u00f3n de los comprobantes.", "getComprobanteHaciendaIdSucursal " + ex.getMessage());
        }
    }

    public Integer getVerificarEstadoComp(Integer idEmisor, Integer idSucursal) {
        Integer response = 0;
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("idEmisor", idEmisor);
            parametros.put("idSucursal", idSucursal);
            Request request = new Request("Comprobante/estadocomprobante", "/{idEmisor}/{idSucursal}", parametros);
            request.get();
            if (request.isError().booleanValue()) {
                response = 0;
            }
            response = (Integer)request.readEntity(Integer.class);
            return response;
        }
        catch (Exception ex) {
            return response;
        }
    }
}

