/*
 * Decompiled with CFR 0.152.
 */
package electricpos.service;

import electricpos.model.ComprobanteRecepcionDto;
import electricpos.model.ComprobanteRecepcionResumenDto;
import electricpos.service.ComprobanteService;
import electricpos.util.ESTADO;
import electricpos.util.Request;
import electricpos.util.Respuesta;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.GenericType;

public class ComprobanteRecepcionService {
    public Respuesta saveComprobanteRecepcion(ComprobanteRecepcionDto comprobante) {
        try {
            Request request = new Request("ComprobanteRecepcion/comprobanteRecepcion");
            request.post(comprobante);
            if (request.isError().booleanValue()) {
                return new Respuesta(Boolean.FALSE, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            ComprobanteRecepcionDto comprobanteDto = (ComprobanteRecepcionDto)request.readEntity(ComprobanteRecepcionDto.class);
            return new Respuesta(Boolean.TRUE, "", "", ESTADO.OK.VALUE(), comprobanteDto);
        }
        catch (Exception ex) {
            Logger.getLogger(ComprobanteService.class.getName()).log(Level.SEVERE, "Error guardando el comprobante.", ex);
            return new Respuesta(Boolean.FALSE, "Error guardando el comprobante.", "ComprobanteRecepcionService " + ex.getMessage());
        }
    }

    public Respuesta getComprobantesRecepcionIdEmisor(Integer idEmisor) {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("idEmisor", idEmisor);
            Request request = new Request("ComprobanteRecepcion/comprobanteRecepcionIdEmisor", "/{idEmisor}", parametros);
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            List lista = (List)request.readEntity(new GenericType<List<ComprobanteRecepcionDto>>(){});
            return new Respuesta(Boolean.TRUE, "", "", ESTADO.OK.VALUE(), lista);
        }
        catch (Exception ex) {
            Logger.getLogger(ComprobanteRecepcionService.class.getName()).log(Level.SEVERE, "Error obteniendo los comprobantes", ex);
            return new Respuesta(Boolean.FALSE, "Error obteniendo la informaci\u00f3n de los comprobantes.", "getComprobanteRecepcionIdEmisor " + ex.getMessage());
        }
    }

    public Respuesta getGastosEmisor(Integer idEmisor, String fechaIni, String fechaFin) {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("idEmisor", idEmisor);
            parametros.put("fechaIni", fechaIni);
            parametros.put("fechaFin", fechaFin);
            Request request = new Request("ComprobanteRecepcion/gastos", "/{idEmisor}/{fechaIni}/{fechaFin}", parametros);
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            List lista = (List)request.readEntity(new GenericType<List<ComprobanteRecepcionResumenDto>>(){});
            return new Respuesta(Boolean.TRUE, "", "", ESTADO.OK.VALUE(), lista);
        }
        catch (Exception ex) {
            Logger.getLogger(ComprobanteRecepcionService.class.getName()).log(Level.SEVERE, "Error obteniendo los comprobantes", ex);
            return new Respuesta(Boolean.FALSE, "Error obteniendo la informaci\u00f3n de los comprobantes.", "getComprobanteRecepcionIdEmisor " + ex.getMessage());
        }
    }
}

