/*
 * Decompiled with CFR 0.152.
 */
package electricpos.service;

import electricpos.model.ComprobanteElectronicoDto;
import electricpos.model.ComprobanteResumenDto;
import electricpos.model.ResumenContableDto;
import electricpos.service.MovimientoInventarioService;
import electricpos.service.StatsService;
import electricpos.util.ESTADO;
import electricpos.util.Request;
import electricpos.util.Respuesta;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.GenericType;
import net.sf.jasperreports.engine.JasperPrint;

public class ComprobanteService {
    public Respuesta saveComprobante(ComprobanteElectronicoDto comprobante) {
        try {
            Request request = new Request("Comprobante/comprobanteElectronico");
            request.post(comprobante);
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            InputStream responseStream = (InputStream)request.readEntity(InputStream.class);
            JasperPrint reporte = (JasperPrint)new ObjectInputStream(responseStream).readObject();
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), reporte);
        }
        catch (Exception ex) {
            Logger.getLogger(ComprobanteService.class.getName()).log(Level.SEVERE, "Error guardando el comprobante electronico.", ex);
            return new Respuesta(false, "Error guardando el comprobante electronico.", "saveComprobante " + ex.getMessage());
        }
    }

    public Respuesta saveRegistroInterno(ComprobanteElectronicoDto comprobante) {
        try {
            Request request = new Request("Comprobante/borrador");
            request.post(comprobante);
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), "");
        }
        catch (Exception ex) {
            Logger.getLogger(ComprobanteService.class.getName()).log(Level.SEVERE, "Error guardando el comprobante electronico.", ex);
            return new Respuesta(false, "Error guardando el comprobante electronico.", "saveComprobante " + ex.getMessage());
        }
    }

    public Respuesta saveSimplificado(ComprobanteElectronicoDto comprobante) {
        try {
            Request request = new Request("Comprobante/simplificado");
            request.post(comprobante);
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            InputStream responseStream = (InputStream)request.readEntity(InputStream.class);
            JasperPrint reporte = (JasperPrint)new ObjectInputStream(responseStream).readObject();
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), reporte);
        }
        catch (Exception ex) {
            Logger.getLogger(ComprobanteService.class.getName()).log(Level.SEVERE, "Error guardando el comprobante electronico.", ex);
            return new Respuesta(false, "Error guardando el comprobante electronico.", "saveComprobante " + ex.getMessage());
        }
    }

    public Respuesta getComprobanteClave(String clave) {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("clave", clave);
            Request request = new Request("Comprobante/comprobanteclave", "/{clave}", parametros);
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            ComprobanteElectronicoDto com = (ComprobanteElectronicoDto)request.readEntity(ComprobanteElectronicoDto.class);
            return new Respuesta(true, "", "", "ComprobanteElectronico", com);
        }
        catch (Exception ex) {
            Logger.getLogger(StatsService.class.getName()).log(Level.SEVERE, "Error obteniendo el comprobante con la clave [" + clave + "]", ex);
            return new Respuesta(false, "Error obteniendo el comprobante con la clave [" + clave + "]", "getComprobanteClave " + ex.getMessage());
        }
    }

    public Respuesta getComprobanteById(int id) {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("id", id);
            Request request = new Request("Comprobante/comprobanteId", "/{id}", parametros);
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            ComprobanteElectronicoDto com = (ComprobanteElectronicoDto)request.readEntity(ComprobanteElectronicoDto.class);
            return new Respuesta(true, "", "", "ComprobanteElectronico", com);
        }
        catch (Exception ex) {
            Logger.getLogger(StatsService.class.getName()).log(Level.SEVERE, "Error obteniendo el comprobante con el id [" + id + "]", ex);
            return new Respuesta(false, "Error obteniendo el comprobante con el [" + id + "]", "getComprobanteClave " + ex.getMessage());
        }
    }

    public Respuesta getInvoiceId(Integer idComp) {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("id", idComp);
            Request request = new Request("Comprobante/invoice", "/{id}", parametros);
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            InputStream responseStream = (InputStream)request.readEntity(InputStream.class);
            JasperPrint reporte = (JasperPrint)new ObjectInputStream(responseStream).readObject();
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), reporte);
        }
        catch (Exception ex) {
            Logger.getLogger(StatsService.class.getName()).log(Level.SEVERE, "Error reimprimiendo el comprobante conel id [" + idComp + "]", ex);
            return new Respuesta(false, "Error reimprimiendo el comprobante con el id [" + idComp + "]", "getInvoiceId " + ex.getMessage());
        }
    }

    public Respuesta getcomprobantePDF(Integer idComp) {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("id", idComp);
            Request request = new Request("Comprobante/invoicepdf", "/{id}", parametros);
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            InputStream responseStream = (InputStream)request.readEntity(InputStream.class);
            JasperPrint reporte = (JasperPrint)new ObjectInputStream(responseStream).readObject();
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), reporte);
        }
        catch (Exception ex) {
            Logger.getLogger(MovimientoInventarioService.class.getName()).log(Level.SEVERE, "Error obteniendo el reporte de movimientos", ex);
            return new Respuesta(false, "Error obteniendo el reporte de movimientos", "getReporteMovimiento " + ex.getMessage());
        }
    }

    public Respuesta getEnviarCorreoComp(Integer idComprobante, String destino) {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("idComprobante", idComprobante);
            parametros.put("destino", destino);
            Request request = new Request("Comprobante/reenviocomprobantecorreo", "/{idComprobante}/{destino}", parametros);
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), request.readEntity(String.class));
        }
        catch (Exception ex) {
            Logger.getLogger(ComprobanteService.class.getName()).log(Level.SEVERE, "Error obteniendo los comprobantes", ex);
            return new Respuesta(false, "Error obteniendo los comprobantes", "getComprobanteFiltro " + ex.getMessage());
        }
    }

    public Respuesta getEnviarCorreoResumenContable(ResumenContableDto resumenContableDto) {
        try {
            Request request = new Request("Reporte/envioresumencontable");
            request.post(resumenContableDto);
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), request.readEntity(String.class));
        }
        catch (Exception ex) {
            Logger.getLogger(ComprobanteService.class.getName()).log(Level.SEVERE, "Error enviando resumen contable.", ex);
            return new Respuesta(false, "Error enviando resumen contable.", "getEnviarCorreoResumenContable " + ex.getMessage());
        }
    }

    public Respuesta getEnviarCorreoResumenGastos(ResumenContableDto resumenContableDto) {
        try {
            Request request = new Request("Reporte/gastos");
            request.post(resumenContableDto);
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), request.readEntity(String.class));
        }
        catch (Exception ex) {
            Logger.getLogger(ComprobanteService.class.getName()).log(Level.SEVERE, "Error enviando resumen contable de gastos.", ex);
            return new Respuesta(false, "Error enviando resumen contable de gastos.", "getEnviarCorreoResumenGastos " + ex.getMessage());
        }
    }

    public Respuesta getComprobanteFiltro(Integer idSucursal, String inicio, String fin, String tipo, String actividad) {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("idSucursal", idSucursal);
            parametros.put("fechaIni", inicio);
            parametros.put("fechaFin", fin);
            parametros.put("tipo", tipo);
            parametros.put("actividad", actividad);
            Request request = new Request("Comprobante/comprobantesFiltro", "/{idSucursal}/{fechaIni}/{fechaFin}/{tipo}/{actividad}", parametros);
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            List lista = (List)request.readEntity(new GenericType<List<ComprobanteResumenDto>>(){});
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), lista);
        }
        catch (Exception ex) {
            Logger.getLogger(ComprobanteService.class.getName()).log(Level.SEVERE, "Error obteniendo los comprobantes", ex);
            return new Respuesta(false, "Error obteniendo los comprobantes", "getComprobanteFiltro " + ex.getMessage());
        }
    }
}

