/*
 * Decompiled with CFR 0.152.
 */
package electricpos.service;

import electricpos.model.Customer;
import electricpos.service.ComprobanteService;
import electricpos.util.ESTADO;
import electricpos.util.ExternalRequest;
import electricpos.util.Respuesta;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CustomerService {
    String urlBase = "https://api.hacienda.go.cr/fe/ae";

    public Respuesta getCustomer(String identificacion) {
        try {
            ExternalRequest externalRequest = new ExternalRequest();
            externalRequest.setTarget(this.urlBase, "");
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("identificacion", identificacion);
            externalRequest.addQueryParams(params);
            externalRequest.get();
            if (externalRequest.isError()) {
                return new Respuesta(false, externalRequest.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : externalRequest.readEntity(String.class), "");
            }
            Customer customer = externalRequest.readEntity(Customer.class);
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), customer);
        }
        catch (Exception ex) {
            Logger.getLogger(ComprobanteService.class.getName()).log(Level.SEVERE, "Error obteniendo los c\u00f3digos Cabys.", ex);
            return new Respuesta(false, "Error obteniendo los c\u00f3digos Cabys.", "getCabysByCodigo " + ex.getMessage());
        }
    }
}

