/*
 * Decompiled with CFR 0.152.
 */
package electricpos.service;

import electricpos.model.EmisorDto;
import electricpos.service.ProductoServicioService;
import electricpos.util.Request;
import electricpos.util.Respuesta;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.GenericType;

public class EmisorService {
    public Respuesta getEmisorIdEmpresa(Integer idEmpresa) {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("idempresa", idEmpresa);
            Request request = new Request("Emisor/emisores", "/{idempresa}", parametros);
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            List lista = (List)request.readEntity(new GenericType<List<EmisorDto>>(){});
            return new Respuesta(true, "", "", "Emisores", lista);
        }
        catch (Exception ex) {
            Logger.getLogger(EmisorService.class.getName()).log(Level.SEVERE, "Error obteniendo los emisores.", ex);
            return new Respuesta(false, "Error obteniendo la informaci\u00f3n de los emisores.", "getEmisorIdEmpresa " + ex.getMessage());
        }
    }

    public Respuesta saveEmisor(EmisorDto emisorDto) {
        try {
            Request request = new Request("Emisor/emisor");
            request.post(emisorDto);
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            EmisorDto emisor = (EmisorDto)request.readEntity(EmisorDto.class);
            return new Respuesta(true, "", "", "Emisor", emisor);
        }
        catch (Exception ex) {
            Logger.getLogger(ProductoServicioService.class.getName()).log(Level.SEVERE, "Error guardando el Emisor.", ex);
            return new Respuesta(false, "Error guardando el emisor.", "saveEmisor " + ex.getMessage());
        }
    }

    public Respuesta saveEmisorActividades(EmisorDto emisorDto) {
        try {
            Request request = new Request("Emisor/actividades");
            request.post(emisorDto);
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            EmisorDto emisor = (EmisorDto)request.readEntity(EmisorDto.class);
            return new Respuesta(true, "", "", "Emisor", emisor);
        }
        catch (Exception ex) {
            Logger.getLogger(ProductoServicioService.class.getName()).log(Level.SEVERE, "Error guardando el Emisor.", ex);
            return new Respuesta(false, "Error guardando el emisor.", "saveEmisor " + ex.getMessage());
        }
    }
}

