/*
 * Decompiled with CFR 0.152.
 */
package electricpos.service;

import electricpos.model.EmpresaDto;
import electricpos.model.EmpresaFacturacion;
import electricpos.service.SucursalEmisorService;
import electricpos.util.ESTADO;
import electricpos.util.Request;
import electricpos.util.Respuesta;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EmpresaService {
    public Respuesta getEmpresa(Integer id) {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("id", id);
            Request request = new Request("Empresa/empresaId", "/{id}", parametros);
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            EmpresaDto empresa = (EmpresaDto)request.readEntity(EmpresaDto.class);
            return new Respuesta(true, "", "", "Empresa", empresa);
        }
        catch (Exception ex) {
            Logger.getLogger(EmpresaService.class.getName()).log(Level.SEVERE, "Error obteniendo la empresa con el id [" + id + "]", ex);
            return new Respuesta(false, "Error obteniendo la informaci\u00f3n de la empresa.", "getEmpresa " + ex.getMessage());
        }
    }

    public Respuesta saveEmpresa(EmpresaDto empresaDto) {
        try {
            Request request = new Request("Empresa/empresa");
            request.post(empresaDto);
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            EmpresaDto sed = (EmpresaDto)request.readEntity(EmpresaDto.class);
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), sed);
        }
        catch (Exception ex) {
            Logger.getLogger(SucursalEmisorService.class.getName()).log(Level.SEVERE, "Error guardando la informaci\u00f3n de la empresa.", ex);
            return new Respuesta(false, "Error guardando la informaci\u00f3n de la empresa.", "saveEmpresa " + ex.getMessage());
        }
    }

    public Respuesta getEmpresaStatus(int id) {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("id", id);
            Request request = new Request("Empresa/billing/{id}/status", "", parametros);
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            EmpresaFacturacion response = (EmpresaFacturacion)request.readEntity(EmpresaFacturacion.class);
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), response);
        }
        catch (Exception ex) {
            Logger.getLogger(SucursalEmisorService.class.getName()).log(Level.SEVERE, "Error guardando la informaci\u00f3n de la empresa.", ex);
            return new Respuesta(false, "Error guardando la informaci\u00f3n de la empresa.", "saveEmpresa " + ex.getMessage());
        }
    }
}

