/*
 * Decompiled with CFR 0.152.
 */
package electricpos.service;

import electricpos.model.ExchangeRate;
import electricpos.util.ESTADO;
import electricpos.util.ExternalRequest;
import electricpos.util.Respuesta;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExchangeRateService {
    private static final String URL_BASE = "https://common.spacesoftwarecr.com/api/v1/exchange-rate";
    private static final Logger LOGGER = Logger.getLogger(ExchangeRateService.class.getName());

    public Respuesta getExchangeRate() {
        try {
            ExternalRequest externalRequest = new ExternalRequest();
            externalRequest.setTarget(URL_BASE, "");
            externalRequest.get();
            if (externalRequest.isError()) {
                String errorMsg = externalRequest.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : externalRequest.readEntity(String.class);
                return new Respuesta(false, errorMsg, "");
            }
            ExchangeRate exchangeRate = externalRequest.readEntity(ExchangeRate.class);
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), exchangeRate);
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Error obteniendo el tipo de cambio.", ex);
            return new Respuesta(false, "Error obteniendo el tipo de cambio.", "getExchangeRate " + ex.getMessage());
        }
    }
}

