/*
 * Decompiled with CFR 0.152.
 */
package electricpos.service;

import electricpos.model.MovimientoCajaDto;
import electricpos.util.ESTADO;
import electricpos.util.Request;
import electricpos.util.Respuesta;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.GenericType;

public class MovimientoCajaService {
    public Respuesta getMovimientosCajaFiltro(Integer idSucursal, String inicio, String fin, String tipo) {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("idSucursal", idSucursal);
            parametros.put("fechaIni", inicio);
            parametros.put("fechaFin", fin);
            parametros.put("tipo", tipo);
            Request request = new Request("movimiento/caja/filtro", "/{idSucursal}/{fechaIni}/{fechaFin}/{tipo}", parametros);
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            List lista = (List)request.readEntity(new GenericType<List<MovimientoCajaDto>>(){});
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), lista);
        }
        catch (Exception ex) {
            Logger.getLogger(MovimientoCajaService.class.getName()).log(Level.SEVERE, "Error obteniendo los movimientos", ex);
            return new Respuesta(false, "Error obteniendo los movimientos", "getMovimientoInventarioFiltro " + ex.getMessage());
        }
    }

    public Respuesta save(MovimientoCajaDto mov) {
        try {
            Request request = new Request("movimiento/caja");
            request.post(mov);
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            MovimientoCajaDto obj = (MovimientoCajaDto)request.readEntity(MovimientoCajaDto.class);
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), obj);
        }
        catch (Exception ex) {
            Logger.getLogger(MovimientoCajaService.class.getName()).log(Level.SEVERE, "Error guardando el movimiento de caja.", ex);
            return new Respuesta(false, "Error guardando el movimiento de caja.", "saveMov " + ex.getMessage());
        }
    }
}

