/*
 * Decompiled with CFR 0.152.
 */
package electricpos.service;

import electricpos.model.MovimientoCreditoDto;
import electricpos.util.ESTADO;
import electricpos.util.Request;
import electricpos.util.Respuesta;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.GenericType;

public class MovimientoCreditoService {
    public Respuesta getMovimientos(Integer idEmisor, Integer idCliente) {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("idEmisor", idEmisor);
            parametros.put("idCliente", idCliente);
            Request request = new Request("credito/movimientos", "/{idEmisor}/{idCliente}", parametros);
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            List lista = (List)request.readEntity(new GenericType<List<MovimientoCreditoDto>>(){});
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), lista);
        }
        catch (Exception ex) {
            Logger.getLogger(MovimientoCreditoService.class.getName()).log(Level.SEVERE, "Error obteniendo los movimientos de credito", ex);
            return new Respuesta(false, "Error obteniendo los movimientos de credito", "getMovimientos " + ex.getMessage());
        }
    }

    public Respuesta save(MovimientoCreditoDto mov) {
        try {
            Request request = new Request("credito/movimiento");
            request.post(mov);
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            MovimientoCreditoDto obj = (MovimientoCreditoDto)request.readEntity(MovimientoCreditoDto.class);
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), obj);
        }
        catch (Exception ex) {
            Logger.getLogger(MovimientoCreditoService.class.getName()).log(Level.SEVERE, "Error guardando el movimiento de credito.", ex);
            return new Respuesta(false, "Error guardando el movimiento de credito.", "saveCredito " + ex.getMessage());
        }
    }
}

