/*
 * Decompiled with CFR 0.152.
 */
package electricpos.service;

import electricpos.model.MovimientoInventarioTv;
import electricpos.service.ComprobanteService;
import electricpos.util.ESTADO;
import electricpos.util.Request;
import electricpos.util.Respuesta;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.GenericType;
import net.sf.jasperreports.engine.JasperPrint;

public class MovimientoInventarioService {
    public Respuesta getMovimientoInventarioFiltro(Integer idSucursal, String inicio, String fin, String tipo) {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("idSucursal", idSucursal);
            parametros.put("fechaIni", inicio);
            parametros.put("fechaFin", fin);
            parametros.put("tipo", tipo);
            Request request = new Request("inventario/mov/filtro", "/{idSucursal}/{fechaIni}/{fechaFin}/{tipo}", parametros);
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            List lista = (List)request.readEntity(new GenericType<List<MovimientoInventarioTv>>(){});
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), lista);
        }
        catch (Exception ex) {
            Logger.getLogger(MovimientoInventarioService.class.getName()).log(Level.SEVERE, "Error obteniendo los movimientos", ex);
            return new Respuesta(false, "Error obteniendo los movimientos", "getMovimientoInventarioFiltro " + ex.getMessage());
        }
    }

    public Respuesta save(MovimientoInventarioTv mov) {
        try {
            Request request = new Request("inventario/mov");
            request.post(mov);
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            MovimientoInventarioTv obj = (MovimientoInventarioTv)request.readEntity(MovimientoInventarioTv.class);
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), obj);
        }
        catch (Exception ex) {
            Logger.getLogger(ComprobanteService.class.getName()).log(Level.SEVERE, "Error guardando el movimiento de inventario.", ex);
            return new Respuesta(false, "Error guardando el movimiento de inventario.", "saveMov " + ex.getMessage());
        }
    }

    public Respuesta getReporteMovimiento(Integer idSucursal, String idProducto, String inicio, String fin, String tipo) {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("idSucursal", idSucursal);
            parametros.put("idProducto", idProducto);
            parametros.put("fechaIni", inicio);
            parametros.put("fechaFin", fin);
            parametros.put("tipo", tipo);
            Request request = new Request("inventario/mov/reporte", "/{idSucursal}/{idProducto}/{fechaIni}/{fechaFin}/{tipo}", parametros);
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            InputStream responseStream = (InputStream)request.readEntity(InputStream.class);
            JasperPrint reporte = (JasperPrint)new ObjectInputStream(responseStream).readObject();
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), reporte);
        }
        catch (Exception ex) {
            Logger.getLogger(MovimientoInventarioService.class.getName()).log(Level.SEVERE, "Error obteniendo el reporte de movimientos", ex);
            return new Respuesta(false, "Error obteniendo el reporte de movimientos", "getReporteMovimiento " + ex.getMessage());
        }
    }

    public Respuesta getReporteInv(Integer idSucursal, String idProducto, String tomafisica) {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("idSucursal", idSucursal);
            parametros.put("idProducto", idProducto);
            parametros.put("tomafisica", tomafisica);
            Request request = new Request("inventario/reporte", "/{idSucursal}/{idProducto}/{tomafisica}", parametros);
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            InputStream responseStream = (InputStream)request.readEntity(InputStream.class);
            JasperPrint reporte = (JasperPrint)new ObjectInputStream(responseStream).readObject();
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), reporte);
        }
        catch (Exception ex) {
            Logger.getLogger(MovimientoInventarioService.class.getName()).log(Level.SEVERE, "Error obteniendo el reporte de movimientos", ex);
            return new Respuesta(false, "Error obteniendo el reporte de movimientos", "getReporteMovimiento " + ex.getMessage());
        }
    }
}

