/*
 * Decompiled with CFR 0.152.
 */
package electricpos.service;

import electricpos.model.ParametrosGeneralesDto;
import electricpos.util.ESTADO;
import electricpos.util.Request;
import electricpos.util.Respuesta;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.jasperreports.engine.JasperPrint;

public class ParametroService {
    public Respuesta getParametrosApp(String codigoApp, String estadoApp) {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("codigoApp", codigoApp);
            parametros.put("estadoApp", estadoApp);
            Request request = new Request("Parametro/parametros", "/{codigoApp}/{estadoApp}", parametros);
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            ParametrosGeneralesDto parametro = (ParametrosGeneralesDto)request.readEntity(ParametrosGeneralesDto.class);
            return new Respuesta(true, "", "", "ParametrosGenerales", parametro);
        }
        catch (Exception ex) {
            Logger.getLogger(ParametroService.class.getName()).log(Level.SEVERE, "Error obteniendo los parametros para el codigo [" + codigoApp + "]", ex);
            return new Respuesta(false, "Error obteniendo los parametros generales del sistemaa.", "getParametrosApp " + ex.getMessage());
        }
    }

    public String sendCorreoPrueba(String correo, String pass) {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("correo", correo);
            parametros.put("pass", pass);
            Request request = new Request("Parametro/correoprueba", "/{correo}/{pass}", parametros);
            request.get();
            if (request.isError().booleanValue()) {
                return "No se pudo establecer conexi\u00f3n con el servidor.";
            }
            return request.readEntity(String.class).toString();
        }
        catch (Exception ex) {
            return "Error intentando enviar el correo de prueba.";
        }
    }

    public Respuesta reporteInvoice() {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("id", 1);
            Request request = new Request("Security/print", "/{id}", parametros);
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            InputStream responseStream = (InputStream)request.readEntity(InputStream.class);
            JasperPrint reporte = (JasperPrint)new ObjectInputStream(responseStream).readObject();
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), reporte);
        }
        catch (Exception ex) {
            return new Respuesta(false, "Error generando el reporte.", "reporteOferente " + ex.getMessage());
        }
    }
}

