/*
 * Decompiled with CFR 0.152.
 */
package electricpos.service;

import electricpos.model.ProductoServicioDto;
import electricpos.model.ProductoServicioLte;
import electricpos.service.EmisorService;
import electricpos.util.ESTADO;
import electricpos.util.Request;
import electricpos.util.Respuesta;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.GenericType;

public class ProductoServicioService {
    public Respuesta saveProductoServicio(ProductoServicioDto psDto) {
        try {
            Request request = new Request("ProductoServicio/productoservicio");
            request.post(psDto);
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            ProductoServicioDto ps = (ProductoServicioDto)request.readEntity(ProductoServicioDto.class);
            return new Respuesta(true, "", "", "ProductoServicio", ps);
        }
        catch (Exception ex) {
            Logger.getLogger(ProductoServicioService.class.getName()).log(Level.SEVERE, "Error guardando el Producto/Servicio.", ex);
            return new Respuesta(false, "Error guardando el Producto/Servicio.", "saveComprobante " + ex.getMessage());
        }
    }

    public Respuesta deleteProductoServicio(int id) {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("id", id);
            Request request = new Request("ProductoServicio", "/{id}", parametros);
            request.delete();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            ProductoServicioDto ps = (ProductoServicioDto)request.readEntity(ProductoServicioDto.class);
            return new Respuesta(true, "", "", "ProductoServicio", ps);
        }
        catch (Exception ex) {
            Logger.getLogger(ProductoServicioService.class.getName()).log(Level.SEVERE, "Error guardando el Producto/Servicio.", ex);
            return new Respuesta(false, "Error guardando el Producto/Servicio.", "saveComprobante " + ex.getMessage());
        }
    }

    public Respuesta getProductoServicioEmi(Integer idEmisor) {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("idemisor", idEmisor);
            Request request = new Request("ProductoServicio/productoservicioemi", "/{idemisor}", parametros);
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            List lista = (List)request.readEntity(new GenericType<List<ProductoServicioDto>>(){});
            return new Respuesta(true, "", "", "ProductoServicio", lista);
        }
        catch (Exception ex) {
            Logger.getLogger(EmisorService.class.getName()).log(Level.SEVERE, "Error obteniendo los Productos/Servicios.", ex);
            return new Respuesta(false, "Error obteniendo la informaci\u00f3n de los Productos/Servicios.", "getProductoServicioEmi " + ex.getMessage());
        }
    }

    public Respuesta getProductoServicioNombre(Integer idEmisor, String nombre, String tipo, boolean lte) {
        try {
            if (nombre == null || nombre.isEmpty()) {
                nombre = ESTADO.EMPTY_PARAM.VALUE();
            }
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("idemisor", idEmisor);
            parametros.put("nombre", nombre);
            Request request = null;
            if (lte) {
                parametros.put("tipo", tipo);
                request = new Request("ProductoServicio/psnombrelte", "/{idemisor}/{nombre}/{tipo}", parametros);
            } else {
                request = new Request("ProductoServicio/productoservicionombre", "/{idemisor}/{nombre}", parametros);
            }
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            if (lte) {
                List listaLte = (List)request.readEntity(new GenericType<List<ProductoServicioLte>>(){});
                return new Respuesta(true, "", "", ESTADO.OK.VALUE(), listaLte);
            }
            List lista = (List)request.readEntity(new GenericType<List<ProductoServicioDto>>(){});
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), lista);
        }
        catch (Exception ex) {
            Logger.getLogger(EmisorService.class.getName()).log(Level.SEVERE, "Error obteniendo los Productos/Servicios.", ex);
            return new Respuesta(false, "Error obteniendo la informaci\u00f3n de los Productos/Servicios.", "getProductoServicioEmi " + ex.getMessage());
        }
    }

    public Respuesta getProductoServicioSucursal(Integer idEmisor, String nombre, Integer idSucursal, String tipo, boolean lte) {
        try {
            if (nombre == null || nombre.isEmpty()) {
                nombre = ESTADO.EMPTY_PARAM.VALUE();
            }
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("idemisor", idEmisor);
            parametros.put("idsucursal", idSucursal);
            parametros.put("nombre", nombre);
            Request request = null;
            if (lte) {
                parametros.put("tipo", tipo);
                request = new Request("ProductoServicio/pssucursallte", "/{idemisor}/{idsucursal}/{nombre}/{tipo}", parametros);
            } else {
                request = new Request("ProductoServicio/productoserviciosucursal", "/{idemisor}/{idsucursal}/{nombre}", parametros);
            }
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            List lista = null;
            List listaLte = null;
            if (lte) {
                listaLte = (List)request.readEntity(new GenericType<List<ProductoServicioLte>>(){});
            } else {
                lista = (List)request.readEntity(new GenericType<List<ProductoServicioDto>>(){});
            }
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), lte ? listaLte : lista);
        }
        catch (Exception ex) {
            Logger.getLogger(EmisorService.class.getName()).log(Level.SEVERE, "Error obteniendo los Productos/Servicios.", ex);
            return new Respuesta(false, "Error obteniendo la informaci\u00f3n de los Productos/Servicios.", "getProductoServicioEmi " + ex.getMessage());
        }
    }

    public Respuesta getProductoServicioCodigo(Integer idEmisor, String codigo) {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("codigo", codigo);
            parametros.put("idEmisor", idEmisor);
            Request request = new Request("ProductoServicio/productoserviciocodigo", "/{idEmisor}/{codigo}", parametros);
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            ProductoServicioDto productoServicio = (ProductoServicioDto)request.readEntity(ProductoServicioDto.class);
            return new Respuesta(true, "", "", "ProductoServicio", productoServicio);
        }
        catch (Exception ex) {
            Logger.getLogger(EmisorService.class.getName()).log(Level.SEVERE, "Error obteniendo el Producto/Servicio.", ex);
            return new Respuesta(false, "Error obteniendo la informaci\u00f3n de el Producto/Servicio.", "getProductoServicioCodigo " + ex.getMessage());
        }
    }

    public Respuesta getProductoServicioId(Integer id) {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("id", id);
            Request request = new Request("ProductoServicio/id", "/{id}", parametros);
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            ProductoServicioDto productoServicio = (ProductoServicioDto)request.readEntity(ProductoServicioDto.class);
            return new Respuesta(true, "", "", "ProductoServicio", productoServicio);
        }
        catch (Exception ex) {
            Logger.getLogger(EmisorService.class.getName()).log(Level.SEVERE, "Error obteniendo el Producto/Servicio.", ex);
            return new Respuesta(false, "Error obteniendo la informaci\u00f3n de el Producto/Servicio.", "getProductoServicioCodigo " + ex.getMessage());
        }
    }

    public Respuesta getProductoServicioCodigoSucursal(Integer idEmisor, Integer idSucursal, String codigo) {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("codigo", codigo);
            parametros.put("idEmisor", idEmisor);
            parametros.put("idSucursal", idSucursal);
            Request request = new Request("ProductoServicio/productoserviciocodigosucursal", "/{idEmisor}/{idSucursal}/{codigo}", parametros);
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            ProductoServicioDto productoServicio = (ProductoServicioDto)request.readEntity(ProductoServicioDto.class);
            return new Respuesta(true, "", "", "ProductoServicio", productoServicio);
        }
        catch (Exception ex) {
            Logger.getLogger(EmisorService.class.getName()).log(Level.SEVERE, "Error obteniendo el Producto/Servicio.", ex);
            return new Respuesta(false, "Error obteniendo la informaci\u00f3n de el Producto/Servicio.", "getProductoServicioCodigo " + ex.getMessage());
        }
    }
}

