/*
 * Decompiled with CFR 0.152.
 */
package electricpos.service;

import electricpos.model.ComprobanteProformaDto;
import electricpos.model.ComprobanteResumenDto;
import electricpos.service.StatsService;
import electricpos.util.ESTADO;
import electricpos.util.Request;
import electricpos.util.Respuesta;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.GenericType;
import net.sf.jasperreports.engine.JasperPrint;

public class ProformaService {
    public Respuesta saveComprobante(ComprobanteProformaDto comprobante) {
        try {
            Request request = new Request("Proforma/proforma");
            request.post(comprobante);
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            InputStream responseStream = (InputStream)request.readEntity(InputStream.class);
            JasperPrint reporte = (JasperPrint)new ObjectInputStream(responseStream).readObject();
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), reporte);
        }
        catch (Exception ex) {
            Logger.getLogger(ProformaService.class.getName()).log(Level.SEVERE, "Error guardando el comprobante electronico.", ex);
            return new Respuesta(false, "Error guardando el comprobante electronico.", "saveComprobante " + ex.getMessage());
        }
    }

    public Respuesta getProformaId(Integer id) {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("id", id);
            Request request = new Request("Proforma/id", "/{id}", parametros);
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            ComprobanteProformaDto com = (ComprobanteProformaDto)request.readEntity(ComprobanteProformaDto.class);
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), com);
        }
        catch (Exception ex) {
            Logger.getLogger(StatsService.class.getName()).log(Level.SEVERE, "Error obteniendo el comprobante con la clave [" + id.toString() + "]", ex);
            return new Respuesta(false, "Error obteniendo el comprobante con la clave [" + id.toString() + "]", "getComprobanteClave " + ex.getMessage());
        }
    }

    public Respuesta removeProformaId(Integer id) {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("id", id);
            Request request = new Request("Proforma/remove", "/{id}", parametros);
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), null);
        }
        catch (Exception ex) {
            Logger.getLogger(StatsService.class.getName()).log(Level.SEVERE, "Error eliminando el comprobante con la clave [" + id.toString() + "]", ex);
            return new Respuesta(false, "Error eliminando el comprobante con la clave [" + id.toString() + "]", "getComprobanteClave " + ex.getMessage());
        }
    }

    public Respuesta getEnviarCorreoComp(Integer id, String destino) {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("idProforma", id);
            parametros.put("destino", destino);
            Request request = new Request("Proforma/reenvioproformacorreo", "/{idProforma}/{destino}", parametros);
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), request.readEntity(String.class));
        }
        catch (Exception ex) {
            Logger.getLogger(ProformaService.class.getName()).log(Level.SEVERE, "Error obteniendo los comprobantes", ex);
            return new Respuesta(false, "Error obteniendo los comprobantes", "getComprobanteFiltro " + ex.getMessage());
        }
    }

    public Respuesta getComprobanteFiltro(Integer idSucursal, String inicio, String fin, String cliente) {
        try {
            if (cliente == null || cliente.isEmpty()) {
                cliente = ESTADO.EMPTY_PARAM.VALUE();
            }
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("idSucursal", idSucursal);
            parametros.put("fechaIni", inicio);
            parametros.put("fechaFin", fin);
            parametros.put("cliente", cliente);
            Request request = new Request("Proforma/proformasFiltro", "/{idSucursal}/{fechaIni}/{fechaFin}/{cliente}", parametros);
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            List lista = (List)request.readEntity(new GenericType<List<ComprobanteResumenDto>>(){});
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), lista);
        }
        catch (Exception ex) {
            Logger.getLogger(ProformaService.class.getName()).log(Level.SEVERE, "Error obteniendo los comprobantes", ex);
            return new Respuesta(false, "Error obteniendo los comprobantes", "getComprobanteFiltro " + ex.getMessage());
        }
    }
}

