/*
 * Decompiled with CFR 0.152.
 */
package electricpos.service;

import electricpos.model.ReceptorDto;
import electricpos.service.ComprobanteService;
import electricpos.service.EmisorService;
import electricpos.util.ESTADO;
import electricpos.util.Request;
import electricpos.util.Respuesta;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.GenericType;

public class ReceptorService {
    public Respuesta getReceptorIdenificacion(Integer idEmisor, String numero) {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("idEmisor", idEmisor);
            parametros.put("numero", numero);
            Request request = new Request("Receptor/receptorIdentificacion", "/{idEmisor}/{numero}", parametros);
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            ReceptorDto receptor = (ReceptorDto)request.readEntity(ReceptorDto.class);
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), receptor);
        }
        catch (Exception ex) {
            Logger.getLogger(ReceptorService.class.getName()).log(Level.SEVERE, "Error obteniendo el receptor con la cedula [" + numero + "]", ex);
            return new Respuesta(false, "Error obteniendo la informaci\u00f3n del receptor.", "getReceptorIdenificacion " + ex.getMessage());
        }
    }

    public Respuesta saveReceptor(ReceptorDto receptor) {
        try {
            Request request = new Request("Receptor/receptor");
            request.post(receptor);
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            ReceptorDto receptorDto = (ReceptorDto)request.readEntity(ReceptorDto.class);
            return new Respuesta(true, "", "", "Receptor", receptorDto);
        }
        catch (Exception ex) {
            Logger.getLogger(ComprobanteService.class.getName()).log(Level.SEVERE, "Error guardando el receptor.", ex);
            return new Respuesta(false, "Error guardando el receptor.", "saveComprobante " + ex.getMessage());
        }
    }

    public Respuesta getReceptorId(Integer id) {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("id", id);
            Request request = new Request("Receptor/id", "/{id}", parametros);
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            ReceptorDto receptorDto = (ReceptorDto)request.readEntity(ReceptorDto.class);
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), receptorDto);
        }
        catch (Exception ex) {
            Logger.getLogger(ComprobanteService.class.getName()).log(Level.SEVERE, "Error obteniendo el receptor.", ex);
            return new Respuesta(false, "Error obteniendo el receptor.", "getReceptorId " + ex.getMessage());
        }
    }

    public Respuesta getReceptorIdEmisor(Integer idEmisor) {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("idEmisor", idEmisor);
            Request request = new Request("Receptor/receptores", "/{idEmisor}", parametros);
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            List lista = (List)request.readEntity(new GenericType<List<ReceptorDto>>(){});
            return new Respuesta(true, "", "", "Receptor", lista);
        }
        catch (Exception ex) {
            Logger.getLogger(EmisorService.class.getName()).log(Level.SEVERE, "Error obteniendo los receptores.", ex);
            return new Respuesta(false, "Error obteniendo la informaci\u00f3n de los receptores.", "getReceptorIdEmisor " + ex.getMessage());
        }
    }

    public Respuesta getReceptorEmisorYNombre(Integer idEmisor, String nombre) {
        try {
            if (nombre == null || nombre.isEmpty()) {
                nombre = ESTADO.EMPTY_PARAM.VALUE();
            }
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("idEmisor", idEmisor);
            parametros.put("nombre", nombre);
            Request request = new Request("Receptor/receptoresNombreYEmisor", "/{idEmisor}/{nombre}", parametros);
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            List lista = (List)request.readEntity(new GenericType<List<ReceptorDto>>(){});
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), lista);
        }
        catch (Exception ex) {
            Logger.getLogger(EmisorService.class.getName()).log(Level.SEVERE, "Error obteniendo los receptores.", ex);
            return new Respuesta(false, "Error obteniendo la informaci\u00f3n de los receptores.", "getReceptorIdEmisor " + ex.getMessage());
        }
    }
}

