/*
 * Decompiled with CFR 0.152.
 */
package electricpos.service;

import electricpos.model.SucursalEmisorDto;
import electricpos.service.EmisorService;
import electricpos.util.Request;
import electricpos.util.Respuesta;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.GenericType;

public class SucursalEmisorService {
    public Respuesta saveSucursalEmisor(SucursalEmisorDto sucursalEmisorDto) {
        try {
            Request request = new Request("Sucursal/sucursal");
            request.post(sucursalEmisorDto);
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            SucursalEmisorDto sed = (SucursalEmisorDto)request.readEntity(SucursalEmisorDto.class);
            return new Respuesta(true, "", "", "SucursalEmisor", sed);
        }
        catch (Exception ex) {
            Logger.getLogger(SucursalEmisorService.class.getName()).log(Level.SEVERE, "Error guardando la sucursal.", ex);
            return new Respuesta(false, "Error guardando la sucursal.", "saveSucursalEmisor " + ex.getMessage());
        }
    }

    public Respuesta getSucursalesEmi(Integer idEmisor) {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("idemisor", idEmisor);
            Request request = new Request("Sucursal/sucursales", "/{idemisor}", parametros);
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            List lista = (List)request.readEntity(new GenericType<List<SucursalEmisorDto>>(){});
            return new Respuesta(true, "", "", "SucursalEmisor", lista);
        }
        catch (Exception ex) {
            Logger.getLogger(EmisorService.class.getName()).log(Level.SEVERE, "Error obteniendo las sucursales.", ex);
            return new Respuesta(false, "Error obteniendo la informaci\u00f3n de las sucursales.", "getSucursalesEmi " + ex.getMessage());
        }
    }
}

