/*
 * Decompiled with CFR 0.152.
 */
package electricpos.service;

import electricpos.model.UsuarioDto;
import electricpos.model.UsuarioMenuDto;
import electricpos.service.EmisorService;
import electricpos.service.EmpresaService;
import electricpos.service.SucursalEmisorService;
import electricpos.util.ESTADO;
import electricpos.util.Request;
import electricpos.util.Respuesta;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.GenericType;

public class UsuarioService {
    public Respuesta getUsuario(Integer id) {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("id", id);
            Request request = new Request("Usuario/usuarioId", "/{id}", parametros);
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            UsuarioDto usuario = (UsuarioDto)request.readEntity(UsuarioDto.class);
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), usuario);
        }
        catch (Exception ex) {
            Logger.getLogger(EmpresaService.class.getName()).log(Level.SEVERE, "Error obteniendo el usuario con el id [" + id + "]", ex);
            return new Respuesta(false, "Error obteniendo la informaci\u00f3n del usuario.", "getUsuario " + ex.getMessage());
        }
    }

    public Respuesta saveUsuario(UsuarioDto usuarioDto) {
        try {
            Request request = new Request("Usuario/usuario");
            request.post(usuarioDto);
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            UsuarioDto sed = (UsuarioDto)request.readEntity(UsuarioDto.class);
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), sed);
        }
        catch (Exception ex) {
            Logger.getLogger(SucursalEmisorService.class.getName()).log(Level.SEVERE, "Error guardando la informaci\u00f3n del usuario.", ex);
            return new Respuesta(false, "Error guardando la informaci\u00f3n del usuario.", "saveUsuario " + ex.getMessage());
        }
    }

    public Respuesta getUsauriosEmpresa(Integer idEmpresa) {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("idEmpresa", idEmpresa);
            Request request = new Request("Usuario/empresa", "/{idEmpresa}", parametros);
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            List lista = (List)request.readEntity(new GenericType<List<UsuarioDto>>(){});
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), lista);
        }
        catch (Exception ex) {
            Logger.getLogger(EmisorService.class.getName()).log(Level.SEVERE, "Error obteniendo los usuarios.", ex);
            return new Respuesta(false, "Error obteniendo la informaci\u00f3n de los usuarios.", "getUsauriosEmpresa " + ex.getMessage());
        }
    }

    public Respuesta getMenusUsuario(Integer id) {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("id", id);
            Request request = new Request("menu/usuario", "/{id}", parametros);
            request.get();
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            List lista = (List)request.readEntity(new GenericType<List<UsuarioMenuDto>>(){});
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), lista);
        }
        catch (Exception ex) {
            Logger.getLogger(EmisorService.class.getName()).log(Level.SEVERE, "Error obteniendo los usuarios.", ex);
            return new Respuesta(false, "Error obteniendo la informaci\u00f3n de los usuarios.", "getUsauriosEmpresa " + ex.getMessage());
        }
    }

    public Respuesta saveMenuUsuario(int idUsuario, List<UsuarioMenuDto> menus) {
        try {
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("id", idUsuario);
            Request request = new Request("menu/usuarios", "/{id}", parametros);
            request.post(menus);
            if (request.isError().booleanValue()) {
                return new Respuesta(false, request.getStatus() == 404 ? "No se pudo establecer conexi\u00f3n con el servidor." : (String)request.readEntity(String.class), "");
            }
            return new Respuesta(true, "", "", ESTADO.OK.VALUE(), null);
        }
        catch (Exception ex) {
            Logger.getLogger(SucursalEmisorService.class.getName()).log(Level.SEVERE, "Error guardandoel men\u00fa del usuario.", ex);
            return new Respuesta(false, "Error guardandoel men\u00fa del usuario.", "saveUsuario " + ex.getMessage());
        }
    }
}

