/*
 * Decompiled with CFR 0.152.
 */
package electricpos.util;

import electricpos.util.CodigoType;
import electricpos.util.EmisorType;
import electricpos.util.ImpuestoType;
import electricpos.util.ReceptorType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class ComprobanteElectronico {
    protected String clave;
    protected String numeroConsecutivo;
    protected String fechaEmision;
    protected String codigoActividad;
    protected EmisorType emisor = new EmisorType();
    protected ReceptorType receptor = new ReceptorType();
    protected String condicionVenta;
    protected String plazoCredito;
    protected List<String> medioPago = new ArrayList<String>();
    protected DetalleServicio detalleServicio;
    protected ResumenFactura resumenFactura = new ResumenFactura();
    protected List<InformacionReferencia> informacionReferencia;

    public ComprobanteElectronico() {
        this.detalleServicio = new DetalleServicio();
        this.detalleServicio.lineaDetalle = new ArrayList<DetalleServicio.LineaDetalle>();
    }

    public String getClave() {
        return this.clave;
    }

    public void setClave(String clave) {
        this.clave = clave;
    }

    public String getCodigoActividad() {
        return this.codigoActividad;
    }

    public void setCodigoActividad(String codigoActividad) {
        this.codigoActividad = codigoActividad;
    }

    public String getNumeroConsecutivo() {
        return this.numeroConsecutivo;
    }

    public void setNumeroConsecutivo(String numeroConsecutivo) {
        this.numeroConsecutivo = numeroConsecutivo;
    }

    public String getFechaEmision() {
        return this.fechaEmision;
    }

    public void setFechaEmision(String fechaEmision) {
        this.fechaEmision = fechaEmision;
    }

    public EmisorType getEmisor() {
        return this.emisor;
    }

    public void setEmisor(EmisorType emisor) {
        this.emisor = emisor;
    }

    public ReceptorType getReceptor() {
        return this.receptor;
    }

    public void setReceptor(ReceptorType receptor) {
        this.receptor = receptor;
    }

    public String getCondicionVenta() {
        return this.condicionVenta;
    }

    public void setCondicionVenta(String condicionVenta) {
        this.condicionVenta = condicionVenta;
    }

    public String getPlazoCredito() {
        return this.plazoCredito;
    }

    public void setPlazoCredito(String plazoCredito) {
        this.plazoCredito = plazoCredito;
    }

    public List<String> getMedioPago() {
        return this.medioPago;
    }

    public void setMedioPago(List<String> medioPago) {
        this.medioPago = medioPago;
    }

    public DetalleServicio getDetalleServicio() {
        return this.detalleServicio;
    }

    public void setDetalleServicio(DetalleServicio detalleServicio) {
        this.detalleServicio = detalleServicio;
    }

    public ResumenFactura getResumenFactura() {
        return this.resumenFactura;
    }

    public void setResumenFactura(ResumenFactura resumenFactura) {
        this.resumenFactura = resumenFactura;
    }

    public List<InformacionReferencia> getInformacionReferencia() {
        return this.informacionReferencia;
    }

    public void setInformacionReferencia(List<InformacionReferencia> informacionReferencia) {
        this.informacionReferencia = informacionReferencia;
    }

    public static class ResumenFactura {
        protected String codigoMoneda;
        protected BigDecimal tipoCambio;
        protected BigDecimal totalServGravados;
        protected BigDecimal totalServExentos;
        protected BigDecimal totalMercanciasGravadas;
        protected BigDecimal totalMercanciasExentas;
        protected BigDecimal totalGravado;
        protected BigDecimal totalExento;
        protected BigDecimal totalVenta;
        protected BigDecimal totalDescuentos;
        protected BigDecimal totalVentaNeta;
        protected BigDecimal totalImpuesto;
        protected BigDecimal totalComprobante;

        public String getCodigoMoneda() {
            return this.codigoMoneda;
        }

        public void setCodigoMoneda(String value) {
            this.codigoMoneda = value;
        }

        public BigDecimal getTipoCambio() {
            return this.tipoCambio;
        }

        public void setTipoCambio(BigDecimal value) {
            this.tipoCambio = value;
        }

        public BigDecimal getTotalServGravados() {
            return this.totalServGravados;
        }

        public void setTotalServGravados(BigDecimal value) {
            this.totalServGravados = value;
        }

        public BigDecimal getTotalServExentos() {
            return this.totalServExentos;
        }

        public void setTotalServExentos(BigDecimal value) {
            this.totalServExentos = value;
        }

        public BigDecimal getTotalMercanciasGravadas() {
            return this.totalMercanciasGravadas;
        }

        public void setTotalMercanciasGravadas(BigDecimal value) {
            this.totalMercanciasGravadas = value;
        }

        public BigDecimal getTotalMercanciasExentas() {
            return this.totalMercanciasExentas;
        }

        public void setTotalMercanciasExentas(BigDecimal value) {
            this.totalMercanciasExentas = value;
        }

        public BigDecimal getTotalGravado() {
            return this.totalGravado;
        }

        public void setTotalGravado(BigDecimal value) {
            this.totalGravado = value;
        }

        public BigDecimal getTotalExento() {
            return this.totalExento;
        }

        public void setTotalExento(BigDecimal value) {
            this.totalExento = value;
        }

        public BigDecimal getTotalVenta() {
            return this.totalVenta;
        }

        public void setTotalVenta(BigDecimal value) {
            this.totalVenta = value;
        }

        public BigDecimal getTotalDescuentos() {
            return this.totalDescuentos;
        }

        public void setTotalDescuentos(BigDecimal value) {
            this.totalDescuentos = value;
        }

        public BigDecimal getTotalVentaNeta() {
            return this.totalVentaNeta;
        }

        public void setTotalVentaNeta(BigDecimal value) {
            this.totalVentaNeta = value;
        }

        public BigDecimal getTotalImpuesto() {
            return this.totalImpuesto;
        }

        public void setTotalImpuesto(BigDecimal value) {
            this.totalImpuesto = value;
        }

        public BigDecimal getTotalComprobante() {
            return this.totalComprobante;
        }

        public void setTotalComprobante(BigDecimal value) {
            this.totalComprobante = value;
        }
    }

    public static class InformacionReferencia {
        protected String tipoDoc;
        protected String numero;
        protected String fechaEmision;
        protected String codigo;
        protected String razon;

        public String getTipoDoc() {
            return this.tipoDoc;
        }

        public void setTipoDoc(String value) {
            this.tipoDoc = value;
        }

        public String getNumero() {
            return this.numero;
        }

        public void setNumero(String value) {
            this.numero = value;
        }

        public String getFechaEmision() {
            return this.fechaEmision;
        }

        public void setFechaEmision(String value) {
            this.fechaEmision = value;
        }

        public String getCodigo() {
            return this.codigo;
        }

        public void setCodigo(String value) {
            this.codigo = value;
        }

        public String getRazon() {
            return this.razon;
        }

        public void setRazon(String value) {
            this.razon = value;
        }
    }

    public static class DetalleServicio {
        protected List<LineaDetalle> lineaDetalle;

        public List<LineaDetalle> getLineaDetalle() {
            if (this.lineaDetalle == null) {
                this.lineaDetalle = new ArrayList<LineaDetalle>();
            }
            return this.lineaDetalle;
        }

        public static class LineaDetalle {
            protected BigInteger numeroLinea;
            protected List<CodigoType> codigo;
            protected BigDecimal cantidad;
            protected String unidadMedida;
            protected String unidadMedidaComercial;
            protected String detalle;
            protected BigDecimal precioUnitario;
            protected BigDecimal montoTotal;
            protected BigDecimal montoDescuento;
            protected String naturalezaDescuento;
            protected BigDecimal subTotal;
            protected List<ImpuestoType> impuesto;
            protected BigDecimal montoTotalLinea;
            protected BigDecimal exoneracionTotal;
            protected BigDecimal impuestoTotal;
            protected List<Impuesto> impuestos;

            public BigDecimal getExoneracionTotal() {
                BigDecimal temp = BigDecimal.ZERO;
                if (this.impuesto != null) {
                    for (ImpuestoType i : this.impuesto) {
                        if (i.getExoneracion() == null) continue;
                        temp = temp.add(i.getExoneracion().getMontoImpuesto());
                    }
                }
                return temp;
            }

            public void setExoneracionTotal(BigDecimal exoneracionTotal) {
                this.exoneracionTotal = exoneracionTotal;
            }

            public BigDecimal getImpuestoTotal() {
                BigDecimal temp = BigDecimal.ZERO;
                if (this.impuestoTotal != null) {
                    for (ImpuestoType i : this.impuesto) {
                        temp = temp.add(i.getMonto());
                    }
                }
                return temp;
            }

            public void setImpuestoTotal(BigDecimal impuestoTotal) {
                this.impuestoTotal = impuestoTotal;
            }

            public BigInteger getNumeroLinea() {
                return this.numeroLinea;
            }

            public void setNumeroLinea(BigInteger value) {
                this.numeroLinea = value;
            }

            public List<CodigoType> getCodigo() {
                if (this.codigo == null) {
                    this.codigo = new ArrayList<CodigoType>();
                }
                return this.codigo;
            }

            public BigDecimal getCantidad() {
                return this.cantidad;
            }

            public void setCantidad(BigDecimal value) {
                this.cantidad = value;
            }

            public String getUnidadMedida() {
                return this.unidadMedida;
            }

            public void setUnidadMedida(String value) {
                this.unidadMedida = value;
            }

            public String getUnidadMedidaComercial() {
                return this.unidadMedidaComercial;
            }

            public void setUnidadMedidaComercial(String value) {
                this.unidadMedidaComercial = value;
            }

            public String getDetalle() {
                return this.detalle;
            }

            public void setDetalle(String value) {
                this.detalle = value;
            }

            public BigDecimal getPrecioUnitario() {
                return this.precioUnitario;
            }

            public void setPrecioUnitario(BigDecimal value) {
                this.precioUnitario = value;
            }

            public BigDecimal getMontoTotal() {
                return this.montoTotal;
            }

            public void setMontoTotal(BigDecimal value) {
                this.montoTotal = value;
            }

            public BigDecimal getMontoDescuento() {
                return this.montoDescuento;
            }

            public void setMontoDescuento(BigDecimal value) {
                this.montoDescuento = value;
            }

            public String getNaturalezaDescuento() {
                return this.naturalezaDescuento;
            }

            public void setNaturalezaDescuento(String value) {
                this.naturalezaDescuento = value;
            }

            public BigDecimal getSubTotal() {
                return this.subTotal;
            }

            public void setSubTotal(BigDecimal value) {
                this.subTotal = value;
            }

            public List<ImpuestoType> getImpuesto() {
                if (this.impuesto == null) {
                    this.impuesto = new ArrayList<ImpuestoType>();
                }
                return this.impuesto;
            }

            public BigDecimal getMontoTotalLinea() {
                return this.montoTotalLinea;
            }

            public void setMontoTotalLinea(BigDecimal value) {
                this.montoTotalLinea = value;
            }

            public List<Impuesto> getImpuestos() {
                if (this.impuestos == null) {
                    this.impuestos = new ArrayList<Impuesto>();
                }
                return this.impuestos;
            }

            public void setImpuestos(List<Impuesto> impuestos) {
                this.impuestos = impuestos;
            }

            public static class Impuesto {
                protected BigDecimal tarifa;
                protected BigDecimal monto;

                public BigDecimal getTarifa() {
                    return this.tarifa;
                }

                public void setTarifa(BigDecimal tarifa) {
                    this.tarifa = tarifa;
                }

                public BigDecimal getMonto() {
                    return this.monto;
                }

                public void setMonto(BigDecimal monto) {
                    this.monto = monto;
                }
            }
        }
    }
}

