/*
 * Decompiled with CFR 0.152.
 */
package electricpos.util;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.GregorianCalendar;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class DateXMLGregorianCalendarAdapter
extends XmlAdapter<XMLGregorianCalendar, LocalDateTime> {
    public LocalDateTime unmarshal(XMLGregorianCalendar v) {
        if (v == null) {
            return null;
        }
        GregorianCalendar gc = v.toGregorianCalendar();
        ZonedDateTime z = gc.toZonedDateTime();
        return LocalDateTime.from(z);
    }

    public XMLGregorianCalendar marshal(LocalDateTime v) throws DatatypeConfigurationException {
        if (v == null) {
            return null;
        }
        ZonedDateTime z = ZonedDateTime.of(v, ZoneId.systemDefault());
        GregorianCalendar calendar = GregorianCalendar.from(z);
        DatatypeFactory dataTypeFactory = DatatypeFactory.newInstance();
        XMLGregorianCalendar xmlCalendar = dataTypeFactory.newXMLGregorianCalendar(calendar);
        return xmlCalendar;
    }
}

