/*
 * Decompiled with CFR 0.152.
 */
package electricpos.util;

import electricpos.model.TokenDto;
import electricpos.util.AppContext;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;

public final class ExternalRequest {
    private final Client client = ClientBuilder.newClient();
    private Invocation.Builder builder;
    private WebTarget webTarget;
    private Response response;
    private Future<Response> responseFuture;

    public ExternalRequest() {
    }

    public ExternalRequest(String urlBase, String target) {
        this();
        this.setTarget(urlBase, target);
    }

    public void setTarget(String urlBase, String target) {
        this.webTarget = this.client.target(urlBase).path(target);
        this.builder = this.createBuilder();
    }

    private Invocation.Builder createBuilder() {
        MultivaluedHashMap headers = new MultivaluedHashMap();
        headers.add((Object)"Content-Type", (Object)"application/json; charset=UTF-8");
        TokenDto token = (TokenDto)AppContext.getInstance().get("Token");
        if (token != null) {
            headers.add((Object)"Authorization", (Object)("Bearer " + token.getToken()));
        }
        return this.webTarget.request(new String[]{"application/json"}).headers((MultivaluedMap)headers);
    }

    public void addHeaders(Map<String, Object> headers) {
        headers.forEach((key, value) -> this.builder.header(key, value));
    }

    public void addQueryParams(Map<String, Object> queryParams) {
        queryParams.forEach((key, value) -> {
            if (value instanceof List) {
                for (Object item : (List)value) {
                    this.webTarget = this.webTarget.queryParam(key, new Object[]{item});
                }
            } else {
                this.webTarget = this.webTarget.queryParam(key, new Object[]{value});
            }
        });
        this.builder = this.createBuilder();
    }

    public void get() {
        this.response = this.builder.get();
    }

    public void getAsync() {
        this.responseFuture = this.builder.async().get();
    }

    public void post(Object entity) {
        this.response = this.builder.post(Entity.entity((Object)entity, (String)"application/json"));
    }

    public void put(Object entity) {
        this.response = this.builder.put(Entity.entity((Object)entity, (String)"application/json"));
    }

    public void delete() {
        this.response = this.builder.delete();
    }

    public int getStatus() {
        return this.response.getStatus();
    }

    public int getStatusAsync() throws InterruptedException, ExecutionException {
        return this.responseFuture.get().getStatus();
    }

    public boolean isError() {
        return this.getStatus() >= 400;
    }

    public String getErrorMessage() {
        if (this.isError()) {
            return (String)this.response.readEntity(String.class);
        }
        return null;
    }

    public <T> T readEntity(Class<T> clazz) {
        return (T)this.response.readEntity(clazz);
    }

    public <T> T readEntity(GenericType<T> genericType) {
        return (T)this.response.readEntity(genericType);
    }
}

