/*
 * Decompiled with CFR 0.152.
 */
package electricpos.util;

import electricpos.model.GlobalApp;
import electricpos.model.NotificacionType;
import electricpos.util.NotificacionHelper;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FacturacionUtil {
    public static boolean isValidCertificate() {
        if (!GlobalApp.isCertificadoSeguridadVigente.booleanValue()) {
            NotificacionHelper.dispararNotificacion(NotificacionType.ERROR, "\u274c El certificado de seguridad de Hacienda ha vencido. Debe renovarse para poder facturar nuevamente.");
        }
        return GlobalApp.isCertificadoSeguridadVigente;
    }

    public static String extraerCodigoInstitucion(String texto) {
        if (texto == null) {
            return "01";
        }
        Pattern pattern = Pattern.compile("\\b(\\d{2})\\b");
        Matcher matcher = pattern.matcher(texto);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "01";
    }

    public static int ajustarPorcentajeExoneracion(double puntosExoneracion, double porcentajeIVA) {
        if (puntosExoneracion <= 0.0 || porcentajeIVA <= 0.0) {
            return 0;
        }
        int puntos = (int)Math.round(puntosExoneracion * 100.0);
        int ivaPuntos = (int)Math.round(porcentajeIVA);
        return Math.min(puntos, ivaPuntos);
    }
}

