/*
 * Decompiled with CFR 0.152.
 */
package electricpos.util;

import java.text.DecimalFormat;
import java.text.ParsePosition;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.regex.Pattern;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.TextInputControl;

public class Formato {
    private static Formato INSTANCE = null;
    public DateTimeFormatter formatDateShort = DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT);
    public DateTimeFormatter formatDateMedium = DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM);
    public DecimalFormat decimalFormat = new DecimalFormat("#,###,###,##0.00");

    private Formato() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void createInstance() {
        if (INSTANCE != null) return;
        Class<Formato> clazz = Formato.class;
        synchronized (Formato.class) {
            if (INSTANCE != null) return;
            INSTANCE = new Formato();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static Formato getInstance() {
        if (INSTANCE == null) {
            Formato.createInstance();
        }
        return INSTANCE;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public TextFormatter twoDecimalFormat() {
        TextFormatter numericFormat = new TextFormatter(c -> {
            if (c.getControlNewText().isEmpty()) {
                return c;
            }
            if (c.getControlNewText().contains(",")) {
                ParsePosition parsePosition = new ParsePosition(0);
                Number object = this.decimalFormat.parse(c.getControlNewText(), parsePosition);
                if (object == null || parsePosition.getIndex() < c.getControlNewText().length()) {
                    return null;
                }
                Pattern validDoubleText = Pattern.compile("^[0-9]*+(\\.[0-9]{0,2})?$");
                if (validDoubleText.matcher(c.getControlNewText().replace(",", "")).matches()) {
                    return c;
                }
                return null;
            }
            Pattern validDoubleText = Pattern.compile("^[0-9]*+(\\.[0-9]{0,2})?$");
            if (validDoubleText.matcher(c.getControlNewText().replace(",", "")).matches()) {
                return c;
            }
            return null;
        });
        return numericFormat;
    }

    public TextFormatter integerFormat(Integer length) {
        TextFormatter numericFormat = new TextFormatter(c -> {
            if (c.getControlNewText().isEmpty() && length >= ((TextInputControl)c.getControl()).getLength()) {
                return c;
            }
            if (((TextInputControl)c.getControl()).getLength() >= length && !c.isDeleted()) {
                return null;
            }
            if (c.getText().length() > length && !c.isDeleted()) {
                return null;
            }
            Pattern validDoubleText = Pattern.compile("\\d+");
            if (validDoubleText.matcher(c.getControlNewText()).matches()) {
                return c;
            }
            return null;
        });
        return numericFormat;
    }

    public TextFormatter cedulaFormat(Integer maxLength) {
        TextFormatter cedulaFormat = new TextFormatter(c -> {
            if (c.getControlNewText().isEmpty()) {
                return c;
            }
            if (maxLength > 0) {
                if (((TextInputControl)c.getControl()).getLength() >= maxLength && !c.isDeleted()) {
                    return null;
                }
                if (c.getText().length() > maxLength && !c.isDeleted()) {
                    return null;
                }
            }
            c.setText(c.getText().replaceAll("[^a-zA-Z0-9-]", ""));
            if (c.getControlNewText().matches(".*-{2,}.*")) {
                return null;
            }
            return c;
        });
        return cedulaFormat;
    }

    public TextFormatter letrasFormat(Integer maxLength) {
        TextFormatter letrasFormat = new TextFormatter(c -> {
            if (c.getControlNewText().isEmpty()) {
                return c;
            }
            if (maxLength > 0) {
                if (((TextInputControl)c.getControl()).getLength() >= maxLength && !c.isDeleted()) {
                    return null;
                }
                if (c.getText().length() > maxLength && !c.isDeleted()) {
                    return null;
                }
            }
            c.setText(c.getText().replaceAll("[^a-zA-Z ]", ""));
            if (c.getControlNewText().matches(".*\\s{2,}.*")) {
                return null;
            }
            return c;
        });
        return letrasFormat;
    }

    public TextFormatter maxLengthFormat(Integer length) {
        TextFormatter maxLengthFormat = new TextFormatter(c -> {
            if (c.getControlNewText().isEmpty()) {
                return c;
            }
            if (((TextInputControl)c.getControl()).getLength() >= length && !c.isDeleted()) {
                return null;
            }
            if (c.getText().length() > length && !c.isDeleted()) {
                return null;
            }
            return c;
        });
        return maxLengthFormat;
    }
}

