/*
 * Decompiled with CFR 0.152.
 */
package electricpos.util;

import com.jfoenix.controls.JFXTextField;
import electricpos.controller.ActualizacionViewController;
import electricpos.controller.BusquedaClienteViewController;
import electricpos.controller.BusquedaProductoServicioViewController;
import electricpos.controller.CabysViewController;
import electricpos.controller.ClienteViewController;
import electricpos.controller.ColaboradorFacViewController;
import electricpos.controller.FacturacionObsViewController;
import electricpos.controller.MantProductoServicioViewController;
import electricpos.controller.MantReceptorViewController;
import electricpos.controller.MediosPagoViewController;
import electricpos.controller.MensajeCabysViewController;
import electricpos.controller.MensajeConfirmacionInputViewController;
import electricpos.controller.MensajeConfirmacionViewController;
import electricpos.controller.MensajeEliminarViewController;
import electricpos.controller.MensajeInfoViewController;
import electricpos.controller.ModalInputViewController;
import electricpos.controller.ModalPlazoCreditoController;
import electricpos.controller.ModalTipoDescuentoViewController;
import electricpos.controller.ParametrosGeneController;
import electricpos.controller.PrincipalController;
import electricpos.controller.WaitingViewController;
import electricpos.model.CabysTv;
import electricpos.model.CajaDto;
import electricpos.model.CodigoDescuentoDto;
import electricpos.model.Colaborador;
import electricpos.model.ComprobanteElectronicoDto;
import electricpos.model.Customer;
import electricpos.model.DetalleComprobanteTv;
import electricpos.model.EmpresaDto;
import electricpos.model.ExchangeRate;
import electricpos.model.GlobalApp;
import electricpos.model.MedioPagoDto;
import electricpos.model.ProductoServicioDto;
import electricpos.model.ReceptorDto;
import electricpos.service.CajasService;
import electricpos.service.CustomerService;
import electricpos.service.EmpresaService;
import electricpos.service.ExchangeRateService;
import electricpos.service.ProductoServicioService;
import electricpos.util.AppContext;
import electricpos.util.ESTADO;
import electricpos.util.Respuesta;
import electricpos.util.VALIDACION;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.layout.AnchorPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.PrinterName;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRPrintServiceExporter;
import net.sf.jasperreports.engine.export.JRPrintServiceExporterParameter;

public class FuncionesGenerales {
    static DateTimeFormatter formatter = DateTimeFormatter.ofPattern("EEEE, dd MMMM yyyy hh:mm:ss a");
    static DateTimeFormatter formatterDateApi = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    static DateTimeFormatter formatterDate = DateTimeFormatter.ofPattern("EEEE, dd MMMM yyyy");
    static DateTimeFormatter formatterSort = DateTimeFormatter.ofPattern("dd/MM/yyyy hh:mm:ss a");
    static DecimalFormat formatterDecimal = new DecimalFormat("#,##0.00");

    public String MostrarInputModal(String valorEntrada, String titulo) {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/ModalInputView.fxml"));
        Parent root1 = null;
        try {
            root1 = (Parent)fxmlLoader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(ParametrosGeneController.class.getName()).log(Level.SEVERE, null, ex);
        }
        ModalInputViewController modalInputViewController = (ModalInputViewController)fxmlLoader.getController();
        modalInputViewController.setTxtValor(valorEntrada);
        modalInputViewController.lblTitulo.setText(titulo);
        FuncionesGenerales.showView(root1);
        return modalInputViewController.getTxtValor();
    }

    public String MostrarPlazoCreditoModal(String valorEntrada) {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/ModalPlazoCredito.fxml"));
        Parent root1 = null;
        try {
            root1 = (Parent)fxmlLoader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(ParametrosGeneController.class.getName()).log(Level.SEVERE, null, ex);
        }
        ModalPlazoCreditoController modalInputViewController = (ModalPlazoCreditoController)fxmlLoader.getController();
        modalInputViewController.setTxtValor(valorEntrada);
        FuncionesGenerales.showView(root1);
        return modalInputViewController.getTxtValor();
    }

    public void closeSession(Scene scene) {
        try {
            Stage stage = (Stage)scene.getWindow();
            Parent root = (Parent)FXMLLoader.load((URL)this.getClass().getResource("/electricpos/view/LoginView.fxml"));
            stage.setScene(new Scene(root));
            stage.centerOnScreen();
            stage.show();
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public Boolean isValidSession() {
        return LocalDateTime.now().isBefore(GlobalApp.sessionExpirationTime) || GlobalApp.alDia != false;
    }

    public Stage MostrarLoading() {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/LoadingView.fxml"));
        Parent root1 = null;
        try {
            root1 = (Parent)fxmlLoader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(ParametrosGeneController.class.getName()).log(Level.SEVERE, null, ex);
        }
        Stage stage = new Stage();
        stage.setScene(new Scene(root1));
        stage.initStyle(StageStyle.UNDECORATED);
        stage.initModality(Modality.APPLICATION_MODAL);
        return stage;
    }

    public static void procesaVBoxNotificaciones() {
        if (GlobalApp.vBoxNotificaciones.getChildren().size() >= 10) {
            GlobalApp.vBoxNotificaciones.getChildren().clear();
        }
        if (GlobalApp.vBoxNotificaciones.getChildren().size() == 0) {
            GlobalApp.vBoxNotificaciones.setVisible(false);
        }
    }

    public boolean mostrarComprobanteHilo(ComprobanteElectronicoDto comp) {
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/WaitingView.fxml"));
            AnchorPane ancho = (AnchorPane)fxmlLoader.load();
            GlobalApp.vBoxNotificaciones.getChildren().add((Object)ancho);
            WaitingViewController waitingViewController = (WaitingViewController)fxmlLoader.getController();
            waitingViewController.setAnchorPane(ancho);
            waitingViewController.setTipo(comp.getTipoCom());
            waitingViewController.setComprobanteElectronicoDto(comp);
            waitingViewController.enviarComprobanteElectronico();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void MostrarModalInfo(String valorEntrada) {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/MensajeInfoView.fxml"));
        Parent root1 = null;
        try {
            root1 = (Parent)fxmlLoader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(ParametrosGeneController.class.getName()).log(Level.SEVERE, null, ex);
        }
        MensajeInfoViewController MensajeInfoViewController2 = (MensajeInfoViewController)fxmlLoader.getController();
        MensajeInfoViewController2.setMensaje(valorEntrada);
        FuncionesGenerales.showView(root1);
    }

    public String mostrarModalObsFacturacion(String obs) {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/FacturacionObsView.fxml"));
        Parent root1 = null;
        try {
            root1 = (Parent)fxmlLoader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(ParametrosGeneController.class.getName()).log(Level.SEVERE, null, ex);
        }
        FacturacionObsViewController controller = (FacturacionObsViewController)fxmlLoader.getController();
        controller.setObservaciones(obs);
        FuncionesGenerales.showView(root1);
        if (controller.guardo.booleanValue()) {
            return controller.observaciones;
        }
        return obs;
    }

    public boolean mostrarModalValidaCabys(ProductoServicioDto productoServicioDto) {
        if (productoServicioDto.getCodigoCabys() == null || productoServicioDto.getCodigoCabys().isEmpty()) {
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/MensajeCabysView.fxml"));
            Parent root1 = null;
            try {
                root1 = (Parent)fxmlLoader.load();
            }
            catch (IOException ex) {
                Logger.getLogger(ParametrosGeneController.class.getName()).log(Level.SEVERE, null, ex);
            }
            MensajeCabysViewController controller = (MensajeCabysViewController)fxmlLoader.getController();
            controller.setProductoServicio(productoServicioDto);
            FuncionesGenerales.showView(root1);
            if (controller.isAsignar()) {
                CabysTv cabysSeleccionado = this.mostrarBusquedaCabys();
                if (cabysSeleccionado == null) {
                    return false;
                }
                productoServicioDto.setCodigoCabys(cabysSeleccionado.getCodigo());
                ProductoServicioService service = (ProductoServicioService)AppContext.getInstance().get("ProductoServicioService");
                Respuesta respuesta = service.saveProductoServicio(productoServicioDto);
                if (respuesta.getEstado().booleanValue()) {
                    this.MostrarModalInfo("Producto/Servicio actualizado correctamente.");
                    return true;
                }
                this.MostrarModalInfo("Error al actualizar el c\u00f3digo CABYS del Producto/Servicio.");
                return true;
            }
            return false;
        }
        return true;
    }

    private CabysTv mostrarBusquedaCabys() {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/CabysView.fxml"));
        Parent root1 = null;
        try {
            root1 = (Parent)fxmlLoader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(MantProductoServicioViewController.class.getName()).log(Level.SEVERE, null, ex);
        }
        CabysViewController controller = (CabysViewController)fxmlLoader.getController();
        FuncionesGenerales.showView(root1);
        if (controller.selecciono) {
            return controller.cabysSeleccionado;
        }
        return null;
    }

    public void MostrarModalActualizacion(File file) {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/ActualizacionView.fxml"));
        Parent root1 = null;
        try {
            root1 = (Parent)fxmlLoader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(ParametrosGeneController.class.getName()).log(Level.SEVERE, null, ex);
        }
        ActualizacionViewController controller = (ActualizacionViewController)fxmlLoader.getController();
        controller.setFile(file);
        FuncionesGenerales.showView(root1);
    }

    public boolean getConfirmacionMensajeView(String valorEntrada) {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/MensajeConfirmacionView.fxml"));
        Parent root1 = null;
        try {
            root1 = (Parent)fxmlLoader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(ParametrosGeneController.class.getName()).log(Level.SEVERE, null, ex);
        }
        MensajeConfirmacionViewController controller = (MensajeConfirmacionViewController)fxmlLoader.getController();
        controller.setMensaje(valorEntrada);
        FuncionesGenerales.showView(root1);
        return controller.isContinuar();
    }

    public String getConfirmacionMensajeInputView(String valorEntrada) {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/MensajeConfirmacionInputView.fxml"));
        Parent root1 = null;
        try {
            root1 = (Parent)fxmlLoader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(ParametrosGeneController.class.getName()).log(Level.SEVERE, null, ex);
        }
        MensajeConfirmacionInputViewController controller = (MensajeConfirmacionInputViewController)fxmlLoader.getController();
        controller.setMensaje(valorEntrada);
        FuncionesGenerales.showView(root1);
        return controller.observacion;
    }

    public boolean getConfirmacionEliminacion() {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/MensajeEliminarView.fxml"));
        Parent root1 = null;
        try {
            root1 = (Parent)fxmlLoader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(ParametrosGeneController.class.getName()).log(Level.SEVERE, null, ex);
        }
        MensajeEliminarViewController controller = (MensajeEliminarViewController)fxmlLoader.getController();
        FuncionesGenerales.showView(root1);
        return controller.isDelete();
    }

    public List<MedioPagoDto> MostrarModalMedioPago(List<MedioPagoDto> mediosPago, BigDecimal montoFactura) {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/MediosPagoView.fxml"));
        Parent root1 = null;
        try {
            root1 = (Parent)fxmlLoader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(ParametrosGeneController.class.getName()).log(Level.SEVERE, null, ex);
        }
        MediosPagoViewController mediosPagoViewController = (MediosPagoViewController)fxmlLoader.getController();
        mediosPagoViewController.cargarMediosPago(mediosPago, montoFactura);
        FuncionesGenerales.showView(root1);
        return mediosPagoViewController.mediosPago;
    }

    public CodigoDescuentoDto MostrarModalDescuento(DetalleComprobanteTv tv) {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/ModalTipoDescuentoView.fxml"));
        Parent root1 = null;
        try {
            root1 = (Parent)fxmlLoader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(ParametrosGeneController.class.getName()).log(Level.SEVERE, null, ex);
        }
        CodigoDescuentoDto origalDescuento = new CodigoDescuentoDto(tv.getCodigoDescuento(), tv.getMontoDescuento());
        ModalTipoDescuentoViewController controller = (ModalTipoDescuentoViewController)fxmlLoader.getController();
        controller.setDetalleComprobanteTv(tv);
        FuncionesGenerales.showView(root1);
        if (controller.isCancelled()) {
            return origalDescuento;
        }
        return controller.getDescuento();
    }

    public ReceptorDto ReceptorViewController(ReceptorDto receptor) {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/MantReceptorView.fxml"));
        Parent root1 = null;
        try {
            root1 = (Parent)fxmlLoader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(ParametrosGeneController.class.getName()).log(Level.SEVERE, null, ex);
        }
        MantReceptorViewController receptorViewController = (MantReceptorViewController)fxmlLoader.getController();
        receptorViewController.setReceptor(receptor);
        FuncionesGenerales.showView(root1);
        return receptorViewController.receptorDto;
    }

    public ProductoServicioDto mostrarBusquedaPS(Integer idEmisor, Integer idSucursal, String invCompartido) {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/BusquedaProductoServicioView.fxml"));
        Parent root1 = null;
        try {
            root1 = (Parent)fxmlLoader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(ParametrosGeneController.class.getName()).log(Level.SEVERE, null, ex);
        }
        BusquedaProductoServicioViewController viewController = (BusquedaProductoServicioViewController)fxmlLoader.getController();
        viewController.setIdEmisor(idEmisor);
        viewController.setIdSucursal(idSucursal);
        viewController.setInvCompartido(invCompartido);
        FuncionesGenerales.showView(root1);
        if (viewController.selecciono) {
            return viewController.getProductosServicioSeleccionado();
        }
        return null;
    }

    public ReceptorDto ClienteViewController(Integer idEmisor, ReceptorDto receptor, Boolean validateCustomer) {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/ClienteView.fxml"));
        Parent root1 = null;
        try {
            root1 = (Parent)fxmlLoader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(ParametrosGeneController.class.getName()).log(Level.SEVERE, null, ex);
        }
        ClienteViewController clienteViewController = (ClienteViewController)fxmlLoader.getController();
        clienteViewController.setIdEmisor(idEmisor);
        clienteViewController.setReceptor(receptor);
        if (validateCustomer.booleanValue()) {
            clienteViewController.validateCustomer(receptor.getNumeroIdentificacion());
        }
        FuncionesGenerales.showView(root1);
        return clienteViewController.receptorDto;
    }

    public ReceptorDto BusquedaClientesController(Integer idEmisor) {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/BusquedaClienteView.fxml"));
        Parent root1 = null;
        try {
            root1 = (Parent)fxmlLoader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(ParametrosGeneController.class.getName()).log(Level.SEVERE, null, ex);
        }
        BusquedaClienteViewController busquedaClienteViewController = (BusquedaClienteViewController)fxmlLoader.getController();
        busquedaClienteViewController.setIdEmisor(idEmisor);
        FuncionesGenerales.showView(root1);
        if (busquedaClienteViewController.selecciono) {
            return busquedaClienteViewController.getReceptorSeleccionado();
        }
        return null;
    }

    public Colaborador mostrarColaboradorFactView(Colaborador colaboradorActual) {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/ColaboradorFacView.fxml"));
        Parent root1 = null;
        try {
            root1 = (Parent)fxmlLoader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(ParametrosGeneController.class.getName()).log(Level.SEVERE, null, ex);
        }
        ColaboradorFacViewController controller = (ColaboradorFacViewController)fxmlLoader.getController();
        controller.setColaboradorActual(colaboradorActual);
        FuncionesGenerales.showView(root1);
        if (controller.aplico.booleanValue()) {
            return controller.getColaboradorActual();
        }
        return colaboradorActual;
    }

    public List<MedioPagoDto> llenarMedioPagos() {
        ArrayList<MedioPagoDto> mediosPago = new ArrayList<MedioPagoDto>();
        MedioPagoDto medio1 = new MedioPagoDto("01", "Efectivo", new BigDecimal(BigInteger.ZERO), true);
        MedioPagoDto medio2 = new MedioPagoDto("02", "Tarjeta", new BigDecimal(BigInteger.ZERO), false);
        MedioPagoDto medio3 = new MedioPagoDto("03", "Cheque", new BigDecimal(BigInteger.ZERO), false);
        MedioPagoDto medio4 = new MedioPagoDto("04", "Transferencia \u2013 dep\u00f3sito bancario", new BigDecimal(BigInteger.ZERO), false);
        MedioPagoDto medio5 = new MedioPagoDto("05", "Recaudado por terceros", new BigDecimal(BigInteger.ZERO), false);
        MedioPagoDto medio6 = new MedioPagoDto("06", "Sinpe movil", new BigDecimal(BigInteger.ZERO), false);
        MedioPagoDto medio7 = new MedioPagoDto("07", "Plataforma digital", new BigDecimal(BigInteger.ZERO), false);
        MedioPagoDto medio8 = new MedioPagoDto("99", "Otro", new BigDecimal(BigInteger.ZERO), false);
        mediosPago.add(medio1);
        mediosPago.add(medio2);
        mediosPago.add(medio3);
        mediosPago.add(medio4);
        mediosPago.add(medio5);
        mediosPago.add(medio6);
        mediosPago.add(medio7);
        mediosPago.add(medio8);
        return mediosPago;
    }

    public Image obtenerImagen(String nombre) {
        try {
            Image image = new Image("/electricpos/resources/" + nombre);
            return image;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static void setValidationTextField(final JFXTextField textField, final VALIDACION validacion) {
        textField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!newValue.matches(validacion.VALUE())) {
                    textField.setText(oldValue);
                }
            }
        });
    }

    public static void setValidationTextField(final TextField textField, final VALIDACION validacion) {
        textField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!newValue.matches(validacion.VALUE())) {
                    textField.setText(oldValue);
                }
            }
        });
    }

    public static boolean validateEmail(String email) {
        String regex = "\\s*\\w+([-+.']\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*\\s*";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(email);
        return matcher.matches();
    }

    public static boolean isVersion(String versionDocBd, String versionDocWs) {
        try {
            return versionDocWs.equalsIgnoreCase(versionDocBd);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getDateFormated(LocalDateTime date) {
        if (date != null) {
            return date.format(formatter);
        }
        return null;
    }

    public static String getDateSimpleFormated(LocalDateTime date) {
        if (date != null) {
            return date.format(formatterDate);
        }
        return null;
    }

    public static String getDateApiFormated(LocalDateTime date) {
        if (date != null) {
            return date.format(formatterDateApi);
        }
        return null;
    }

    public static String getDateFormatedSort(LocalDateTime date) {
        if (date != null) {
            return date.format(formatterSort);
        }
        return null;
    }

    public static String getDecimalFormated(BigDecimal value) {
        if (value != null) {
            return formatterDecimal.format(value);
        }
        return null;
    }

    public boolean isCajaAbierta() {
        this.getUltimaCaja();
        return GlobalApp.cajaActual != null && GlobalApp.cajaActual.getId() != null && !GlobalApp.cajaActual.getEstado().equalsIgnoreCase("C");
    }

    public CajaDto getUltimaCaja() {
        CajasService service = (CajasService)AppContext.getInstance().get("CajasService");
        Respuesta respuesta = service.getUltimaCaja(GlobalApp.idSucursal);
        CajaDto cajaDto = null;
        if (respuesta.getEstado().booleanValue()) {
            cajaDto = (CajaDto)respuesta.getResultado(ESTADO.OK.VALUE());
        }
        GlobalApp.cajaActual = cajaDto;
        return cajaDto;
    }

    public static void showView(Parent root1) {
        Stage stage = new Stage();
        Scene scene = new Scene(root1);
        stage.setScene(scene);
        stage.initStyle(StageStyle.UNDECORATED);
        scene.setFill((Paint)Color.TRANSPARENT);
        stage.setMaximized(true);
        stage.initStyle(StageStyle.TRANSPARENT);
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.showAndWait();
    }

    public boolean printInvoice(JasperPrint jasperPrint) {
        try {
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            PageFormat pageFormat = PrinterJob.getPrinterJob().defaultPage();
            printerJob.defaultPage(pageFormat);
            int selectedService = 0;
            String printerNameShort = null;
            EmpresaDto empresa = this.getEmpresaParam();
            if (empresa != null) {
                printerNameShort = empresa.getImpresoraService();
            }
            HashPrintServiceAttributeSet attributeSet = new HashPrintServiceAttributeSet(new PrinterName(printerNameShort, null));
            PrintService[] printServiceDefault = PrintServiceLookup.lookupPrintServices(null, attributeSet);
            try {
                printerJob.setPrintService(printServiceDefault[selectedService]);
            }
            catch (PrinterException e) {
                printServiceDefault = PrintServiceLookup.lookupPrintServices(null, null);
            }
            HashPrintRequestAttributeSet printRequestAttributeSet = new HashPrintRequestAttributeSet();
            printRequestAttributeSet.add(new Copies(1));
            JRPrintServiceExporter exporter = new JRPrintServiceExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
            exporter.setParameter((JRExporterParameter)JRPrintServiceExporterParameter.PRINT_SERVICE, (Object)printServiceDefault[selectedService]);
            exporter.setParameter((JRExporterParameter)JRPrintServiceExporterParameter.PRINT_SERVICE_ATTRIBUTE_SET, (Object)printServiceDefault[selectedService].getAttributes());
            exporter.setParameter((JRExporterParameter)JRPrintServiceExporterParameter.PRINT_REQUEST_ATTRIBUTE_SET, (Object)printRequestAttributeSet);
            exporter.setParameter((JRExporterParameter)JRPrintServiceExporterParameter.DISPLAY_PAGE_DIALOG, (Object)Boolean.FALSE);
            exporter.setParameter((JRExporterParameter)JRPrintServiceExporterParameter.DISPLAY_PRINT_DIALOG, (Object)Boolean.FALSE);
            exporter.exportReport();
            return true;
        }
        catch (JRException e) {
            FuncionesGenerales funcionesGenerales = new FuncionesGenerales();
            funcionesGenerales.MostrarModalInfo("No se pudo imprimir el tiquete. Error: " + e.getMessage());
            return false;
        }
    }

    private EmpresaDto getEmpresaParam() {
        EmpresaService service = (EmpresaService)AppContext.getInstance().get("EmpresaService");
        Respuesta respuesta = service.getEmpresa(GlobalApp.idEmpresa);
        if (respuesta.getEstado().booleanValue()) {
            EmpresaDto empresaDto = (EmpresaDto)respuesta.getResultado("Empresa");
            return empresaDto;
        }
        return null;
    }

    public static CompletableFuture<Optional<Customer>> fetchCustomerAsync(String numeroIdentificacion) {
        CustomerService customerService = (CustomerService)AppContext.getInstance().get("CustomerService");
        return CompletableFuture.supplyAsync(() -> {
            Respuesta respuesta = customerService.getCustomer(numeroIdentificacion);
            if (respuesta.getEstado().booleanValue()) {
                return Optional.ofNullable((Customer)respuesta.getResultado(ESTADO.OK.VALUE()));
            }
            return Optional.empty();
        });
    }

    public static CompletableFuture<Optional<ExchangeRate>> fetchExchangeRateAsync() {
        ExchangeRateService exchangeRateService = (ExchangeRateService)AppContext.getInstance().get("ExchangeRateService");
        return CompletableFuture.supplyAsync(() -> {
            Respuesta respuesta = exchangeRateService.getExchangeRate();
            if (respuesta.getEstado().booleanValue()) {
                return Optional.ofNullable((ExchangeRate)respuesta.getResultado(ESTADO.OK.VALUE()));
            }
            return Optional.empty();
        });
    }
}

