/*
 * Decompiled with CFR 0.152.
 */
package electricpos.util;

import electricpos.model.LocalMetaData;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class LocalStorageHelper {
    Connection connection = null;
    Statement stmt = null;
    LocalMetaData localMetaData = null;

    public void initializer() {
        this.initialization();
    }

    private void initialization() {
        if (this.setLocalConnection()) {
            try {
                this.connection.setAutoCommit(false);
                this.stmt = this.connection.createStatement();
                String sql = "CREATE TABLE IF NOT EXISTS METADATA (ID INT PRIMARY KEY     NOT NULL, KEY           TEXT    NOT NULL,  BLOCKER            TEXT     NOT NULL,  CHECKED           INTEGER    NOT NULL); ";
                this.stmt.executeUpdate(sql);
                this.connection.commit();
                this.stmt.close();
                this.getActualData();
                if (this.localMetaData == null) {
                    this.setDefaultMetaData();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void updateMetaData(LocalMetaData data) {
        try {
            this.stmt = this.connection.createStatement();
            String sql = "UPDATE METADATA set KEY = ?, BLOCKER = ?, CHECKED = ? where ID=1;";
            PreparedStatement pstmt = this.connection.prepareStatement(sql);
            pstmt.setString(1, data.getKey());
            pstmt.setString(2, data.getBlocker());
            pstmt.setInt(3, data.getChecked() != false ? 1 : 0);
            pstmt.executeUpdate();
            this.connection.commit();
            pstmt.close();
        }
        catch (Exception e) {
            System.err.println(e.getClass().getName() + ": " + e.getMessage());
        }
    }

    public boolean setLocalConnection() {
        try {
            Class.forName("org.sqlite.JDBC");
            this.connection = DriverManager.getConnection("jdbc:sqlite:local.db");
            return true;
        }
        catch (Exception e) {
            System.err.println(e.getClass().getName() + ": " + e.getMessage());
            this.connection = null;
            return false;
        }
    }

    public LocalMetaData getActualData() {
        try {
            this.connection.setAutoCommit(false);
            this.stmt = this.connection.createStatement();
            ResultSet rs = this.stmt.executeQuery("SELECT * FROM METADATA;");
            while (rs.next()) {
                int id = rs.getInt("id");
                String key = rs.getString("key");
                String blocker = rs.getString("blocker");
                int checked = rs.getInt("checked");
                this.localMetaData = new LocalMetaData(id, key, blocker, checked == 1);
            }
            this.stmt.close();
            return this.localMetaData;
        }
        catch (Exception e) {
            System.err.println(e.getClass().getName() + ": " + e.getMessage());
            return null;
        }
    }

    private boolean setDefaultMetaData() {
        try {
            this.stmt = this.connection.createStatement();
            String sql = "INSERT INTO METADATA (ID,KEY,BLOCKER,CHECKED) VALUES (1, '', '','0');";
            this.stmt.executeUpdate(sql);
            this.stmt.close();
            this.connection.commit();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

